/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.command.commands;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.Season;
import net.minecraft.src.World;
import net.minecraft.src.command.Command;
import net.minecraft.src.command.CommandError;
import net.minecraft.src.command.CommandHandler;
import net.minecraft.src.command.CommandSender;
import net.minecraft.src.command.PlayerCommandSender;
import net.minecraft.src.command.ServerCommandHandler;

public class TimeCommand
extends Command {
    public static Map<String, Integer> dayTimeStrings = new HashMap<String, Integer>();
    public static Map<String, Season> seasonStrings;

    public TimeCommand() {
        super("time", new String[0]);
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        if (args.length == 0) {
            return false;
        }
        World world = null;
        if (sender instanceof PlayerCommandSender) {
            world = sender.getPlayer().worldObj;
        }
        if (handler instanceof ServerCommandHandler) {
            ServerCommandHandler server = (ServerCommandHandler)handler;
            if (args[0].equalsIgnoreCase("get") && args.length > 1) {
                world = server.minecraftServer.getWorldManager(Integer.parseInt(args[1]));
            }
            if (args[0].equalsIgnoreCase("set") && args.length > 2) {
                world = server.minecraftServer.getWorldManager(Integer.parseInt(args[2]));
            }
        }
        if (world == null) {
            throw new CommandError("Must be used by a player, or a dimension must be defined.");
        }
        if (args[0].equalsIgnoreCase("get")) {
            sender.sendMessage("The time in dimension " + world.dimension.dimId + " is " + world.getWorldTime());
            return true;
        }
        if (args[0].equalsIgnoreCase("set")) {
            String timeStr = args[1];
            long time = TimeCommand.parseTime(timeStr, world);
            world.setWorldTime(time);
            handler.sendCommandFeedback(sender, "Set the time to " + time + " in dimension " + world.dimension.dimId);
            return true;
        }
        return false;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/time get <dimension>");
        sender.sendMessage("/time set <time> <dimension>");
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    public static long parseTime(String timeString, World world) {
        Map.Entry<String, Integer> dayTimeEntry;
        int daylength = Minecraft.DAY_LENGTH_TICKS;
        long time = world.getWorldTime() / (long)daylength * (long)daylength;
        if (TimeCommand.isNumber(timeString)) {
            return Long.parseLong(timeString);
        }
        Map.Entry<String, Season> seasonEntry = TimeCommand.getEntryStartsWithIgnoreCase(seasonStrings, timeString);
        if (seasonEntry != null) {
            timeString = timeString.substring(seasonEntry.getKey().length());
            int yearLength = 0;
            Integer seasonStart = null;
            for (Season season : world.getWorldType().seasons) {
                if (season == seasonEntry.getValue()) {
                    seasonStart = yearLength;
                }
                yearLength += season.lengthTicks;
            }
            if (seasonStart == null) {
                throw new CommandError("Invalid Season " + seasonEntry.getValue().getName() + " for dimension " + world.dimension.getName());
            }
            time = time / (long)yearLength * (long)yearLength;
            time += (long)seasonStart.intValue();
            if (TimeCommand.isNumber(timeString)) {
                int seasonDays;
                int i2 = Integer.parseInt(timeString);
                if (i2 >= (seasonDays = seasonEntry.getValue().lengthTicks / daylength)) {
                    throw new CommandError("Season " + seasonEntry.getValue().getName() + " only has " + seasonDays + " days!");
                }
                time += (long)(i2 + 1) * (long)daylength;
            }
        }
        if ((dayTimeEntry = TimeCommand.getEntryStartsWithIgnoreCase(dayTimeStrings, timeString)) != null) {
            timeString = timeString.substring(dayTimeEntry.getKey().length());
            time += (long)dayTimeEntry.getValue().intValue();
        }
        return time;
    }

    public static boolean startsWithIgnoreCase(String a2, String b2) {
        if (a2.length() < b2.length()) {
            return false;
        }
        return a2.substring(0, b2.length()).equalsIgnoreCase(b2);
    }

    public static boolean isNumber(String s2) {
        if (s2 == null || s2.length() < 1) {
            return false;
        }
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            if (TimeCommand.isNumber(s2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    public static <E> Map.Entry<String, E> getEntryStartsWithIgnoreCase(Map<String, E> map, String str) {
        for (Map.Entry<String, E> entry : map.entrySet()) {
            if (!TimeCommand.startsWithIgnoreCase(str, entry.getKey())) continue;
            return entry;
        }
        return null;
    }

    static {
        dayTimeStrings.put("sunrise", 0);
        dayTimeStrings.put("day", 1000);
        dayTimeStrings.put("noon", 6000);
        dayTimeStrings.put("evening", 12000);
        dayTimeStrings.put("dusk", 12000);
        dayTimeStrings.put("sunset", 12000);
        dayTimeStrings.put("night", 15000);
        dayTimeStrings.put("midnight", 18000);
        seasonStrings = new HashMap<String, Season>();
        seasonStrings.put("spring", Season.surfaceSpring);
        seasonStrings.put("summer", Season.surfaceSummer);
        seasonStrings.put("autumn", Season.surfaceFall);
        seasonStrings.put("fall", Season.surfaceFall);
        seasonStrings.put("winter", Season.surfaceWinter);
    }
}

