/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.command.commands;

import net.minecraft.src.EntityPlayer;
import net.minecraft.src.command.ChatColor;
import net.minecraft.src.command.Command;
import net.minecraft.src.command.CommandHandler;
import net.minecraft.src.command.CommandSender;

public class WhisperCommand
extends Command {
    public WhisperCommand() {
        super("tell", "msg", "whisper");
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        if (args.length < 2) {
            return false;
        }
        EntityPlayer player = handler.getPlayer(args[0]);
        StringBuilder builder = new StringBuilder();
        for (int i2 = 1; i2 < args.length; ++i2) {
            builder.append(args[i2] + " ");
        }
        String msg = builder.toString();
        msg = sender.getName() + ChatColor.gray + " >> " + player.getDisplayName() + ChatColor.gray + ": " + ChatColor.lightGray + msg;
        sender.sendMessage(msg);
        if (sender.getPlayer() != player) {
            handler.sendMessageToPlayer(player, msg);
        }
        return true;
    }

    @Override
    public boolean opRequired(String[] args) {
        return false;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/msg <username> <message>");
    }
}

