/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.dynamictexture;

public abstract class DynamicTexture {
    public final int resolution;
    public final int textureIndex;
    public final int tileWidth;
    public final int tileHeight;
    public final byte[] imageData;
    protected boolean anaglyphEnabled = false;

    public DynamicTexture(int textureIndex, int resolution, int tileWidth) {
        this(textureIndex, resolution, tileWidth, tileWidth);
    }

    public DynamicTexture(int textureIndex, int resolution, int tileWidth, int tileHeight) {
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.textureIndex = textureIndex;
        this.resolution = resolution;
        this.imageData = new byte[resolution * resolution * 4];
    }

    public abstract void update();

    public abstract String getTextureName();

    public static int pmod(int a2, int b2) {
        while (a2 < 0) {
            a2 += b2;
        }
        return a2 %= b2;
    }

    public static void putPixel(byte[] array, int i2, int color) {
        int r2 = color >> 16 & 0xFF;
        int g2 = color >> 8 & 0xFF;
        int b2 = color >> 0 & 0xFF;
        int a2 = color >> 24 & 0xFF;
        array[i2 * 4 + 0] = (byte)r2;
        array[i2 * 4 + 1] = (byte)g2;
        array[i2 * 4 + 2] = (byte)b2;
        array[i2 * 4 + 3] = (byte)a2;
    }

    public static void transferPixel(byte[] array1, int i2, byte[] array2, int j2) {
        array2[j2 * 4 + 0] = array1[i2 * 4 + 0];
        array2[j2 * 4 + 1] = array1[i2 * 4 + 1];
        array2[j2 * 4 + 2] = array1[i2 * 4 + 2];
        array2[j2 * 4 + 3] = array1[i2 * 4 + 3];
    }
}

