/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.dynamictexture;

import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.src.dynamictexture.DynamicTextureRotating;
import net.minecraft.src.helper.Textures;

public abstract class DynamicTextureAbstractClock
extends DynamicTextureRotating {
    private String atlasTexture;

    public DynamicTextureAbstractClock(Minecraft minecraft, String atlasTexture, String dialTexture, int textureIndex, int resolution) {
        super(minecraft, atlasTexture, textureIndex, resolution);
        BufferedImage dialImage = Textures.readImage(minecraft.texturePackList.selectedTexturePack.getResourceAsStream(dialTexture));
        if (dialImage.getWidth() != dialImage.getHeight()) {
            throw new RuntimeException("Dial Texture " + dialTexture + " is not square!");
        }
        this.dialTexRes = dialImage.getWidth();
        this.dialImageData = new byte[dialImage.getWidth() * dialImage.getWidth() * 4];
        for (int x2 = 0; x2 < this.dialTexRes; ++x2) {
            for (int y2 = 0; y2 < this.dialTexRes; ++y2) {
                DynamicTextureAbstractClock.putPixel(this.dialImageData, y2 * this.dialTexRes + x2, dialImage.getRGB(x2, y2));
            }
        }
        this.atlasTexture = atlasTexture;
    }

    @Override
    public String getTextureName() {
        return this.atlasTexture;
    }
}

