/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.dynamictexture;

import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.Dimension;
import net.minecraft.src.Item;
import net.minecraft.src.dynamictexture.DynamicTexture;
import net.minecraft.src.helper.Textures;

public class DynamicTextureCompass
extends DynamicTexture {
    private Minecraft mc;
    private byte[] compassImageData;
    private double angleFinal;
    private double delta;
    private double scaleFactor;

    public DynamicTextureCompass(Minecraft minecraft, int resolution) {
        super(Item.toolCompass.getIconFromDamage(0), resolution, 1);
        this.mc = minecraft;
        BufferedImage compassImage = Textures.readImage(minecraft.texturePackList.selectedTexturePack.getResourceAsStream("/gui/items.png"));
        this.compassImageData = new byte[resolution * resolution * 4];
        int tileX = this.textureIndex % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES;
        int tileY = this.textureIndex / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES;
        for (int x2 = 0; x2 < resolution; ++x2) {
            for (int y2 = 0; y2 < resolution; ++y2) {
                DynamicTextureCompass.putPixel(this.compassImageData, y2 * resolution + x2, compassImage.getRGB(tileX * resolution + x2, tileY * resolution + y2));
            }
        }
        this.scaleFactor = (double)resolution / 16.0;
    }

    @Override
    public void update() {
        int b2;
        int g2;
        int r2;
        int a2;
        int b3;
        int g3;
        int r3;
        int j2;
        int y2;
        int x2;
        int i2;
        double angleSmooth;
        for (int i3 = 0; i3 < this.resolution * this.resolution; ++i3) {
            int a3 = this.compassImageData[i3 * 4 + 3] & 0xFF;
            int r4 = this.compassImageData[i3 * 4 + 0] & 0xFF;
            int g4 = this.compassImageData[i3 * 4 + 1] & 0xFF;
            int b4 = this.compassImageData[i3 * 4 + 2] & 0xFF;
            if (this.anaglyphEnabled) {
                int var6 = (r4 * 30 + g4 * 59 + b4 * 11) / 100;
                int var7 = (r4 * 30 + g4 * 70) / 100;
                int var8 = (r4 * 30 + b4 * 70) / 100;
                r4 = var6;
                g4 = var7;
                b4 = var8;
            }
            this.imageData[i3 * 4 + 0] = (byte)r4;
            this.imageData[i3 * 4 + 1] = (byte)g4;
            this.imageData[i3 * 4 + 2] = (byte)b4;
            this.imageData[i3 * 4 + 3] = (byte)a3;
        }
        double angle = 0.0;
        if (this.mc.theWorld != null && this.mc.thePlayer != null) {
            ChunkCoordinates var21 = this.mc.theWorld.getSpawnPoint();
            double var23 = (double)var21.x - this.mc.thePlayer.posX;
            double var25 = (double)var21.z - this.mc.thePlayer.posZ;
            angle = (double)(this.mc.thePlayer.rotationYaw - 90.0f) * Math.PI / 180.0 - Math.atan2(var25, var23);
            if (this.mc.theWorld.dimension == Dimension.nether) {
                angle = Math.random() * Math.PI * 2.0;
            }
        }
        for (angleSmooth = angle - this.angleFinal; angleSmooth < -Math.PI; angleSmooth += Math.PI * 2) {
        }
        while (angleSmooth >= Math.PI) {
            angleSmooth -= Math.PI * 2;
        }
        if (angleSmooth < -1.0) {
            angleSmooth = -1.0;
        }
        if (angleSmooth > 1.0) {
            angleSmooth = 1.0;
        }
        this.delta += angleSmooth * 0.1;
        this.delta *= 0.8;
        this.angleFinal += this.delta;
        double x3 = Math.sin(this.angleFinal);
        double y3 = Math.cos(this.angleFinal);
        double xs2 = (double)this.resolution / 2.0 + 0.5;
        double ys2 = (double)this.resolution / 2.0 - 0.5;
        for (i2 = (int)(-4.0 * this.scaleFactor); i2 <= (int)(4.0 * this.scaleFactor); ++i2) {
            x2 = (int)(xs2 + y3 * (double)i2 * 0.3);
            y2 = (int)(ys2 - x3 * (double)i2 * 0.3 * 0.5);
            j2 = y2 * this.resolution + x2;
            r3 = 100;
            g3 = 100;
            b3 = 100;
            a2 = 255;
            if (this.anaglyphEnabled) {
                r2 = (r3 * 30 + g3 * 59 + b3 * 11) / 100;
                g2 = (r3 * 30 + g3 * 70) / 100;
                b2 = (r3 * 30 + b3 * 70) / 100;
                r3 = r2;
                g3 = g2;
                b3 = b2;
            }
            this.imageData[j2 * 4 + 0] = (byte)r3;
            this.imageData[j2 * 4 + 1] = (byte)g3;
            this.imageData[j2 * 4 + 2] = (byte)b3;
            this.imageData[j2 * 4 + 3] = (byte)a2;
        }
        for (i2 = (int)(-8.0 * this.scaleFactor); i2 <= (int)(16.0 * this.scaleFactor); ++i2) {
            x2 = (int)(xs2 + x3 * (double)i2 * 0.3);
            y2 = (int)(ys2 + y3 * (double)i2 * 0.3 * 0.5);
            j2 = y2 * this.resolution + x2;
            r3 = i2 >= 0 ? 255 : 100;
            g3 = i2 >= 0 ? 20 : 100;
            b3 = i2 >= 0 ? 20 : 100;
            a2 = 255;
            if (this.anaglyphEnabled) {
                r2 = (r3 * 30 + g3 * 59 + b3 * 11) / 100;
                g2 = (r3 * 30 + g3 * 70) / 100;
                b2 = (r3 * 30 + b3 * 70) / 100;
                r3 = r2;
                g3 = g2;
                b3 = b2;
            }
            this.imageData[j2 * 4 + 0] = (byte)r3;
            this.imageData[j2 * 4 + 1] = (byte)g3;
            this.imageData[j2 * 4 + 2] = (byte)b3;
            this.imageData[j2 * 4 + 3] = (byte)a2;
        }
    }

    @Override
    public String getTextureName() {
        return "/gui/items.png";
    }
}

