/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.dynamictexture;

import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.src.dynamictexture.DynamicTexture;
import net.minecraft.src.helper.Textures;

public class DynamicTextureCustom
extends DynamicTexture {
    private String textureName;
    private int frameCount;
    private byte[] frames;
    private int elapsedTicks = 0;

    public DynamicTextureCustom(Minecraft mc2, String textureName, String animationSource, int textureIndex, int resolution, int width) {
        super(textureIndex, resolution, width);
        this.textureName = textureName;
        BufferedImage image = Textures.readImage(mc2.texturePackList.selectedTexturePack.getResourceAsStream(animationSource));
        if (image.getWidth() != resolution) {
            throw new RuntimeException("Animation " + animationSource + "doesn't have the same width as textures in " + textureName + "!");
        }
        if (image.getHeight() % image.getWidth() != 0) {
            throw new RuntimeException("Invalid Height for animation! " + animationSource);
        }
        this.frameCount = image.getHeight() / image.getWidth();
        System.out.println("Frame Count: " + this.frameCount);
        this.frames = new byte[resolution * resolution * 4 * this.frameCount];
        for (int frame = 0; frame < this.frameCount; ++frame) {
            for (int x2 = 0; x2 < resolution; ++x2) {
                for (int y2 = 0; y2 < resolution; ++y2) {
                    int c2 = image.getRGB(x2, frame * resolution + y2);
                    DynamicTextureCustom.putPixel(this.frames, frame * resolution * resolution + y2 * resolution + x2, c2);
                }
            }
        }
    }

    @Override
    public void update() {
        this.elapsedTicks = (this.elapsedTicks + 1) % this.frameCount;
        for (int i2 = 0; i2 < this.resolution; ++i2) {
            for (int j2 = 0; j2 < this.resolution; ++j2) {
                DynamicTextureCustom.transferPixel(this.frames, this.elapsedTicks * this.resolution * this.resolution + j2 * this.resolution + i2, this.imageData, j2 * this.resolution + i2);
            }
        }
    }

    @Override
    public String getTextureName() {
        return this.textureName;
    }
}

