/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.dynamictexture;

import net.minecraft.src.Block;
import net.minecraft.src.dynamictexture.DynamicTexture;

public class DynamicTextureFire
extends DynamicTexture {
    protected float[] arr1;
    protected float[] arr2;
    private int height;
    private float scaleFactor;

    public DynamicTextureFire(int resolution) {
        super(Block.texCoordToIndex(15, 1), resolution, 1, 2);
        this.scaleFactor = (float)resolution / 16.0f;
        this.height = (int)(20.0f * this.scaleFactor);
        this.arr1 = new float[resolution * this.height];
        this.arr2 = new float[resolution * this.height];
    }

    @Override
    public void update() {
        for (int i2 = 0; i2 < this.resolution; ++i2) {
            for (int j2 = 0; j2 < this.height; ++j2) {
                int var3 = (int)(18.0f * this.scaleFactor);
                float bright = this.arr1[i2 + (j2 + 1) % this.height * this.resolution] * (float)var3;
                for (int k2 = i2 - 1; k2 <= i2 + 1; ++k2) {
                    for (int l2 = j2; l2 <= j2 + 1; ++l2) {
                        if (k2 >= 0 && l2 >= 0 && k2 < this.resolution && l2 < this.height) {
                            bright += this.arr1[k2 + l2 * this.resolution];
                        }
                        ++var3;
                    }
                }
                this.arr2[i2 + j2 * this.resolution] = bright / ((float)var3 * (1.0f + 0.06f / this.scaleFactor));
                if (!((float)j2 >= 19.0f * this.scaleFactor)) continue;
                this.arr2[i2 + j2 * this.resolution] = (float)(Math.random() * Math.random() * Math.random() * 4.0 + Math.random() * 0.1 + 0.2);
            }
        }
        float[] var12 = this.arr2;
        this.arr2 = this.arr1;
        this.arr1 = var12;
        for (int i3 = 0; i3 < this.resolution * this.resolution; ++i3) {
            float var13 = this.arr1[i3] * 1.8f;
            if (var13 > 1.0f) {
                var13 = 1.0f;
            }
            if (var13 < 0.0f) {
                var13 = 0.0f;
            }
            int r2 = (int)(var13 * 155.0f + 100.0f);
            int g2 = (int)(var13 * var13 * 255.0f);
            int b2 = (int)(var13 * var13 * var13 * var13 * var13 * var13 * var13 * var13 * var13 * var13 * 255.0f);
            int a2 = 255;
            if (var13 < 0.5f) {
                a2 = 0;
            }
            if (this.anaglyphEnabled) {
                int var9 = (r2 * 30 + g2 * 59 + b2 * 11) / 100;
                int var10 = (r2 * 30 + g2 * 70) / 100;
                int var11 = (r2 * 30 + b2 * 70) / 100;
                r2 = var9;
                g2 = var10;
                b2 = var11;
            }
            this.imageData[i3 * 4 + 0] = (byte)r2;
            this.imageData[i3 * 4 + 1] = (byte)g2;
            this.imageData[i3 * 4 + 2] = (byte)b2;
            this.imageData[i3 * 4 + 3] = (byte)a2;
        }
    }

    @Override
    public String getTextureName() {
        return "/terrain.png";
    }
}

