/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.dynamictexture;

import net.minecraft.src.Block;
import net.minecraft.src.MathHelper;
import net.minecraft.src.dynamictexture.DynamicTexture;

public class DynamicTextureLavaStill
extends DynamicTexture {
    private float[] arr1;
    private float[] arr2;
    private float[] arr3;
    private float[] arr4;

    public DynamicTextureLavaStill(int resolution) {
        super(Block.texCoordToIndex(13, 14), resolution, 1);
        this.arr1 = new float[resolution * resolution];
        this.arr2 = new float[resolution * resolution];
        this.arr3 = new float[resolution * resolution];
        this.arr4 = new float[resolution * resolution];
    }

    @Override
    public void update() {
        int var9;
        int var8;
        int b2;
        int g2;
        float var3;
        int i2;
        for (i2 = 0; i2 < this.resolution; ++i2) {
            for (int j2 = 0; j2 < this.resolution; ++j2) {
                var3 = 0.0f;
                int x2 = (int)(MathHelper.sin((float)j2 * (float)Math.PI * 2.0f / (float)this.resolution) * 1.2f);
                int y2 = (int)(MathHelper.sin((float)i2 * (float)Math.PI * 2.0f / (float)this.resolution) * 1.2f);
                for (g2 = i2 - 1; g2 <= i2 + 1; ++g2) {
                    for (b2 = j2 - 1; b2 <= j2 + 1; ++b2) {
                        var8 = DynamicTextureLavaStill.pmod(g2 + x2, this.resolution);
                        var9 = DynamicTextureLavaStill.pmod(b2 + y2, this.resolution);
                        var3 += this.arr1[var8 + var9 * this.resolution];
                    }
                }
                this.arr2[i2 + j2 * this.resolution] = var3 / 10.0f + (this.arr3[DynamicTextureLavaStill.pmod(i2 + 0, this.resolution) + DynamicTextureLavaStill.pmod(j2 + 0, this.resolution) * this.resolution] + this.arr3[DynamicTextureLavaStill.pmod(i2 + 1, this.resolution) + DynamicTextureLavaStill.pmod(j2 + 0, this.resolution) * this.resolution] + this.arr3[DynamicTextureLavaStill.pmod(i2 + 1, this.resolution) + DynamicTextureLavaStill.pmod(j2 + 1, this.resolution) * this.resolution] + this.arr3[DynamicTextureLavaStill.pmod(i2 + 0, this.resolution) + DynamicTextureLavaStill.pmod(j2 + 1, this.resolution) * this.resolution]) / 4.0f * 0.8f;
                int n2 = i2 + j2 * this.resolution;
                this.arr3[n2] = this.arr3[n2] + this.arr4[i2 + j2 * this.resolution] * 0.01f;
                if (this.arr3[i2 + j2 * this.resolution] < 0.0f) {
                    this.arr3[i2 + j2 * this.resolution] = 0.0f;
                }
                int n3 = i2 + j2 * this.resolution;
                this.arr4[n3] = this.arr4[n3] - 0.06f;
                if (!(Math.random() < 0.005)) continue;
                this.arr4[i2 + j2 * this.resolution] = 1.5f;
            }
        }
        float[] var11 = this.arr2;
        this.arr2 = this.arr1;
        this.arr1 = var11;
        for (i2 = 0; i2 < this.resolution * this.resolution; ++i2) {
            var3 = this.arr1[i2] * 2.0f;
            if (var3 > 1.0f) {
                var3 = 1.0f;
            }
            if (var3 < 0.0f) {
                var3 = 0.0f;
            }
            int r2 = (int)(var3 * 100.0f + 155.0f);
            g2 = (int)(var3 * var3 * 255.0f);
            b2 = (int)(var3 * var3 * var3 * var3 * 128.0f);
            if (this.anaglyphEnabled) {
                var8 = (r2 * 30 + g2 * 59 + b2 * 11) / 100;
                var9 = (r2 * 30 + g2 * 70) / 100;
                int var10 = (r2 * 30 + b2 * 70) / 100;
                r2 = var8;
                g2 = var9;
                b2 = var10;
            }
            this.imageData[i2 * 4 + 0] = (byte)r2;
            this.imageData[i2 * 4 + 1] = (byte)g2;
            this.imageData[i2 * 4 + 2] = (byte)b2;
            this.imageData[i2 * 4 + 3] = -1;
        }
    }

    @Override
    public String getTextureName() {
        return "/terrain.png";
    }
}

