/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.dynamictexture;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.MathHelper;
import net.minecraft.src.dynamictexture.DynamicTexture;

public class DynamicTexturePortal
extends DynamicTexture {
    private int portalTickCounter = 0;
    private byte[][] portalTextureData;

    public DynamicTexturePortal(int resolution, boolean altTexture) {
        super(Block.texCoordToIndex(14, 0), resolution, 1);
        Random var1 = new Random(100L);
        this.portalTextureData = new byte[32][resolution * resolution * 4];
        for (int i2 = 0; i2 < 32; ++i2) {
            for (int j2 = 0; j2 < resolution; ++j2) {
                for (int k2 = 0; k2 < resolution; ++k2) {
                    int b2;
                    float f2 = 0.0f;
                    for (b2 = 0; b2 < 2; ++b2) {
                        float swirlY;
                        float swirlX;
                        if (altTexture) {
                            swirlX = b2 * 0;
                            swirlY = b2 * 0;
                        } else {
                            swirlX = b2 * (resolution / 2);
                            swirlY = b2 * (resolution / 2);
                        }
                        float var9 = ((float)j2 - swirlX) / (float)resolution * 2.0f;
                        float var10 = ((float)k2 - swirlY) / (float)resolution * 2.0f;
                        if (var9 < -1.0f) {
                            var9 += 2.0f;
                        }
                        if (var9 >= 1.0f) {
                            var9 -= 2.0f;
                        }
                        if (var10 < -1.0f) {
                            var10 += 2.0f;
                        }
                        if (var10 >= 1.0f) {
                            var10 -= 2.0f;
                        }
                        float var11 = var9 * var9 + var10 * var10;
                        float var12 = (float)Math.atan2(var10, var9) + ((float)i2 / 32.0f * (float)Math.PI * 2.0f - var11 * 10.0f + (float)(b2 * 2)) * (float)(b2 * 2 - 1);
                        var12 = (MathHelper.sin(var12) + 1.0f) / 2.0f;
                        f2 += (var12 /= var11 + 1.0f) * 0.5f;
                    }
                    b2 = (int)((f2 += var1.nextFloat() * 0.1f) * 100.0f + 155.0f);
                    int r2 = (int)(f2 * f2 * 200.0f + 55.0f);
                    int g2 = (int)(f2 * f2 * f2 * f2 * 255.0f);
                    int a2 = (int)(f2 * 100.0f + 155.0f);
                    int l2 = k2 * resolution + j2;
                    this.portalTextureData[i2][l2 * 4 + 0] = (byte)r2;
                    this.portalTextureData[i2][l2 * 4 + 1] = (byte)g2;
                    this.portalTextureData[i2][l2 * 4 + 2] = (byte)b2;
                    this.portalTextureData[i2][l2 * 4 + 3] = (byte)a2;
                }
            }
        }
    }

    @Override
    public void update() {
        ++this.portalTickCounter;
        byte[] var1 = this.portalTextureData[this.portalTickCounter & 0x1F];
        for (int i2 = 0; i2 < this.resolution * this.resolution; ++i2) {
            int r2 = var1[i2 * 4 + 0] & 0xFF;
            int g2 = var1[i2 * 4 + 1] & 0xFF;
            int b2 = var1[i2 * 4 + 2] & 0xFF;
            int a2 = var1[i2 * 4 + 3] & 0xFF;
            if (this.anaglyphEnabled) {
                int var7 = (r2 * 30 + g2 * 59 + b2 * 11) / 100;
                int var8 = (r2 * 30 + g2 * 70) / 100;
                int var9 = (r2 * 30 + b2 * 70) / 100;
                r2 = var7;
                g2 = var8;
                b2 = var9;
            }
            this.imageData[i2 * 4 + 0] = (byte)r2;
            this.imageData[i2 * 4 + 1] = (byte)g2;
            this.imageData[i2 * 4 + 2] = (byte)b2;
            this.imageData[i2 * 4 + 3] = (byte)a2;
        }
    }

    @Override
    public String getTextureName() {
        return "/terrain.png";
    }
}

