/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.dynamictexture;

import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.src.dynamictexture.DynamicTexture;
import net.minecraft.src.helper.Textures;

public abstract class DynamicTextureRotating
extends DynamicTexture {
    protected final Minecraft minecraft;
    protected byte[] dialImageData;
    protected int dialTexRes;
    protected byte[] clockImageData;
    protected double angleFinal;
    protected double delta;

    public DynamicTextureRotating(Minecraft minecraft, String atlasTexture, int textureIndex, int resolution) {
        super(textureIndex, resolution, 1);
        this.minecraft = minecraft;
        this.clockImageData = new byte[resolution * resolution * 4];
        BufferedImage atlas = Textures.readImage(minecraft.texturePackList.selectedTexturePack.getResourceAsStream(atlasTexture));
        int atlasWidth = net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES;
        int tileX = textureIndex % atlasWidth;
        int tileY = textureIndex / atlasWidth;
        for (int x2 = 0; x2 < resolution; ++x2) {
            for (int y2 = 0; y2 < resolution; ++y2) {
                DynamicTextureRotating.putPixel(this.clockImageData, y2 * resolution + x2, atlas.getRGB(tileX * resolution + x2, tileY * resolution + y2));
            }
        }
    }

    public abstract double getAngle();

    public void updateAngle() {
        double angleSmooth;
        double angle = this.getAngle();
        for (angleSmooth = angle - this.angleFinal; angleSmooth < -Math.PI; angleSmooth += Math.PI * 2) {
        }
        while (angleSmooth >= Math.PI) {
            angleSmooth -= Math.PI * 2;
        }
        if (angleSmooth < -1.0) {
            angleSmooth = -1.0;
        }
        if (angleSmooth > 1.0) {
            angleSmooth = 1.0;
        }
        this.delta += angleSmooth * 0.1;
        this.delta *= 0.8;
        this.angleFinal += this.delta;
    }

    @Override
    public void update() {
        this.updateAngle();
        double x2 = Math.sin(this.angleFinal);
        double y2 = Math.cos(this.angleFinal);
        for (int i2 = 0; i2 < this.resolution * this.resolution; ++i2) {
            int a2 = this.clockImageData[i2 * 4 + 3] & 0xFF;
            int r2 = this.clockImageData[i2 * 4 + 0] & 0xFF;
            int g2 = this.clockImageData[i2 * 4 + 1] & 0xFF;
            int b2 = this.clockImageData[i2 * 4 + 2] & 0xFF;
            if (r2 == b2 && g2 == 0 && b2 > 0) {
                double pixelBrightness = (double)r2 / 256.0;
                double x22 = -((double)(i2 % this.resolution) / (double)(this.resolution - 1) - 0.5);
                double y22 = (double)(i2 / this.resolution) / (double)(this.resolution - 1) - 0.5;
                int x3 = (int)((x22 * y2 + y22 * x2 + 0.5) * (double)this.dialTexRes);
                int y3 = (int)((y22 * y2 - x22 * x2 + 0.5) * (double)this.dialTexRes);
                int j2 = DynamicTextureRotating.clamp(x3, 0, this.dialTexRes - 1) + DynamicTextureRotating.clamp(y3, 0, this.dialTexRes - 1) * this.dialTexRes;
                a2 = this.dialImageData[j2 * 4 + 3] & 0xFF;
                r2 = this.dialImageData[j2 * 4 + 0] & 0xFF;
                g2 = this.dialImageData[j2 * 4 + 1] & 0xFF;
                b2 = this.dialImageData[j2 * 4 + 2] & 0xFF;
                r2 = (int)((double)r2 * pixelBrightness);
                g2 = (int)((double)g2 * pixelBrightness);
                b2 = (int)((double)b2 * pixelBrightness);
            }
            if (this.anaglyphEnabled) {
                int var23 = (r2 * 30 + g2 * 59 + b2 * 11) / 100;
                int var15 = (r2 * 30 + g2 * 70) / 100;
                int var24 = (r2 * 30 + b2 * 70) / 100;
                r2 = var23;
                g2 = var15;
                b2 = var24;
            }
            this.imageData[i2 * 4 + 0] = (byte)r2;
            this.imageData[i2 * 4 + 1] = (byte)g2;
            this.imageData[i2 * 4 + 2] = (byte)b2;
            this.imageData[i2 * 4 + 3] = (byte)a2;
        }
    }

    public static int clamp(int i2, int min, int max) {
        if (i2 > max) {
            return max;
        }
        if (i2 < min) {
            return min;
        }
        return i2;
    }
}

