/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.dynamictexture;

import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.src.dynamictexture.DynamicTextureRotating;
import net.minecraft.src.helper.Textures;

public class DynamicTextureTrommel
extends DynamicTextureRotating {
    private boolean counterClockwise;
    private double rotation = 0.0;
    private double speed = 0.12;

    public DynamicTextureTrommel(Minecraft minecraft, int textureIndex, int resolution, boolean counterClockwise) {
        super(minecraft, "/terrain.png", textureIndex, resolution);
        int y2;
        int x2;
        this.counterClockwise = counterClockwise;
        BufferedImage bufferedimage = Textures.readImage(minecraft.texturePackList.selectedTexturePack.getResourceAsStream("/terrain.png"));
        this.dialImageData = new byte[resolution * resolution * 4];
        for (x2 = 0; x2 < resolution; ++x2) {
            for (y2 = 0; y2 < resolution; ++y2) {
                DynamicTextureTrommel.putPixel(this.dialImageData, y2 * resolution + x2, bufferedimage.getRGB(resolution * 2 + x2, resolution * 9 + y2));
            }
        }
        this.clockImageData = new byte[resolution * resolution * 4];
        for (x2 = 0; x2 < resolution; ++x2) {
            for (y2 = 0; y2 < resolution; ++y2) {
                DynamicTextureTrommel.putPixel(this.clockImageData, y2 * resolution + x2, bufferedimage.getRGB(resolution * 1 + x2, resolution * 9 + y2));
            }
        }
        this.dialTexRes = resolution;
    }

    @Override
    public double getAngle() {
        return 0.0;
    }

    @Override
    public void updateAngle() {
        if (this.counterClockwise) {
            this.rotation -= this.speed;
            if (this.rotation < 0.0) {
                this.rotation += Math.PI * 2;
            }
        } else {
            this.rotation += this.speed;
            if (this.rotation > Math.PI * 2) {
                this.rotation -= Math.PI * 2;
            }
        }
        this.angleFinal = this.rotation;
    }

    @Override
    public String getTextureName() {
        return "/terrain.png";
    }
}

