/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.dynamictexture;

import net.minecraft.client.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.dynamictexture.DynamicTexture;

public class DynamicTextureWaterStill
extends DynamicTexture {
    private float[] arr1;
    private float[] arr2;
    private float[] arr3;
    private float[] arr4;

    public DynamicTextureWaterStill(int resolution) {
        super(Block.texCoordToIndex(13, 12), resolution, 1);
        this.arr1 = new float[resolution * resolution];
        this.arr2 = new float[resolution * resolution];
        this.arr3 = new float[resolution * resolution];
        this.arr4 = new float[resolution * resolution];
    }

    @Override
    public void update() {
        float bright;
        int j2;
        int i2;
        for (i2 = 0; i2 < this.resolution; ++i2) {
            for (j2 = 0; j2 < this.resolution; ++j2) {
                bright = 0.0f;
                for (int k2 = i2 - 1; k2 <= i2 + 1; ++k2) {
                    int a_ = DynamicTextureWaterStill.pmod(k2, this.resolution);
                    int b_ = DynamicTextureWaterStill.pmod(j2, this.resolution);
                    bright += this.arr1[a_ + b_ * this.resolution];
                }
                this.arr2[i2 + j2 * this.resolution] = bright / 3.3f + this.arr3[i2 + j2 * this.resolution] * 0.8f;
            }
        }
        for (i2 = 0; i2 < this.resolution; ++i2) {
            for (j2 = 0; j2 < this.resolution; ++j2) {
                int n2 = i2 + j2 * this.resolution;
                this.arr3[n2] = this.arr3[n2] + this.arr4[i2 + j2 * this.resolution] * 0.05f;
                if (this.arr3[i2 + j2 * this.resolution] < 0.0f) {
                    this.arr3[i2 + j2 * this.resolution] = 0.0f;
                }
                int n3 = i2 + j2 * this.resolution;
                this.arr4[n3] = this.arr4[n3] - 0.1f;
                if (!(Math.random() < 0.05)) continue;
                this.arr4[i2 + j2 * this.resolution] = 0.5f;
            }
        }
        float[] var12 = this.arr2;
        this.arr2 = this.arr1;
        this.arr1 = var12;
        for (j2 = 0; j2 < this.resolution * this.resolution; ++j2) {
            bright = this.arr1[j2];
            if (bright > 1.0f) {
                bright = 1.0f;
            }
            if (bright < 0.0f) {
                bright = 0.0f;
            }
            float var13 = bright * bright;
            int r2 = (int)(32.0f + var13 * 32.0f);
            int g2 = (int)(50.0f + var13 * 64.0f);
            int b2 = 255;
            int a2 = (int)(146.0f + var13 * 50.0f);
            if (this.anaglyphEnabled) {
                int var9 = (r2 * 30 + g2 * 59 + b2 * 11) / 100;
                int var10 = (r2 * 30 + g2 * 70) / 100;
                int var11 = (r2 * 30 + b2 * 70) / 100;
                r2 = var9;
                g2 = var10;
                b2 = var11;
            }
            if (((Boolean)Minecraft.getMinecraft().gameSettings.biomeWater.value).booleanValue()) {
                g2 = b2 = (r2 + g2 + b2) / 3;
                r2 = b2;
            }
            this.imageData[j2 * 4 + 0] = (byte)r2;
            this.imageData[j2 * 4 + 1] = (byte)g2;
            this.imageData[j2 * 4 + 2] = (byte)b2;
            this.imageData[j2 * 4 + 3] = (byte)a2;
        }
    }

    @Override
    public String getTextureName() {
        return "/terrain.png";
    }
}

