/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.helper;

import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.minecraft.src.helper.Color;

public abstract class Buffer {
    public static ByteBuffer buffer = Buffer.createBuffer(0x200000);

    private static ByteBuffer createBuffer(int size) {
        return ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
    }

    public static void checkBufferSize(int size) {
        if (buffer.capacity() < size) {
            buffer = Buffer.createBuffer(size);
            System.out.println("Expanding buffer to " + size);
        }
    }

    public static void reset() {
        buffer.position(0);
        buffer.limit(buffer.capacity());
    }

    public static int getInt(int i2) {
        int c2 = buffer.capacity() / 4;
        if (i2 >= c2) {
            throw new IndexOutOfBoundsException(i2 + " / " + c2);
        }
        return buffer.getInt(i2);
    }

    public static void put(byte[] a2) {
        Buffer.checkBufferSize(a2.length);
        Buffer.reset();
        buffer.put(a2);
        buffer.limit(a2.length);
        buffer.flip();
    }

    public static void put(BufferedImage image) {
        Buffer.checkBufferSize(image.getWidth() * image.getHeight() * 4);
        Buffer.reset();
        for (int i2 = 0; i2 < image.getWidth(); ++i2) {
            for (int j2 = 0; j2 < image.getHeight(); ++j2) {
                Buffer.putARGB(j2 * image.getWidth() + i2, image.getRGB(i2, j2));
            }
        }
        buffer.position(0);
        buffer.limit(image.getWidth() * image.getHeight() * 4);
    }

    public static void put4Bytes(int i2, byte b0, byte b1, byte b2, byte b3) {
        buffer.put(i2 * 4 + 0, b0);
        buffer.put(i2 * 4 + 1, b1);
        buffer.put(i2 * 4 + 2, b2);
        buffer.put(i2 * 4 + 3, b3);
    }

    public static void putARGB(int i2, int value) {
        byte a2 = (byte)(value >> 24 & 0xFF);
        byte r2 = (byte)(value >> 16 & 0xFF);
        byte g2 = (byte)(value >> 8 & 0xFF);
        byte b2 = (byte)(value >> 0 & 0xFF);
        Buffer.put4Bytes(i2, r2, g2, b2, a2);
    }

    public static void putColor(int i2, Color color) {
        Buffer.putARGB(i2, color.value);
    }

    public static int getARGB(int i2) {
        int a2 = buffer.get(i2 * 4 + 3) & 0xFF;
        int r2 = buffer.get(i2 * 4 + 0) & 0xFF;
        int g2 = buffer.get(i2 * 4 + 1) & 0xFF;
        int b2 = buffer.get(i2 * 4 + 2) & 0xFF;
        return (a2 << 24) + (r2 << 16) + (g2 << 8) + b2;
    }
}

