/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.helper;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.src.TexturePackBase;
import net.minecraft.src.helper.Color;

public abstract class Colors {
    public static final Color[] allChatColors = new Color[16];
    public static final Color[] allPlankColors = new Color[16];

    public static void loadColors(TexturePackBase texturePack) {
        Colors.fillColorArray(texturePack, "/misc/colors_chat.png", allChatColors);
        Colors.fillColorArray(texturePack, "/misc/colors_planks.png", allPlankColors);
    }

    public static void fillColorArray(TexturePackBase texturePack, String path, Color[] colors) {
        try {
            InputStream stream = texturePack != null ? texturePack.getResourceAsStream(path) : Colors.class.getResourceAsStream(path);
            BufferedImage image = ImageIO.read(stream);
            stream.close();
            Colors.fillColorArray(colors, image);
        }
        catch (Exception e2) {
            throw new RuntimeException("Failed to load colors from image: " + path);
        }
    }

    public static Color[] fillColorArray(Color[] colors, BufferedImage image) {
        if (image.getWidth() != colors.length || image.getHeight() != 1) {
            throw new RuntimeException("Invalid Color image size! Must be " + colors.length + " x 1");
        }
        for (int i2 = 0; i2 < colors.length; ++i2) {
            colors[i2] = new Color().setARGB(image.getRGB(i2, 0));
        }
        return colors;
    }

    public static BufferedImage createColorImage(Color[] colors, int scale) {
        int w2 = colors.length * scale;
        int h2 = scale;
        BufferedImage image = new BufferedImage(w2, h2, 2);
        Graphics g2 = image.getGraphics();
        for (int i2 = 0; i2 < colors.length; ++i2) {
            Color c2 = colors[i2];
            g2.setColor(new java.awt.Color(c2.getRed(), c2.getGreen(), c2.getBlue(), c2.getAlpha()));
            g2.fillRect(i2 * scale, 0, scale, scale);
        }
        return image;
    }
}

