/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.helper;

import java.io.PrintStream;
import java.time.LocalTime;

public class LogPrintStream
extends PrintStream {
    public static boolean stackTrace = false;
    public static boolean time = true;
    public static boolean thread = true;
    private PrintStream old;

    public static void setup() {
        System.setOut(new LogPrintStream(System.out));
        System.setErr(new LogPrintStream(System.err));
    }

    public LogPrintStream(PrintStream printStream) {
        super(printStream);
        this.old = printStream;
    }

    @Override
    public void println(boolean x2) {
        this.formatPrintLine(Boolean.valueOf(x2).toString());
    }

    @Override
    public void println(int x2) {
        this.formatPrintLine(Integer.valueOf(x2).toString());
    }

    @Override
    public void println(long x2) {
        this.formatPrintLine(Long.valueOf(x2).toString());
    }

    @Override
    public void println(float x2) {
        this.formatPrintLine(Float.valueOf(x2).toString());
    }

    @Override
    public void println(double x2) {
        this.formatPrintLine(Double.valueOf(x2).toString());
    }

    @Override
    public void println(char x2) {
        this.formatPrintLine(Character.valueOf(x2).toString());
    }

    @Override
    public void println(String a2) {
        this.formatPrintLine(a2);
    }

    @Override
    public void println(Object x2) {
        if (x2 != null) {
            this.formatPrintLine(x2.toString());
        } else {
            this.formatPrintLine(null);
        }
    }

    @Override
    public void println(char[] x2) {
        this.formatPrintLine(new String(x2));
    }

    public void formatPrintLine(String s2) {
        this.formatPrint(s2 + "\n", 1);
    }

    private void formatPrint(String string, int stackTraceOffset) {
        string = LogPrintStream.removeColorCodes(string);
        if (stackTrace) {
            string = Thread.currentThread().getStackTrace()[3 + stackTraceOffset] + " " + string;
        }
        if (thread) {
            string = "[" + Thread.currentThread().getName() + "] " + string;
        }
        if (time) {
            LocalTime localTime = LocalTime.now();
            StringBuilder timeString = new StringBuilder();
            if (localTime.getHour() < 10) {
                timeString.append("0");
            }
            timeString.append(localTime.getHour());
            timeString.append(":");
            if (localTime.getMinute() < 10) {
                timeString.append("0");
            }
            timeString.append(localTime.getMinute());
            timeString.append(":");
            if (localTime.getSecond() < 10) {
                timeString.append("0");
            }
            timeString.append(localTime.getSecond());
            string = "[" + timeString.toString() + "] " + string;
        }
        this.old.print(string);
    }

    public static String removeColorCodes(String string) {
        StringBuilder builder = new StringBuilder();
        boolean a2 = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\u00a7') {
                a2 = true;
                continue;
            }
            if (a2) {
                a2 = false;
                continue;
            }
            builder.append(c2);
        }
        return builder.toString();
    }
}

