/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.helper;

import b100.utils.FileUtils;
import b100.utils.interfaces.Condition;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class ReflectionHelper {
    public static List<Class<?>> getAllClasses(Condition<String> classNameCondition) {
        String[] classPathEntries;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        ArrayList classes = new ArrayList();
        for (String classPathEntry : classPathEntries = System.getProperty("java.class.path").split(";")) {
            File file = new File(classPathEntry);
            if (file.isDirectory()) {
                int l2 = file.getAbsolutePath().length() + 1;
                List<File> files = FileUtils.getAllFiles(file);
                for (File file2 : files) {
                    if (!file2.getName().endsWith(".class")) continue;
                    ReflectionHelper.tryAddClass(classes, classLoader, file2.getAbsolutePath().substring(l2), classNameCondition);
                }
            }
            if (!file.isFile()) continue;
            try {
                ZipFile zip = new ZipFile(file);
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    String entry = ((Object)entries.nextElement()).toString();
                    if (!entry.endsWith(".class")) continue;
                    ReflectionHelper.tryAddClass(classes, classLoader, entry, classNameCondition);
                }
                zip.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        return classes;
    }

    private static void tryAddClass(List<Class<?>> classes, ClassLoader classLoader, String fileName, Condition<String> classNameCondition) {
        String className = fileName.substring(0, fileName.length() - 6);
        className = className.replace('\\', '.');
        className = className.replace('/', '.');
        if (classNameCondition == null || classNameCondition.isTrue(className)) {
            Class<?> clazz = null;
            try {
                clazz = classLoader.loadClass(className);
            }
            catch (Throwable e2) {
                System.err.println(e2.getClass().getName() + ": " + e2.getMessage());
            }
            if (clazz != null) {
                classes.add(clazz);
            }
        }
    }
}

