/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.helper;

import b100.utils.StreamUtils;
import b100.utils.StringUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public interface ResourceProvider {
    public InputStream getResourceAsStream(String var1) throws IOException;

    default public String getString(String path) {
        try {
            return StringUtils.readInputString(this.getResourceAsStream(path));
        }
        catch (Exception e2) {
            throw new RuntimeException("Error Loading String: " + path, e2);
        }
    }

    default public BufferedImage getImage(String path) {
        BufferedImage bufferedImage;
        InputStream stream = null;
        try {
            BufferedImage image;
            stream = this.getResourceAsStream(path);
            bufferedImage = image = ImageIO.read(stream);
        }
        catch (Exception e2) {
            try {
                throw new RuntimeException("Error Loading Image: " + path, e2);
            }
            catch (Throwable throwable) {
                StreamUtils.close(stream);
                throw throwable;
            }
        }
        StreamUtils.close(stream);
        return bufferedImage;
    }
}

