/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.helper;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import net.minecraft.src.helper.ITextField;
import org.lwjgl.input.Keyboard;

public abstract class TextFieldInputHandler {
    public static boolean handleKeyTyped(ITextField textField, int key, char c2) {
        if (key == 46 && (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157))) {
            TextFieldInputHandler.copyString(textField.getText());
            return false;
        }
        if (key == 47 && (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157))) {
            String paste = TextFieldInputHandler.getClipboardString();
            if (paste != null) {
                for (int i2 = 0; i2 < paste.length(); ++i2) {
                    TextFieldInputHandler.addChar(textField, paste.charAt(i2));
                }
            }
            return true;
        }
        if (key == 14) {
            String msg = textField.getText();
            if (msg.length() > 0) {
                if (Keyboard.isKeyDown((int)157) || Keyboard.isKeyDown((int)29)) {
                    int trimLength = 0;
                    for (int i3 = 0; i3 < msg.length(); ++i3) {
                        trimLength = msg.charAt(i3) != ' ' ? i3 : trimLength;
                    }
                    int removeIndex = 0;
                    for (int i4 = 0; i4 < trimLength; ++i4) {
                        removeIndex = msg.charAt(i4) == ' ' ? i4 + 1 : removeIndex;
                    }
                    msg = msg.substring(0, removeIndex);
                } else {
                    msg = msg.substring(0, msg.length() - 1);
                }
                textField.setText(msg);
                return true;
            }
            return false;
        }
        return TextFieldInputHandler.addChar(textField, c2);
    }

    public static boolean addChar(ITextField textField, char c2) {
        if (textField.isCharacterAllowed(c2) && textField.getText().length() < textField.maxLength()) {
            textField.setText(textField.getText() + c2);
            return true;
        }
        return false;
    }

    public static void copyString(String string) {
        try {
            StringSelection selection = new StringSelection(string);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, selection);
            System.out.println("Copied String!");
        }
        catch (Exception e2) {
            System.err.println("Error copying String: " + e2.getClass().getName() + ": " + e2.getMessage());
        }
    }

    public static String getClipboardString() {
        try {
            Transferable trans = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (trans != null && trans.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return (String)trans.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

