/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.helper;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.minecraft.client.Minecraft;
import net.minecraft.src.GLAllocation;
import net.minecraft.src.helper.Buffer;
import org.lwjgl.opengl.GL11;

public class Textures {
    public static BufferedImage missingTexture = new BufferedImage(64, 64, 2);

    public static BufferedImage readImage(InputStream stream) {
        if (stream == null) {
            return missingTexture;
        }
        try {
            BufferedImage bufferedimage = ImageIO.read(stream);
            stream.close();
            return bufferedimage;
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static int[] getImageData(BufferedImage image) {
        int w2 = image.getWidth();
        int h2 = image.getHeight();
        int[] imageData = new int[w2 * h2];
        image.getRGB(0, 0, w2, h2, imageData, 0, w2);
        return imageData;
    }

    public static int[] getImageData(BufferedImage image, int[] imageData) {
        int w2 = image.getWidth();
        int h2 = image.getHeight();
        image.getRGB(0, 0, w2, h2, imageData, 0, w2);
        return imageData;
    }

    public static BufferedImage unwrapImageByColumns(BufferedImage image) {
        int i2 = image.getWidth() / 16;
        BufferedImage image2 = new BufferedImage(16, image.getHeight() * i2, 2);
        Graphics g2 = image2.getGraphics();
        for (int j2 = 0; j2 < i2; ++j2) {
            g2.drawImage(image, -j2 * 16, j2 * image.getHeight(), null);
        }
        g2.dispose();
        return image2;
    }

    public static void dumpTextures() {
        System.out.println("Dump Textures...");
        File folder = new File("dumpTextures");
        try {
            File[] files;
            folder.mkdirs();
            for (File file : files = folder.listFiles()) {
                file.delete();
            }
            int i2 = 0;
            for (Integer texture : GLAllocation.textureNames) {
                String name = "" + i2;
                try {
                    Minecraft minecraft = Minecraft.getMinecraft();
                    Map<String, Integer> textures = minecraft.renderEngine.getTextureMap();
                    for (Map.Entry<String, Integer> entry : textures.entrySet()) {
                        if (entry.getValue() != texture) continue;
                        System.out.println(entry.getKey());
                    }
                }
                catch (Exception minecraft) {
                    // empty catch block
                }
                int levels = GL11.glGetTexParameteri((int)3553, (int)33085);
                for (int level = 0; level <= levels; ++level) {
                    Textures.saveImage(new File(folder, name + "_mip" + level + ".png"), Textures.getTextureAsImage(texture, true, level));
                    Textures.saveImage(new File(folder, name + "_mip" + level + "_opaque.png"), Textures.getTextureAsImage(texture, false, level));
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        System.out.println("Done!");
        try {
            Minecraft.getMinecraft().ingameGUI.addChatMessage("Dumped textures to " + folder.getAbsolutePath());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void saveImage(File file, BufferedImage image) {
        if (image == null) {
            return;
        }
        try {
            file.createNewFile();
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static BufferedImage getTextureAsImage(int texture, boolean alpha, int level) {
        return Textures.getTextureAsImage(texture, alpha, level, false);
    }

    public static BufferedImage getTextureAsImage(int texture, boolean alpha, int level, boolean mirrorVertical) {
        GL11.glBindTexture((int)3553, (int)texture);
        int w2 = GL11.glGetTexLevelParameteri((int)3553, (int)level, (int)4096);
        int h2 = GL11.glGetTexLevelParameteri((int)3553, (int)level, (int)4097);
        if (w2 == 0 || h2 == 0) {
            return null;
        }
        System.out.println("Texture " + texture + " Size: " + w2 + " x " + h2);
        Buffer.reset();
        Buffer.checkBufferSize(w2 * h2 * 16);
        GL11.glGetTexImage((int)3553, (int)level, (int)6408, (int)5121, (ByteBuffer)Buffer.buffer);
        Buffer.buffer.position(0);
        Buffer.buffer.limit(Buffer.buffer.capacity());
        int[] rgb = new int[w2 * h2];
        for (int i2 = 0; i2 < rgb.length; ++i2) {
            int c2;
            int j2 = i2;
            if (mirrorVertical) {
                int x2 = i2 % w2;
                int y2 = i2 / w2;
                y2 = h2 - y2 - 1;
                j2 = y2 * w2 + x2;
            }
            int r2 = Buffer.getInt(j2 * 4 + 2) & 0xFF;
            int g2 = Buffer.getInt(j2 * 4 + 1) & 0xFF;
            int b2 = Buffer.getInt(j2 * 4 + 0) & 0xFF;
            int a2 = Buffer.getInt(j2 * 4 + 3) & 0xFF;
            if (!alpha) {
                a2 = 255;
            }
            rgb[i2] = c2 = (r2 << 0) + (g2 << 8) + (b2 << 16) + (a2 << 24);
        }
        BufferedImage image = new BufferedImage(w2, h2, alpha ? 2 : 1);
        image.setRGB(0, 0, w2, h2, rgb, 0, w2);
        return image;
    }

    public static void main(String[] args) {
        try {
            final BufferedImage image = Textures.unwrapImageByColumns(ImageIO.read(Textures.class.getResourceAsStream("/terrain.png")));
            JFrame frame = new JFrame();
            frame.setUndecorated(true);
            JPanel panel = new JPanel(){
                private static final long serialVersionUID = 1L;

                @Override
                public void paint(Graphics g2) {
                    super.paint(g2);
                    g2.drawImage(image, 0, 0, null);
                }
            };
            panel.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
            frame.add(panel);
            frame.pack();
            frame.setLocationRelativeTo(null);
            frame.setDefaultCloseOperation(2);
            frame.setVisible(true);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    static {
        Graphics g2 = missingTexture.getGraphics();
        try {
            Graphics2D g2d = (Graphics2D)g2;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        catch (Exception exception) {
            // empty catch block
        }
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, 64, 64);
        g2.setColor(Color.BLACK);
        g2.drawString("missingtex", 1, 10);
        g2.dispose();
    }
}

