/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.input.controller;

import b100.utils.interfaces.Condition;
import net.minecraft.src.GuiContainer;
import net.minecraft.src.GuiCrafting;
import net.minecraft.src.GuiFurnace;
import net.minecraft.src.GuiInventory;
import net.minecraft.src.Slot;
import net.minecraft.src.input.controller.ControllerInput;

public class ControllerInventoryHandler {
    public final ControllerInput controllerInput;
    private Slot lastSlot;

    public ControllerInventoryHandler(ControllerInput controllerInput) {
        this.controllerInput = controllerInput;
    }

    public void handleAbstractCrafting(GuiContainer container, Condition<Slot> isInventorySlot, Condition<Slot> isCraftingSlot, Condition<Slot> isResultSlot, int craftingSlot, int resultSlot, int invSlot) {
        Slot slot = this.controllerInput.getSlotAtCursor(container);
        if (this.controllerInput.buttonA.pressedThisFrame()) {
            for (Slot slot2 : container.inventorySlots.inventorySlots) {
                System.out.println(slot2.id + ": " + slot2.getStack());
            }
        }
        if (slot != null && isCraftingSlot.isTrue(slot) && slot.hasStack() && this.controllerInput.buttonA.isPressed() && this.controllerInput.buttonA.getHoldTime() > 10 && this.controllerInput.buttonA.getHoldTime() % 2 == 1) {
            this.click(container, 0);
        }
        if (this.controllerInput.buttonZL.pressedThisFrame()) {
            if (slot != null) {
                if (isCraftingSlot.isTrue(slot)) {
                    if (this.lastSlot != null) {
                        this.controllerInput.snapToSlot(container, this.lastSlot);
                    } else {
                        this.controllerInput.snapToSlot(container, invSlot);
                    }
                } else {
                    if (slot != null && slot.id > 9) {
                        this.lastSlot = slot;
                    }
                    this.controllerInput.snapToSlot(container, craftingSlot);
                }
            } else {
                this.controllerInput.snapToSlot(container, invSlot);
            }
        }
        if (this.controllerInput.buttonZR.pressedThisFrame()) {
            if (slot != null) {
                if (isResultSlot.isTrue(slot)) {
                    if (this.lastSlot != null) {
                        this.controllerInput.snapToSlot(container, this.lastSlot);
                    } else {
                        this.controllerInput.snapToSlot(container, invSlot);
                    }
                } else {
                    if (isInventorySlot.isTrue(slot)) {
                        this.lastSlot = slot;
                    }
                    this.controllerInput.snapToSlot(container, resultSlot);
                }
            } else {
                this.controllerInput.snapToSlot(container, resultSlot);
            }
        }
    }

    public void handleCrafting(GuiCrafting crafting) {
        this.handleAbstractCrafting(crafting, e2 -> e2.id > 9, e2 -> e2.id > 0 && e2.id < 10, e2 -> e2.id == 0, 5, 0, 24);
    }

    public void handleInventory(GuiInventory inventory) {
        this.handleAbstractCrafting(inventory, e2 -> e2.id >= 9 && e2.id <= 44, e2 -> e2.id >= 1 && e2.id <= 4, e2 -> e2.id == 0, 1, 0, 22);
    }

    public void handleFurnace(GuiFurnace furnace) {
        this.handleAbstractCrafting(furnace, e2 -> e2.id >= 3 && e2.id <= 38, e2 -> e2.id >= 0 && e2.id <= 1, e2 -> e2.id == 2, 0, 2, 16);
    }

    public void click(GuiContainer guiCrafting, int button) {
        guiCrafting.mouseClicked((int)this.controllerInput.cursorX, (int)this.controllerInput.cursorY, button);
    }
}

