/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.input.controller;

import net.java.games.input.Component;
import net.minecraft.src.input.controller.Button;
import net.minecraft.src.option.FloatOption;

public class Joystick {
    public Component compX;
    public Component compY;
    public final String name;
    public final Button button;
    private FloatOption deadzone;
    private float x;
    private float y;
    private boolean moving = false;
    private boolean moveLastFrame = false;

    public Joystick(String name, Component x2, Component y2, Button button, FloatOption deadzone) {
        this.name = name;
        this.deadzone = deadzone;
        this.compX = x2;
        this.compY = y2;
        this.button = button;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public Button getButton() {
        return this.button;
    }

    public void update() {
        boolean yInDeadzone;
        this.button.update();
        float x2 = this.compX.getPollData();
        float y2 = this.compY.getPollData();
        boolean xInDeadzone = x2 < ((Float)this.deadzone.value).floatValue() && x2 > -((Float)this.deadzone.value).floatValue();
        boolean bl2 = yInDeadzone = y2 < ((Float)this.deadzone.value).floatValue() && y2 > -((Float)this.deadzone.value).floatValue();
        if (xInDeadzone) {
            x2 = 0.0f;
        }
        if (yInDeadzone) {
            y2 = 0.0f;
        }
        this.x = x2;
        this.y = y2;
        this.moveLastFrame = this.moving;
        this.moving = !xInDeadzone || !yInDeadzone;
    }

    public boolean stoppedMoving() {
        return this.moveLastFrame && !this.moving;
    }
}

