/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.render;

import net.minecraft.client.Minecraft;
import net.minecraft.src.GuiPhotoMode;
import net.minecraft.src.helper.ResourceProvider;
import net.minecraft.src.helper.ResourceProviderInternal;
import net.minecraft.src.render.Shaders;
import net.minecraft.src.render.ShadersRenderer;

public class PhotoModeRenderer
extends ShadersRenderer {
    public static final String[] shaders = new String[]{null, "blur", "silhouette", "vignette", "tiltshift", "outline", "outline2", "eerie", "sepia", "inverted", "distantblur"};
    public final GuiPhotoMode guiPhotoMode;
    private int selectedShader = 0;

    public PhotoModeRenderer(Minecraft minecraft, GuiPhotoMode guiPhotoMode) {
        super(minecraft);
        this.guiPhotoMode = guiPhotoMode;
        if (!Shaders.shadersCompatible) {
            throw new RuntimeException("Shaders not compatible!");
        }
    }

    @Override
    public ResourceProvider getShader() {
        if (this.selectedShader > 0) {
            return new ResourceProviderInternal("shaders/photo/" + this.getActiveShader());
        }
        return null;
    }

    public void next() {
        this.selectedShader = (this.selectedShader + 1) % shaders.length;
        this.reload();
    }

    public void first() {
        this.selectedShader = 0;
        this.reload();
    }

    @Override
    public boolean clearDepthBeforeRenderHand() {
        return false;
    }

    public String getActiveShader() {
        return shaders[this.selectedShader];
    }
}

