/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.render;

import net.minecraft.client.Minecraft;
import net.minecraft.src.GuiPhotoMode;
import net.minecraft.src.render.Shader;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public abstract class Shaders {
    public static boolean shadersCompatible = false;
    private static int fullscreenRectList;

    public static void testShaderCompat(Minecraft mc2) {
        if (((Boolean)mc2.gameSettings.disableAllShaders.value).booleanValue()) {
            System.out.println("Shaders deactivated in options.txt!");
            shadersCompatible = false;
            return;
        }
        System.out.println(GL11.glGetString((int)7938));
        System.out.println(GL11.glGetString((int)7936));
        System.out.println(GL11.glGetString((int)7937));
        shadersCompatible = true;
        try {
            int error;
            int framebuffer;
            GL11.glGetError();
            System.out.println("Testing Capabilities...");
            int shaderProgram = GL20.glCreateProgram();
            if (shaderProgram == 0) {
                System.out.println("Shaders not supported!");
                shadersCompatible = false;
            }
            if ((framebuffer = ARBFramebufferObject.glGenFramebuffers()) == 0) {
                System.out.println("Framebuffers not supported!");
                shadersCompatible = false;
            }
            if ((error = GL11.glGetError()) != 0) {
                throw new RuntimeException("Error " + error);
            }
            GL20.glDeleteProgram((int)shaderProgram);
            ARBFramebufferObject.glDeleteFramebuffers((int)framebuffer);
        }
        catch (Exception e2) {
            shadersCompatible = false;
            e2.printStackTrace();
        }
        if (shadersCompatible) {
            System.out.println("Shaders Activated!");
        } else {
            System.out.println("Shaders Deactivated!");
        }
    }

    public static void drawFullscreenRect() {
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2912);
        GL11.glDisable((int)2929);
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3089);
        GL11.glDisable((int)3008);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)-1.0, (double)1.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5889);
        if (fullscreenRectList == 0) {
            fullscreenRectList = GL11.glGenLists((int)1);
            GL11.glNewList((int)fullscreenRectList, (int)4864);
            GL11.glBegin((int)7);
            GL11.glTexCoord2d((double)0.0, (double)0.0);
            GL11.glVertex2d((double)0.0, (double)0.0);
            GL11.glTexCoord2d((double)0.0, (double)1.0);
            GL11.glVertex2d((double)0.0, (double)1.0);
            GL11.glTexCoord2d((double)1.0, (double)1.0);
            GL11.glVertex2d((double)1.0, (double)1.0);
            GL11.glTexCoord2d((double)1.0, (double)0.0);
            GL11.glVertex2d((double)1.0, (double)0.0);
            GL11.glEnd();
            GL11.glEndList();
        }
        GL11.glCallList((int)fullscreenRectList);
    }

    public static void setUniforms(Minecraft minecraft, Shader shader) {
        if (!shader.isUsable()) {
            return;
        }
        shader.bind();
        shader.uniformFloat("width", minecraft.resolution.width);
        shader.uniformFloat("height", minecraft.resolution.height);
        shader.uniformFloat("gamma", ((Float)minecraft.gameSettings.gamma.value).floatValue());
        shader.uniformFloat("photoMode", minecraft.currentScreen != null && minecraft.currentScreen instanceof GuiPhotoMode);
        shader.uniformFloat("guiOpened", minecraft.currentScreen != null);
        if (minecraft.currentScreen != null && minecraft.currentScreen instanceof GuiPhotoMode) {
            GuiPhotoMode guiPhotoMode = (GuiPhotoMode)minecraft.currentScreen;
            shader.uniformFloat("intensity", guiPhotoMode.intensityValue);
        } else {
            shader.uniformFloat("intensity", 1.0f);
        }
    }
}

