/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.render;

import java.nio.ByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.src.helper.Buffer;
import net.minecraft.src.helper.ResourceProvider;
import net.minecraft.src.helper.ResourceProviderInternal;
import net.minecraft.src.render.Framebuffer;
import net.minecraft.src.render.IRenderer;
import net.minecraft.src.render.Shaderpack;
import net.minecraft.src.render.Shaders;
import net.minecraft.src.render.Texture;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public abstract class ShadersRenderer
implements IRenderer {
    public final Minecraft minecraft;
    protected final Framebuffer worldFramebuffer = new Framebuffer();
    protected final Texture worldFramebufferTex = new Texture();
    protected final Texture worldFramebufferDepth = new Texture();
    protected final Framebuffer gameFramebuffer = new Framebuffer();
    protected final Texture gameFramebufferTex = new Texture();
    protected final Texture gameFramebufferDepth = new Texture();
    protected final Shaderpack shaderpack = new Shaderpack();
    protected int fbWidth;
    protected int fbHeight;
    public static final ResourceProvider internalShaderFolder = new ResourceProviderInternal("shaders");

    public ShadersRenderer(Minecraft minecraft) {
        this.minecraft = minecraft;
        if (!Shaders.shadersCompatible) {
            throw new RuntimeException("Shaders not compatible!");
        }
    }

    @Override
    public void beginRenderGame() {
        if (this.shaderpack.finalShader.isUsable()) {
            this.setupFramebuffer();
            this.gameFramebuffer.bind();
            GL20.glUseProgram((int)0);
        }
    }

    @Override
    public void endRenderGame() {
        ARBFramebufferObject.glBindFramebuffer((int)36160, (int)0);
        if (this.shaderpack.finalShader.isUsable()) {
            this.shaderpack.finalShader.bind();
            ARBMultitexture.glActiveTextureARB((int)33984);
            this.gameFramebufferTex.bind();
            this.shaderpack.finalShader.uniformInt("colortex0", 0);
            Shaders.setUniforms(this.minecraft, this.shaderpack.finalShader);
            Shaders.drawFullscreenRect();
            GL20.glUseProgram((int)0);
        }
    }

    @Override
    public void beginRenderWorld() {
        this.setupFramebuffer();
        this.worldFramebuffer.bind();
        Shaders.setUniforms(this.minecraft, this.shaderpack.texturedShader);
        Shaders.setUniforms(this.minecraft, this.shaderpack.basicShader);
        Shaders.setUniforms(this.minecraft, this.shaderpack.terrainShader);
        GL20.glUseProgram((int)0);
    }

    @Override
    public void endRenderWorld() {
        if (this.shaderpack.finalShader.isUsable()) {
            this.gameFramebuffer.bind();
        } else {
            ARBFramebufferObject.glBindFramebuffer((int)36160, (int)0);
        }
        if (this.shaderpack.postShader.isUsable()) {
            this.shaderpack.postShader.bind();
            ARBMultitexture.glActiveTextureARB((int)33984);
            this.worldFramebufferTex.bind();
            this.shaderpack.postShader.uniformInt("colortex0", 0);
            ARBMultitexture.glActiveTextureARB((int)33985);
            this.worldFramebufferDepth.bind();
            this.shaderpack.postShader.uniformInt("depthtex0", 1);
            ARBMultitexture.glActiveTextureARB((int)33984);
            Shaders.setUniforms(this.minecraft, this.shaderpack.postShader);
        } else {
            GL20.glUseProgram((int)0);
            this.worldFramebufferTex.bind();
        }
        Shaders.drawFullscreenRect();
        GL20.glUseProgram((int)0);
        GL11.glEnable((int)3008);
    }

    @Override
    public void beginRenderTerrain() {
    }

    @Override
    public void endRenderTerrain() {
    }

    @Override
    public void beginRenderTextured() {
    }

    @Override
    public void endRenderTextured() {
    }

    @Override
    public void beginRenderBasic() {
    }

    @Override
    public void endRenderBasic() {
    }

    public void setupFramebuffer() {
        if (this.fbWidth != this.minecraft.resolution.width || this.fbHeight != this.minecraft.resolution.height || !this.gameFramebuffer.isGenerated() || !this.worldFramebuffer.isGenerated()) {
            this.worldFramebuffer.generate();
            this.worldFramebufferTex.generate();
            this.worldFramebufferDepth.generate();
            this.gameFramebuffer.generate();
            this.gameFramebufferTex.generate();
            this.gameFramebufferDepth.generate();
            this.fbWidth = this.minecraft.resolution.width;
            this.fbHeight = this.minecraft.resolution.height;
            System.out.println("Setup Framebuffer: " + this.fbWidth + " x " + this.fbHeight);
            Buffer.checkBufferSize(this.fbWidth * this.fbHeight * 4);
            this.worldFramebuffer.bind();
            this.worldFramebufferTex.bind();
            Buffer.reset();
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.fbWidth, (int)this.fbHeight, (int)0, (int)6408, (int)5121, (ByteBuffer)Buffer.buffer);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            ARBFramebufferObject.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.worldFramebufferTex.id(), (int)0);
            this.worldFramebufferDepth.bind();
            Buffer.reset();
            GL11.glTexImage2D((int)3553, (int)0, (int)6402, (int)this.fbWidth, (int)this.fbHeight, (int)0, (int)6402, (int)5121, (ByteBuffer)Buffer.buffer);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            ARBFramebufferObject.glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)this.worldFramebufferDepth.id(), (int)0);
            this.gameFramebuffer.bind();
            this.gameFramebufferTex.bind();
            Buffer.reset();
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.fbWidth, (int)this.fbHeight, (int)0, (int)6408, (int)5121, (ByteBuffer)Buffer.buffer);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            ARBFramebufferObject.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.gameFramebufferTex.id(), (int)0);
            this.gameFramebufferDepth.bind();
            Buffer.reset();
            GL11.glTexImage2D((int)3553, (int)0, (int)6402, (int)this.fbWidth, (int)this.fbHeight, (int)0, (int)6402, (int)5121, (ByteBuffer)Buffer.buffer);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            ARBFramebufferObject.glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)this.gameFramebufferDepth.id(), (int)0);
            ARBFramebufferObject.glBindFramebuffer((int)36160, (int)0);
        }
    }

    public abstract ResourceProvider getShader();

    @Override
    public void reload() {
        this.shaderpack.deleteAll();
        ResourceProvider shaderFolder = this.getShader();
        if (shaderFolder != null) {
            try {
                this.shaderpack.postShader.compile(shaderFolder, "post");
                System.out.println("Compiled Post Shader: " + this.shaderpack.postShader.isUsable());
            }
            catch (Exception e2) {
                System.err.println("Error compiling post shader: " + e2.getClass().getName() + ": " + e2.getMessage());
            }
            try {
                this.shaderpack.basicShader.compile(shaderFolder, "basic");
                System.out.println("Compiled Basic Shader: " + this.shaderpack.basicShader.isUsable());
            }
            catch (Exception e3) {
                System.err.println("Error compiling basic shader: " + e3.getClass().getName() + ": " + e3.getMessage());
            }
            try {
                this.shaderpack.texturedShader.compile(shaderFolder, "textured");
                System.out.println("Compiled Textured Shader: " + this.shaderpack.texturedShader.isUsable());
            }
            catch (Exception e4) {
                System.err.println("Error compiling textured shader: " + e4.getClass().getName() + ": " + e4.getMessage());
            }
            try {
                this.shaderpack.terrainShader.compile(shaderFolder, "terrain");
                System.out.println("Compiled Terrain Shader: " + this.shaderpack.terrainShader.isUsable());
            }
            catch (Exception e5) {
                System.err.println("Error compiling terrain shader: " + e5.getClass().getName() + ": " + e5.getMessage());
            }
            try {
                this.shaderpack.finalShader.compile(shaderFolder, "base");
                System.out.println("Compiled Base Shader: " + this.shaderpack.finalShader.isUsable());
            }
            catch (Exception e6) {
                System.err.println("Error compiling base shader: " + e6.getClass().getName() + ": " + e6.getMessage());
            }
        } else {
            this.shaderpack.finalShader.compile(internalShaderFolder, "base");
        }
    }

    @Override
    public boolean clearDepthBeforeRenderHand() {
        return false;
    }

    @Override
    public void disableShader() {
        System.out.println("Disabled Shader");
        ARBFramebufferObject.glBindFramebuffer((int)36160, (int)0);
        GL20.glUseProgram((int)0);
    }

    @Override
    public void delete() {
        this.gameFramebuffer.delete();
        this.gameFramebufferDepth.delete();
        this.gameFramebufferTex.delete();
        this.worldFramebuffer.delete();
        this.worldFramebufferDepth.delete();
        this.worldFramebufferTex.delete();
    }

    @Override
    public void create() {
    }
}

