/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.render;

import java.nio.ByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.src.helper.Buffer;
import net.minecraft.src.render.Framebuffer;
import net.minecraft.src.render.IRenderer;
import net.minecraft.src.render.Shaderpack;
import net.minecraft.src.render.Shaders;
import net.minecraft.src.render.ShadersRenderer;
import net.minecraft.src.render.Texture;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class ShadersRendererBuiltin
implements IRenderer {
    public static boolean shader = true;
    public final Minecraft minecraft;
    private final Framebuffer gameFramebuffer = new Framebuffer();
    private final Texture colortex = new Texture();
    private final Texture depthtex = new Texture();
    private int fbWidth;
    private int fbHeight;
    public final Shaderpack shaderpack = new Shaderpack();

    public ShadersRendererBuiltin(Minecraft minecraft) {
        this.minecraft = minecraft;
        if (!Shaders.shadersCompatible) {
            throw new RuntimeException("Shaders not compatible!");
        }
    }

    @Override
    public void beginRenderGame() {
        this.setupFramebuffer();
        this.gameFramebuffer.bind();
        GL20.glUseProgram((int)0);
    }

    @Override
    public void endRenderGame() {
        ARBFramebufferObject.glBindFramebuffer((int)36160, (int)0);
        if (this.shaderpack.finalShader.isUsable()) {
            this.shaderpack.finalShader.bind();
            ARBMultitexture.glActiveTextureARB((int)33984);
            this.colortex.bind();
            this.shaderpack.finalShader.uniformInt("colortex0", 0);
            Shaders.setUniforms(this.minecraft, this.shaderpack.finalShader);
        } else {
            this.colortex.bind();
            GL20.glUseProgram((int)0);
        }
        Shaders.drawFullscreenRect();
        GL20.glUseProgram((int)0);
    }

    public void setupFramebuffer() {
        if (this.minecraft.resolution.width != this.fbWidth || this.minecraft.resolution.height != this.fbHeight || !this.gameFramebuffer.isGenerated()) {
            this.gameFramebuffer.generate();
            this.colortex.generate();
            this.depthtex.generate();
            this.fbWidth = this.minecraft.resolution.width;
            this.fbHeight = this.minecraft.resolution.height;
            Buffer.checkBufferSize(this.fbWidth * this.fbHeight * 4);
            this.gameFramebuffer.bind();
            this.colortex.bind();
            Buffer.reset();
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.fbWidth, (int)this.fbHeight, (int)0, (int)6408, (int)5121, (ByteBuffer)Buffer.buffer);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            ARBFramebufferObject.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.colortex.id(), (int)0);
            this.depthtex.bind();
            Buffer.reset();
            GL11.glTexImage2D((int)3553, (int)0, (int)6402, (int)this.fbWidth, (int)this.fbHeight, (int)0, (int)6402, (int)5121, (ByteBuffer)Buffer.buffer);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            ARBFramebufferObject.glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)this.depthtex.id(), (int)0);
            ARBFramebufferObject.glBindFramebuffer((int)36160, (int)0);
        }
    }

    @Override
    public void reload() {
        this.shaderpack.deleteAll();
        this.shaderpack.finalShader.compile(ShadersRenderer.internalShaderFolder, "base");
    }

    @Override
    public void disableShader() {
        ARBFramebufferObject.glBindFramebuffer((int)36160, (int)0);
        GL20.glUseProgram((int)0);
    }

    @Override
    public void delete() {
        this.gameFramebuffer.delete();
        this.colortex.delete();
        this.depthtex.delete();
        this.shaderpack.deleteAll();
    }

    @Override
    public void beginRenderTextured() {
    }

    @Override
    public void endRenderTextured() {
    }

    @Override
    public void beginRenderBasic() {
    }

    @Override
    public void endRenderBasic() {
    }

    @Override
    public void beginRenderWorld() {
    }

    @Override
    public void endRenderWorld() {
    }

    @Override
    public void beginRenderTerrain() {
    }

    @Override
    public void endRenderTerrain() {
    }

    @Override
    public void create() {
    }
}

