#version 120

//#define CRT

uniform sampler2D colortex0;
uniform sampler2D depthtex0;

uniform float gamma;

uniform float width;
uniform float height;

varying vec2 texcoord;

#define PI 3.14159

void main(){
	vec3 color = vec3(0.0);
	
	float depth = texture2D(depthtex0, texcoord).r;
	
	#ifdef CRT
	float crt = 1.0;
	//crt *= sin(texcoord.x * 2560);
	crt *= (sin(texcoord.x * width * PI) * 0.5 + 0.5);
	crt *= (sin(texcoord.y * height * PI * 0.5) * 0.5 + 0.5);
	
	crt = crt * 0.5 + 0.5;
	//crt = clamp(crt, 0.0, 1.0);
	
	//vec2 offset = vec2(2.0 / width, 2.0 / height);
	vec2 offset = vec2(1.0 / width, 1.0 / height);
	for(int i=0; i < 2; i++){
		for(int j=0; j < 2; j++){
			//vec2 k = vec2(i - 0.5, j - 0.5);
			vec2 k = vec2(i, j);
			color += texture2D(colortex0, texcoord.xy + offset * k).rgb;
		}
	}
	color /= 4.0;
	
	color = color * crt * 1.5;
	
	#endif
	
	#ifndef CRT
	color = texture2D(colortex0, texcoord.xy).rgb;
	#endif
	
	color = pow(color, vec3(1.0 - gamma + 0.5));
	
	gl_FragColor = vec4(color, 1.0);
	
	//gl_FragColor = texture2D(depthtex0, texcoord.xy);
}