#version 120

uniform sampler2D colortex0;
uniform float intensity;

varying vec2 texcoord;

void main(){
	vec3 color = texture2D(colortex0, texcoord).rgb;
	
	float vignette = length(vec2(texcoord - 0.5)) * intensity;
	vignette = clamp((vignette - 0.3) * 3, 0.0, 1.0);
	
	color = mix(color, vec3(0.0), vignette);
	
	gl_FragColor = vec4(color, 1.0);
}