/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level;

import com.mojang.minecraft.Entity;
import com.mojang.minecraft.a.g;
import com.mojang.minecraft.b.c;
import com.mojang.minecraft.b.n;
import com.mojang.minecraft.character.d;
import com.mojang.minecraft.f;
import com.mojang.minecraft.h;
import com.mojang.minecraft.level.b;
import com.mojang.minecraft.level.b.a;
import com.mojang.minecraft.phys.AABB;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

public class Level
implements Serializable {
    public static final long serialVersionUID = 0L;
    public int width;
    public int height;
    public int depth;
    public byte[] blocks;
    public String name;
    public String creator;
    public long createTime;
    public int xSpawn;
    public int ySpawn;
    public int zSpawn;
    public float rotSpawn;
    private transient ArrayList a = new ArrayList();
    private transient int[] b;
    private transient Random c = new Random();
    private transient int d = this.c.nextInt();
    private transient ArrayList e = new ArrayList();
    public ArrayList entities = new ArrayList();
    private boolean networkMode = false;
    public transient h rendererContext$5cd64a7f;
    int unprocessed = 0;
    private int tickCount = 0;

    public void initTransient() {
        if (this.blocks == null) {
            throw new RuntimeException("The level is corrupt!");
        }
        this.a = new ArrayList();
        this.b = new int[this.width * this.height];
        Arrays.fill(this.b, this.depth);
        this.calcLightDepths(0, 0, this.width, this.height);
        this.c = new Random();
        this.d = this.c.nextInt();
        this.e = new ArrayList();
        if (this.entities == null) {
            this.entities = new ArrayList();
        }
        if (this.xSpawn == 0 && this.ySpawn == 0 && this.zSpawn == 0) {
            this.findSpawn();
        }
    }

    public void setData(int n2, int n3, int n4, byte[] byArray) {
        this.width = n2;
        this.height = n4;
        this.depth = n3;
        this.blocks = byArray;
        this.b = new int[n2 * n4];
        Arrays.fill(this.b, this.depth);
        this.calcLightDepths(0, 0, n2, n4);
        for (n2 = 0; n2 < this.a.size(); ++n2) {
            ((g)this.a.get(n2)).a();
        }
        this.e.clear();
        this.findSpawn();
        System.gc();
    }

    public void findSpawn() {
        int n2;
        int n3;
        int n4;
        Random random = new Random();
        int n5 = 0;
        do {
            n3 = random.nextInt(this.width / 2) + this.width / 4;
            n2 = random.nextInt(this.height / 2) + this.height / 4;
            n4 = this.getHighestTile(n3, n2) + 1;
            if (++n5 != 10000) continue;
            this.xSpawn = n3;
            this.ySpawn = -100;
            this.zSpawn = n2;
            return;
        } while ((float)n4 <= this.getWaterLevel());
        this.xSpawn = n3;
        this.ySpawn = n4;
        this.zSpawn = n2;
    }

    public void calcLightDepths(int n2, int n3, int n4, int n5) {
        for (int i2 = n2; i2 < n2 + n4; ++i2) {
            for (int i3 = n3; i3 < n3 + n5; ++i3) {
                int n6;
                int n7 = this.b[i2 + i3 * this.width];
                for (n6 = this.depth - 1; n6 > 0 && !this.isLightBlocker(i2, n6, i3); --n6) {
                }
                this.b[i2 + i3 * this.width] = n6 + 1;
                if (n7 == n6) continue;
                int n8 = n7 < n6 ? n7 : n6;
                n7 = n7 > n6 ? n7 : n6;
                for (n6 = 0; n6 < this.a.size(); ++n6) {
                    ((g)this.a.get(n6)).a(i2 - 1, n8 - 1, i3 - 1, i2 + 1, n7 + 1, i3 + 1);
                }
            }
        }
    }

    public void addListener$74652038(g g2) {
        this.a.add(g2);
    }

    public void finalize() {
    }

    public void removeListener$74652038(g g2) {
        this.a.remove(g2);
    }

    public boolean isLightBlocker(int n2, int n3, int n4) {
        com.mojang.minecraft.level.tile.a a2 = com.mojang.minecraft.level.tile.a.b[this.getTile(n2, n3, n4)];
        return a2 == null ? false : a2.a();
    }

    public ArrayList getCubes(AABB aABB) {
        ArrayList<AABB> arrayList = new ArrayList<AABB>();
        int n2 = (int)aABB.x0;
        int n3 = (int)aABB.x1 + 1;
        int n4 = (int)aABB.y0;
        int n5 = (int)aABB.y1 + 1;
        int n6 = (int)aABB.z0;
        int n7 = (int)aABB.z1 + 1;
        if (aABB.x0 < 0.0f) {
            --n2;
        }
        if (aABB.y0 < 0.0f) {
            --n4;
        }
        if (aABB.z0 < 0.0f) {
            --n6;
        }
        for (int i2 = n2; i2 < n3; ++i2) {
            for (n2 = n4; n2 < n5; ++n2) {
                for (int i3 = n6; i3 < n7; ++i3) {
                    AABB aABB2;
                    if (i2 >= 0 && n2 >= 0 && i3 >= 0 && i2 < this.width && n2 < this.depth && i3 < this.height) {
                        com.mojang.minecraft.level.tile.a a2 = com.mojang.minecraft.level.tile.a.b[this.getTile(i2, n2, i3)];
                        if (a2 == null || (aABB2 = a2.a(i2, n2, i3)) == null) continue;
                        arrayList.add(aABB2);
                        continue;
                    }
                    if (i2 >= 0 && n2 >= 0 && i3 >= 0 && i2 < this.width && i3 < this.height || (aABB2 = com.mojang.minecraft.level.tile.a.j.a(i2, n2, i3)) == null) continue;
                    arrayList.add(aABB2);
                }
            }
        }
        return arrayList;
    }

    public void swap(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (!this.networkMode) {
            int n8 = this.getTile(n2, n3, n4);
            int n9 = this.getTile(n5, n6, n7);
            this.setTileNoNeighborChange(n2, n3, n4, n9);
            this.setTileNoNeighborChange(n5, n6, n7, n8);
            this.updateNeighborsAt(n2, n3, n4, n9);
            this.updateNeighborsAt(n5, n6, n7, n8);
        }
    }

    public boolean setTileNoNeighborChange(int n2, int n3, int n4, int n5) {
        return this.networkMode ? false : this.netSetTileNoNeighborChange(n2, n3, n4, n5);
    }

    public boolean netSetTileNoNeighborChange(int n2, int n3, int n4, int n5) {
        if (n2 >= 0 && n3 >= 0 && n4 >= 0 && n2 < this.width && n3 < this.depth && n4 < this.height) {
            if (n5 == this.blocks[(n3 * this.height + n4) * this.width + n2]) {
                return false;
            }
            if (n5 == 0 && (n2 == 0 || n4 == 0 || n2 == this.width - 1 || n4 == this.height - 1) && (float)n3 >= this.getGroundLevel() && (float)n3 < this.getWaterLevel()) {
                n5 = com.mojang.minecraft.level.tile.a.k.T;
            }
            byte by = this.blocks[(n3 * this.height + n4) * this.width + n2];
            this.blocks[(n3 * this.height + n4) * this.width + n2] = (byte)n5;
            if (by != 0) {
                com.mojang.minecraft.level.tile.a.b[by].d(this, n2, n3, n4);
            }
            if (n5 != 0) {
                com.mojang.minecraft.level.tile.a.b[n5].c(this, n2, n3, n4);
            }
            this.calcLightDepths(n2, n4, 1, 1);
            for (n5 = 0; n5 < this.a.size(); ++n5) {
                ((g)this.a.get(n5)).a(n2 - 1, n3 - 1, n4 - 1, n2 + 1, n3 + 1, n4 + 1);
            }
            return true;
        }
        return false;
    }

    public boolean setTile(int n2, int n3, int n4, int n5) {
        if (this.networkMode) {
            return false;
        }
        if (this.setTileNoNeighborChange(n2, n3, n4, n5)) {
            this.updateNeighborsAt(n2, n3, n4, n5);
            return true;
        }
        return false;
    }

    public boolean netSetTile(int n2, int n3, int n4, int n5) {
        if (this.netSetTileNoNeighborChange(n2, n3, n4, n5)) {
            this.updateNeighborsAt(n2, n3, n4, n5);
            return true;
        }
        return false;
    }

    public void updateNeighborsAt(int n2, int n3, int n4, int n5) {
        this.a(n2 - 1, n3, n4, n5);
        this.a(n2 + 1, n3, n4, n5);
        this.a(n2, n3 - 1, n4, n5);
        this.a(n2, n3 + 1, n4, n5);
        this.a(n2, n3, n4 - 1, n5);
        this.a(n2, n3, n4 + 1, n5);
    }

    public boolean setTileNoUpdate(int n2, int n3, int n4, int n5) {
        if (n2 >= 0 && n3 >= 0 && n4 >= 0 && n2 < this.width && n3 < this.depth && n4 < this.height) {
            if (n5 == this.blocks[(n3 * this.height + n4) * this.width + n2]) {
                return false;
            }
            this.blocks[(n3 * this.height + n4) * this.width + n2] = (byte)n5;
            return true;
        }
        return false;
    }

    private void a(int n2, int n3, int n4, int n5) {
        com.mojang.minecraft.level.tile.a a2;
        if (n2 >= 0 && n3 >= 0 && n4 >= 0 && n2 < this.width && n3 < this.depth && n4 < this.height && (a2 = com.mojang.minecraft.level.tile.a.b[this.blocks[(n3 * this.height + n4) * this.width + n2]]) != null) {
            a2.a(this, n2, n3, n4, n5);
        }
    }

    public boolean isLit(int n2, int n3, int n4) {
        return n2 >= 0 && n3 >= 0 && n4 >= 0 && n2 < this.width && n3 < this.depth && n4 < this.height ? n3 >= this.b[n2 + n4 * this.width] : true;
    }

    public int getTile(int n2, int n3, int n4) {
        return n2 >= 0 && n3 >= 0 && n4 >= 0 && n2 < this.width && n3 < this.depth && n4 < this.height ? this.blocks[(n3 * this.height + n4) * this.width + n2] & 0xFF : 0;
    }

    public boolean isSolidTile(int n2, int n3, int n4) {
        com.mojang.minecraft.level.tile.a a2 = com.mojang.minecraft.level.tile.a.b[this.getTile(n2, n3, n4)];
        return a2 == null ? false : a2.b();
    }

    public void tickEntities() {
        for (int i2 = 0; i2 < this.entities.size(); ++i2) {
            ((Entity)this.entities.get(i2)).tick();
            if (!((Entity)this.entities.get((int)i2)).removed) continue;
            this.entities.remove(i2--);
        }
    }

    public void tick() {
        int n2;
        int n3;
        int n4;
        ++this.tickCount;
        int n5 = 1;
        int n6 = 1;
        while (1 << n5 < this.width) {
            ++n5;
        }
        while (1 << n6 < this.height) {
            ++n6;
        }
        int n7 = this.height - 1;
        int n8 = this.width - 1;
        int n9 = this.depth - 1;
        if (this.tickCount % 5 == 0) {
            n4 = this.e.size();
            for (n3 = 0; n3 < n4; ++n3) {
                b b2 = (b)this.e.remove(0);
                if (b2.e > 0) {
                    --b2.e;
                    this.e.add(b2);
                    continue;
                }
                if (!this.a(b2.a, b2.b, b2.c) || (n2 = this.blocks[(b2.b * this.height + b2.c) * this.width + b2.a]) != b2.d || n2 <= 0) continue;
                com.mojang.minecraft.level.tile.a.b[n2].a(this, b2.a, b2.b, b2.c, this.c);
            }
        }
        this.unprocessed += this.width * this.height * this.depth;
        n4 = this.unprocessed / 200;
        this.unprocessed -= n4 * 200;
        for (n3 = 0; n3 < n4; ++n3) {
            this.d = this.d * 3 + 1013904223;
            int n10 = this.d >> 2;
            int n11 = n10 >> n5 & n7;
            n2 = n10 & n8;
            byte by = this.blocks[((n10 = n10 >> n5 + n6 & n9) * this.height + n11) * this.width + n2];
            if (!com.mojang.minecraft.level.tile.a.c[by]) continue;
            com.mojang.minecraft.level.tile.a.b[by].a(this, n2, n10, n11, this.c);
        }
    }

    private boolean a(int n2, int n3, int n4) {
        return n2 >= 0 && n3 >= 0 && n4 >= 0 && n2 < this.width && n3 < this.depth && n4 < this.height;
    }

    public float getGroundLevel() {
        return this.depth / 2 - 2;
    }

    public float getWaterLevel() {
        return this.depth / 2;
    }

    public boolean containsAnyLiquid(AABB aABB) {
        int n2 = (int)aABB.x0;
        int n3 = (int)aABB.x1 + 1;
        int n4 = (int)aABB.y0;
        int n5 = (int)aABB.y1 + 1;
        int n6 = (int)aABB.z0;
        int n7 = (int)aABB.z1 + 1;
        if (aABB.x0 < 0.0f) {
            --n2;
        }
        if (aABB.y0 < 0.0f) {
            --n4;
        }
        if (aABB.z0 < 0.0f) {
            --n6;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n3 > this.width) {
            n3 = this.width;
        }
        if (n5 > this.depth) {
            n5 = this.depth;
        }
        if (n7 > this.height) {
            n7 = this.height;
        }
        for (int i2 = n2; i2 < n3; ++i2) {
            for (n2 = n4; n2 < n5; ++n2) {
                for (int i3 = n6; i3 < n7; ++i3) {
                    com.mojang.minecraft.level.tile.a a2 = com.mojang.minecraft.level.tile.a.b[this.getTile(i2, n2, i3)];
                    if (a2 == null || a2.c() == com.mojang.minecraft.level.b.a.a) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean containsLiquid(AABB aABB, a a2) {
        int n2 = (int)aABB.x0;
        int n3 = (int)aABB.x1 + 1;
        int n4 = (int)aABB.y0;
        int n5 = (int)aABB.y1 + 1;
        int n6 = (int)aABB.z0;
        int n7 = (int)aABB.z1 + 1;
        if (aABB.x0 < 0.0f) {
            --n2;
        }
        if (aABB.y0 < 0.0f) {
            --n4;
        }
        if (aABB.z0 < 0.0f) {
            --n6;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n3 > this.width) {
            n3 = this.width;
        }
        if (n5 > this.depth) {
            n5 = this.depth;
        }
        if (n7 > this.height) {
            n7 = this.height;
        }
        for (int i2 = n2; i2 < n3; ++i2) {
            for (n2 = n4; n2 < n5; ++n2) {
                for (int i3 = n6; i3 < n7; ++i3) {
                    com.mojang.minecraft.level.tile.a a3 = com.mojang.minecraft.level.tile.a.b[this.getTile(i2, n2, i3)];
                    if (a3 == null || a3.c() != a2) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void addToTickNextTick(int n2, int n3, int n4, int n5) {
        if (!this.networkMode) {
            b b2 = new b(n2, n3, n4, n5);
            if (n5 > 0) {
                b2.e = n4 = com.mojang.minecraft.level.tile.a.b[n5].d();
            }
            this.e.add(b2);
        }
    }

    public boolean isFree(AABB aABB) {
        for (int i2 = 0; i2 < this.entities.size(); ++i2) {
            if (!((Entity)this.entities.get((int)i2)).bb.intersects(aABB)) continue;
            return false;
        }
        return true;
    }

    public boolean isSolid(float f2, float f3, float f4, float f5) {
        return this.a(f2 - f5, f3 - f5, f4 - f5) ? true : (this.a(f2 - f5, f3 - f5, f4 + f5) ? true : (this.a(f2 - f5, f3 + f5, f4 - f5) ? true : (this.a(f2 - f5, f3 + f5, f4 + f5) ? true : (this.a(f2 + f5, f3 - f5, f4 - f5) ? true : (this.a(f2 + f5, f3 - f5, f4 + f5) ? true : (this.a(f2 + f5, f3 + f5, f4 - f5) ? true : this.a(f2 + f5, f3 + f5, f4 + f5)))))));
    }

    private boolean a(float f2, float f3, float f4) {
        int n2 = this.getTile((int)f2, (int)f3, (int)f4);
        return n2 > 0 && com.mojang.minecraft.level.tile.a.b[n2].b();
    }

    public int getHighestTile(int n2, int n3) {
        int n4;
        for (n4 = this.depth; (this.getTile(n2, n4 - 1, n3) == 0 || com.mojang.minecraft.level.tile.a.b[this.getTile(n2, n4 - 1, n3)].c() != com.mojang.minecraft.level.b.a.a) && n4 > 0; --n4) {
        }
        return n4;
    }

    public void setSpawnPos(int n2, int n3, int n4, float f2) {
        this.xSpawn = n2;
        this.ySpawn = n3;
        this.zSpawn = n4;
        this.rotSpawn = f2;
    }

    public float getBrightness(int n2, int n3, int n4) {
        return this.isLit(n2, n3, n4) ? 1.0f : 0.6f;
    }

    public float getCaveness(float f2, float f3, float f4, float f5) {
        int n2 = (int)f2;
        int n3 = (int)f3;
        int n4 = (int)f4;
        float f6 = 0.0f;
        float f7 = 0.0f;
        for (int i2 = n2 - 6; i2 <= n2 + 6; ++i2) {
            for (int i3 = n4 - 6; i3 <= n4 + 6; ++i3) {
                if (!this.a(i2, n3, i3) || this.isSolidTile(i2, n3, i3)) continue;
                float f8 = (float)i2 + 0.5f - f2;
                float f9 = (float)i3 + 0.5f - f4;
                float f10 = (float)(Math.atan2(f9, f8) - (double)f5 * Math.PI / 180.0 + 1.5707963267948966);
                while ((double)f10 < -Math.PI) {
                    f10 = (float)((double)f10 + Math.PI * 2);
                }
                while ((double)f10 >= Math.PI) {
                    f10 = (float)((double)f10 - Math.PI * 2);
                }
                if (f10 < 0.0f) {
                    f10 = -f10;
                }
                f8 = (float)Math.sqrt(f8 * f8 + 4.0f + f9 * f9);
                f8 = 1.0f / f8;
                if (f10 > 1.0f) {
                    f8 = 0.0f;
                }
                if (f8 < 0.0f) {
                    f8 = 0.0f;
                }
                f7 += f8;
                if (!this.isLit(i2, n3, i3)) continue;
                f6 += f8;
            }
        }
        if (f7 == 0.0f) {
            return 0.0f;
        }
        return f6 / f7;
    }

    public float getCaveness(Entity entity) {
        float f2;
        float f3 = (float)Math.cos((double)(-entity.yRot) * Math.PI / 180.0 + Math.PI);
        float f4 = (float)Math.sin((double)(-entity.yRot) * Math.PI / 180.0 + Math.PI);
        float f5 = (float)Math.cos((double)(-entity.xRot) * Math.PI / 180.0);
        float f6 = (float)Math.sin((double)(-entity.xRot) * Math.PI / 180.0);
        float f7 = entity.x;
        float f8 = entity.y;
        float f9 = entity.z;
        float f10 = 1.6f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        for (int i2 = 0; i2 <= 200; ++i2) {
            float f13 = ((float)i2 / 200.0f - 0.5f) * 2.0f;
            for (int i3 = 0; i3 <= 200; ++i3) {
                float f14;
                float f15;
                float f16;
                float f17 = ((float)i3 / 200.0f - 0.5f) * f10;
                float f18 = f5 * f17 + f6;
                f17 = f5 - f6 * f17;
                float f19 = f3 * f13 + f4 * f17;
                f17 = f3 * f17 - f4 * f13;
                for (int i4 = 0; i4 < 10 && !this.a(f16 = f7 + f19 * (float)i4 * 0.8f, f15 = f8 + f18 * (float)i4 * 0.8f, f14 = f9 + f17 * (float)i4 * 0.8f); ++i4) {
                    f11 += 1.0f;
                    if (!this.isLit((int)f16, (int)f15, (int)f14)) continue;
                    f12 += 1.0f;
                }
            }
        }
        if (f11 == 0.0f) {
            return 0.0f;
        }
        float f20 = f12 / f11 / 0.1f;
        if (f2 > 1.0f) {
            f20 = 1.0f;
        }
        f20 = 1.0f - f20;
        return 1.0f - f20 * f20 * f20;
    }

    public byte[] copyBlocks() {
        return Arrays.copyOf(this.blocks, this.blocks.length);
    }

    public boolean isWater(int n2, int n3, int n4) {
        int n5 = this.getTile(n2, n3, n4);
        return n5 > 0 && com.mojang.minecraft.level.tile.a.b[n5].c() == com.mojang.minecraft.level.b.a.b;
    }

    public void setNetworkMode(boolean bl) {
        this.networkMode = bl;
    }

    public f clip(d d2, d d3) {
        if (!(Float.isNaN(d2.a) || Float.isNaN(d2.b) || Float.isNaN(d2.c))) {
            if (!(Float.isNaN(d3.a) || Float.isNaN(d3.b) || Float.isNaN(d3.c))) {
                int n2;
                int n3;
                int n4 = (int)Math.floor(d3.a);
                int n5 = (int)Math.floor(d3.b);
                int n6 = (int)Math.floor(d3.c);
                int n7 = (int)Math.floor(d2.a);
                int n8 = (int)Math.floor(d2.b);
                int n9 = (int)Math.floor(d2.c);
                int n10 = 20;
                do {
                    if (n10-- < 0) {
                        return null;
                    }
                    if (Float.isNaN(d2.a) || Float.isNaN(d2.b) || Float.isNaN(d2.c)) {
                        return null;
                    }
                    if (n7 == n4 && n8 == n5 && n9 == n6) {
                        return null;
                    }
                    float f2 = 999.0f;
                    float f3 = 999.0f;
                    float f4 = 999.0f;
                    if (n4 > n7) {
                        f2 = (float)n7 + 1.0f;
                    }
                    if (n4 < n7) {
                        f2 = n7;
                    }
                    if (n5 > n8) {
                        f3 = (float)n8 + 1.0f;
                    }
                    if (n5 < n8) {
                        f3 = n8;
                    }
                    if (n6 > n9) {
                        f4 = (float)n9 + 1.0f;
                    }
                    if (n6 < n9) {
                        f4 = n9;
                    }
                    float f5 = 999.0f;
                    float f6 = 999.0f;
                    float f7 = 999.0f;
                    float f8 = d3.a - d2.a;
                    float f9 = d3.b - d2.b;
                    float f10 = d3.c - d2.c;
                    if (f2 != 999.0f) {
                        f5 = (f2 - d2.a) / f8;
                    }
                    if (f3 != 999.0f) {
                        f6 = (f3 - d2.b) / f9;
                    }
                    if (f4 != 999.0f) {
                        f7 = (f4 - d2.c) / f10;
                    }
                    boolean bl = false;
                    if (f5 < f6 && f5 < f7) {
                        n2 = n4 > n7 ? 4 : 5;
                        d2.a = f2;
                        d2.b += f9 * f5;
                        d2.c += f10 * f5;
                    } else if (f6 < f7) {
                        n2 = n5 > n8 ? 0 : 1;
                        d2.a += f8 * f6;
                        d2.b = f3;
                        d2.c += f10 * f6;
                    } else {
                        n2 = n6 > n9 ? 2 : 3;
                        d2.a += f8 * f7;
                        d2.b += f9 * f7;
                        d2.c = f4;
                    }
                    n7 = (int)Math.floor(d2.a);
                    if (n2 == 5) {
                        --n7;
                    }
                    n8 = (int)Math.floor(d2.b);
                    if (n2 == 1) {
                        --n8;
                    }
                    n9 = (int)Math.floor(d2.c);
                    if (n2 != 3) continue;
                    --n9;
                } while ((n3 = this.getTile(n7, n8, n9)) <= 0 || com.mojang.minecraft.level.tile.a.b[n3].c() != com.mojang.minecraft.level.b.a.a);
                return new f(0, n7, n8, n9, n2);
            }
            return null;
        }
        return null;
    }

    public void playSound(String string, Entity entity, float f2, float f3) {
        if (this.rendererContext$5cd64a7f != null) {
            com.mojang.minecraft.b.h h2;
            h h3 = this.rendererContext$5cd64a7f;
            if (h3.B != null && (h2 = h3.t.a(string, f2, f3)) != null) {
                System.out.println(string);
                h3.B.a(h2, new c(entity, h3.e));
            }
        }
    }

    public void playSound(String string, float f2, float f3, float f4, float f5, float f6) {
        System.out.println(string);
        if (this.rendererContext$5cd64a7f != null) {
            com.mojang.minecraft.b.h h2;
            h h3 = this.rendererContext$5cd64a7f;
            if (h3.B != null && (h2 = h3.t.a(string, f5, f6)) != null) {
                h3.B.a(h2, new n(f2, f3, f4, h3.e));
            }
        }
    }
}

