/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.item;

import com.mojang.minecraft.Entity;
import com.mojang.minecraft.a.a;
import com.mojang.minecraft.a.c;
import com.mojang.minecraft.item.TakeEntityAnim;
import com.mojang.minecraft.level.Level;
import com.mojang.minecraft.phys.AABB;
import com.mojang.minecraft.player.Player;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class Arrow
extends Entity {
    public static final long serialVersionUID = 0L;
    private float xd;
    private float yd;
    private float zd;
    private float yRot;
    private float xRot;
    private float yRotO;
    private float xRotO;
    private boolean hasHit = false;
    private int stickTime = 0;
    private Entity owner;
    private int time = 0;
    private int type = 0;
    private float gravity = 0.0f;
    private int damage;

    public Arrow(Level level, Entity entity, float f2, float f3, float f4, float f5, float f6, float f7) {
        super(level);
        this.owner = entity;
        this.setSize(0.3f, 0.5f);
        this.heightOffset = this.bbHeight / 2.0f;
        this.damage = 3;
        if (!(entity instanceof Player)) {
            this.type = 1;
        } else {
            this.damage = 7;
        }
        this.heightOffset = 0.25f;
        float f8 = (float)Math.cos((double)(-f5) * Math.PI / 180.0 - Math.PI);
        float f9 = (float)Math.sin((double)(-f5) * Math.PI / 180.0 - Math.PI);
        f5 = (float)Math.cos((double)(-f6) * Math.PI / 180.0);
        f6 = (float)Math.sin((double)(-f6) * Math.PI / 180.0);
        this.slide = false;
        this.gravity = 1.0f / f7;
        this.xo -= f8 * 0.2f;
        this.zo += f9 * 0.2f;
        this.xd = f9 * f5 * f7;
        this.yd = f6 * f7;
        this.zd = f8 * f5 * f7;
        this.setPos(f2 -= f8 * 0.2f, f3, f4 += f9 * 0.2f);
        f8 = (float)Math.sqrt(this.xd * this.xd + this.zd * this.zd);
        this.yRotO = this.yRot = (float)(Math.atan2(this.xd, this.zd) * 180.0 / Math.PI);
        this.xRotO = this.xRot = (float)(Math.atan2(this.yd, f8) * 180.0 / Math.PI);
        this.makeStepSound = false;
    }

    @Override
    public void tick() {
        block18: {
            block16: {
                block17: {
                    ++this.time;
                    this.xRotO = this.xRot;
                    this.yRotO = this.yRot;
                    this.xo = this.x;
                    this.yo = this.y;
                    this.zo = this.z;
                    if (!this.hasHit) break block16;
                    ++this.stickTime;
                    if (this.type != 0) break block17;
                    if (this.stickTime >= 300 && Math.random() < (double)0.01f) {
                        this.remove();
                        return;
                    }
                    break block18;
                }
                if (this.type != 1 || this.stickTime < 20) break block18;
                this.remove();
                break block18;
            }
            this.xd *= 0.998f;
            this.yd *= 0.998f;
            this.zd *= 0.998f;
            this.yd -= 0.02f * this.gravity;
            int n2 = (int)((float)Math.sqrt(this.xd * this.xd + this.yd * this.yd + this.zd * this.zd) / 0.2f + 1.0f);
            float f2 = this.xd / (float)n2;
            float f3 = this.yd / (float)n2;
            float f4 = this.zd / (float)n2;
            for (int i2 = 0; i2 < n2 && !this.collision; ++i2) {
                AABB aABB = this.bb.expand(f2, f3, f4);
                if (this.level.getCubes(aABB).size() > 0) {
                    this.collision = true;
                }
                List list = this.level.blockMap.getEntities(this, aABB);
                for (int i3 = 0; i3 < list.size(); ++i3) {
                    Entity entity = (Entity)list.get(i3);
                    if (!entity.isShootable() || entity == this.owner && this.time <= 5) continue;
                    entity.hurt(this, this.damage);
                    this.collision = true;
                    this.remove();
                    return;
                }
                if (this.collision) continue;
                this.bb.move(f2, f3, f4);
                this.x += f2;
                this.y += f3;
                this.z += f4;
                this.blockMap.moved(this);
            }
            if (this.collision) {
                this.hasHit = true;
                this.zd = 0.0f;
                this.yd = 0.0f;
                this.xd = 0.0f;
            }
            if (!this.hasHit) {
                float f5 = (float)Math.sqrt(this.xd * this.xd + this.zd * this.zd);
                this.yRot = (float)(Math.atan2(this.xd, this.zd) * 180.0 / Math.PI);
                this.xRot = (float)(Math.atan2(this.yd, f5) * 180.0 / Math.PI);
                while (this.xRot - this.xRotO < -180.0f) {
                    this.xRotO -= 360.0f;
                }
                while (this.xRot - this.xRotO >= 180.0f) {
                    this.xRotO += 360.0f;
                }
                while (this.yRot - this.yRotO < -180.0f) {
                    this.yRotO -= 360.0f;
                }
                while (this.yRot - this.yRotO >= 180.0f) {
                    this.yRotO += 360.0f;
                }
            }
        }
        if (this.x < this.owner.x) {
            this.xd += 0.25f;
        }
        if (this.x > this.owner.x) {
            this.xd -= 0.25f;
        }
        if (this.y < this.owner.y) {
            this.yd += 0.25f;
        }
        if (this.y > this.owner.y) {
            this.yd -= 0.25f;
        }
        if (this.z < this.owner.z) {
            this.zd += 0.25f;
        }
        if (this.z > this.owner.z) {
            this.zd -= 0.25f;
        }
    }

    @Override
    public void render$2a8c5a(a a2, float f2) {
        this.textureId = a2.a("/item/arrows.png");
        GL11.glBindTexture((int)3553, (int)this.textureId);
        float f3 = this.level.getBrightness((int)this.x, (int)this.y, (int)this.z);
        GL11.glPushMatrix();
        GL11.glColor4f((float)f3, (float)f3, (float)f3, (float)1.0f);
        GL11.glTranslatef((float)(this.xo + (this.x - this.xo) * f2), (float)(this.yo + (this.y - this.yo) * f2 - this.heightOffset / 2.0f), (float)(this.zo + (this.z - this.zo) * f2));
        GL11.glRotatef((float)(this.yRotO + (this.yRot - this.yRotO) * f2 - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(this.xRotO + (this.xRot - this.xRotO) * f2), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        c c2 = c.a;
        f2 = 0.5f;
        float f4 = (float)(0 + this.type * 10) / 32.0f;
        float f5 = (float)(5 + this.type * 10) / 32.0f;
        float f6 = 0.15625f;
        float f7 = (float)(5 + this.type * 10) / 32.0f;
        float f8 = (float)(10 + this.type * 10) / 32.0f;
        float f9 = 0.05625f;
        GL11.glScalef((float)0.05625f, (float)f9, (float)f9);
        GL11.glNormal3f((float)f9, (float)0.0f, (float)0.0f);
        c2.b();
        c2.a(-7.0f, -2.0f, -2.0f, 0.0f, f7);
        c2.a(-7.0f, -2.0f, 2.0f, f6, f7);
        c2.a(-7.0f, 2.0f, 2.0f, f6, f8);
        c2.a(-7.0f, 2.0f, -2.0f, 0.0f, f8);
        c2.a();
        GL11.glNormal3f((float)(-f9), (float)0.0f, (float)0.0f);
        c2.b();
        c2.a(-7.0f, 2.0f, -2.0f, 0.0f, f7);
        c2.a(-7.0f, 2.0f, 2.0f, f6, f7);
        c2.a(-7.0f, -2.0f, 2.0f, f6, f8);
        c2.a(-7.0f, -2.0f, -2.0f, 0.0f, f8);
        c2.a();
        for (int i2 = 0; i2 < 4; ++i2) {
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glNormal3f((float)0.0f, (float)(-f9), (float)0.0f);
            c2.a(-8.0f, -2.0f, 0.0f, 0.0f, f4);
            c2.a(8.0f, -2.0f, 0.0f, f2, f4);
            c2.a(8.0f, 2.0f, 0.0f, f2, f5);
            c2.a(-8.0f, 2.0f, 0.0f, 0.0f, f5);
            c2.a();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    @Override
    public void awardKillScore(Entity entity, int n2) {
        this.owner.awardKillScore(entity, n2);
    }

    public Entity getOwner() {
        return this.owner;
    }

    @Override
    public void playerTouch(Player player) {
        if (this.hasHit && this.owner == player && player.arrows < 99) {
            this.level.addEntity(new TakeEntityAnim(this.level, this, player));
            ++player.arrows;
            this.remove();
        }
    }
}

