/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import net.minecraft.client.HashEntry;

public class MCHashTable {
    private transient HashEntry[] slots = new HashEntry[16];
    private transient int count;
    private int threshold = 12;
    private final float growFactor = 0.75f;
    private volatile transient int versionStamp;

    private static int computeHash(int n2) {
        n2 ^= n2 >>> 20 ^ n2 >>> 12;
        return n2 ^ n2 >>> 7 ^ n2 >>> 4;
    }

    private static int getSlotIndex(int n2, int n3) {
        return n2 & n3 - 1;
    }

    public Object lookup(int n2) {
        int n3 = MCHashTable.computeHash(n2);
        HashEntry hashEntry = this.slots[MCHashTable.getSlotIndex(n3, this.slots.length)];
        while (hashEntry != null) {
            if (hashEntry.hashEntry == n2) {
                return hashEntry.valueEntry;
            }
            hashEntry = hashEntry.nextEntry;
        }
        return null;
    }

    public void addKey(int n2, Object object) {
        int n3 = MCHashTable.computeHash(n2);
        int n4 = MCHashTable.getSlotIndex(n3, this.slots.length);
        HashEntry hashEntry = this.slots[n4];
        while (hashEntry != null) {
            if (hashEntry.hashEntry == n2) {
                hashEntry.valueEntry = object;
            }
            hashEntry = hashEntry.nextEntry;
        }
        ++this.versionStamp;
        this.insert(n3, n2, object, n4);
    }

    private void grow(int n2) {
        HashEntry[] hashEntryArray = this.slots;
        int n3 = hashEntryArray.length;
        if (n3 == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        HashEntry[] hashEntryArray2 = new HashEntry[n2];
        this.copyTo(hashEntryArray2);
        this.slots = hashEntryArray2;
        this.threshold = (int)((float)n2 * 0.75f);
    }

    private void copyTo(HashEntry[] hashEntryArray) {
        HashEntry[] hashEntryArray2 = this.slots;
        int n2 = hashEntryArray.length;
        for (int i2 = 0; i2 < hashEntryArray2.length; ++i2) {
            HashEntry hashEntry;
            HashEntry hashEntry2 = hashEntryArray2[i2];
            if (hashEntry2 == null) continue;
            hashEntryArray2[i2] = null;
            do {
                hashEntry = hashEntry2.nextEntry;
                int n3 = MCHashTable.getSlotIndex(hashEntry2.slotHash, n2);
                hashEntry2.nextEntry = hashEntryArray[n3];
                hashEntryArray[n3] = hashEntry2;
            } while ((hashEntry2 = hashEntry) != null);
        }
    }

    public Object removeObject(int n2) {
        HashEntry hashEntry = this.removeEntry(n2);
        return hashEntry != null ? hashEntry.valueEntry : null;
    }

    final HashEntry removeEntry(int n2) {
        HashEntry hashEntry;
        int n3 = MCHashTable.computeHash(n2);
        int n4 = MCHashTable.getSlotIndex(n3, this.slots.length);
        HashEntry hashEntry2 = hashEntry = this.slots[n4];
        while (hashEntry2 != null) {
            HashEntry hashEntry3 = hashEntry2.nextEntry;
            if (hashEntry2.hashEntry == n2) {
                ++this.versionStamp;
                --this.count;
                if (hashEntry == hashEntry2) {
                    this.slots[n4] = hashEntry3;
                } else {
                    hashEntry.nextEntry = hashEntry3;
                }
                return hashEntry2;
            }
            hashEntry = hashEntry2;
            hashEntry2 = hashEntry3;
        }
        return hashEntry2;
    }

    public void clearMap() {
        ++this.versionStamp;
        HashEntry[] hashEntryArray = this.slots;
        for (int i2 = 0; i2 < hashEntryArray.length; ++i2) {
            hashEntryArray[i2] = null;
        }
        this.count = 0;
    }

    private void insert(int n2, int n3, Object object, int n4) {
        HashEntry hashEntry = this.slots[n4];
        this.slots[n4] = new HashEntry(n2, n3, object, hashEntry);
        if (this.count++ >= this.threshold) {
            this.grow(2 * this.slots.length);
        }
    }

    static int getHash(int n2) {
        return MCHashTable.computeHash(n2);
    }
}

