/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class ScreenShotHelper {
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    private static ByteBuffer buffer;
    private static byte[] pixelData;
    private static int[] imageData;

    public static String saveScreenshot(File file, int n2, int n3) {
        try {
            File file2;
            File file3 = new File(file, "screenshots");
            file3.mkdir();
            if (buffer == null || buffer.capacity() < n2 * n3) {
                buffer = BufferUtils.createByteBuffer((int)(n2 * n3 * 3));
            }
            if (imageData == null || imageData.length < n2 * n3 * 3) {
                pixelData = new byte[n2 * n3 * 3];
                imageData = new int[n2 * n3];
            }
            GL11.glPixelStorei((int)3333, (int)1);
            GL11.glPixelStorei((int)3317, (int)1);
            buffer.clear();
            GL11.glReadPixels((int)0, (int)0, (int)n2, (int)n3, (int)6407, (int)5121, (ByteBuffer)buffer);
            buffer.clear();
            String string = "" + dateFormat.format(new Date());
            int n4 = 1;
            while ((file2 = new File(file3, string + (n4 == 1 ? "" : "_" + n4) + ".png")).exists()) {
                ++n4;
            }
            buffer.get(pixelData);
            for (n4 = 0; n4 < n2; ++n4) {
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n5;
                    int n6 = n4 + (n3 - i2 - 1) * n2;
                    int n7 = pixelData[n6 * 3 + 0] & 0xFF;
                    int n8 = pixelData[n6 * 3 + 1] & 0xFF;
                    int n9 = pixelData[n6 * 3 + 2] & 0xFF;
                    ScreenShotHelper.imageData[n4 + i2 * n2] = n5 = 0xFF000000 | n7 << 16 | n8 << 8 | n9;
                }
            }
            BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
            bufferedImage.setRGB(0, 0, n2, n3, imageData, 0, n2);
            ImageIO.write((RenderedImage)bufferedImage, "png", file2);
            return "Saved screenshot as " + file2.getName();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "Failed to save: " + exception;
        }
    }
}

