/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.networking.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.client.networking.NetHandler;
import net.minecraft.client.networking.packet.Packet;

public class Packet130UpdateSign
extends Packet {
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public String[] signLines;

    public Packet130UpdateSign() {
        this.isChunkDataPacket = true;
    }

    public Packet130UpdateSign(int n2, int n3, int n4, String[] stringArray) {
        this.isChunkDataPacket = true;
        this.xPosition = n2;
        this.yPosition = n3;
        this.zPosition = n4;
        this.signLines = stringArray;
    }

    @Override
    public void readPacketData(DataInputStream dataInputStream) throws IOException {
        this.xPosition = dataInputStream.readInt();
        this.yPosition = dataInputStream.readShort();
        this.zPosition = dataInputStream.readInt();
        this.signLines = new String[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            this.signLines[i2] = Packet130UpdateSign.readString(dataInputStream, 15);
        }
    }

    @Override
    public void writePacketData(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.xPosition);
        dataOutputStream.writeShort(this.yPosition);
        dataOutputStream.writeInt(this.zPosition);
        for (int i2 = 0; i2 < 4; ++i2) {
            Packet130UpdateSign.writeString(this.signLines[i2], dataOutputStream);
        }
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handleSignUpdate(this);
    }

    @Override
    public int getPacketSize() {
        int n2 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            n2 += this.signLines[i2].length();
        }
        return n2;
    }
}

