/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.networking.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.minecraft.client.networking.NetHandler;
import net.minecraft.client.networking.packet.Packet;

public class Packet51MapChunk
extends Packet {
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public int xSize;
    public int ySize;
    public int zSize;
    public byte[] chunk;
    private int chunkSize;

    public Packet51MapChunk() {
        this.isChunkDataPacket = true;
    }

    @Override
    public void readPacketData(DataInputStream dataInputStream) throws IOException {
        this.xPosition = dataInputStream.readInt();
        this.yPosition = dataInputStream.readShort();
        this.zPosition = dataInputStream.readInt();
        this.xSize = dataInputStream.read() + 1;
        this.ySize = dataInputStream.read() + 1;
        this.zSize = dataInputStream.read() + 1;
        this.chunkSize = dataInputStream.readInt();
        byte[] byArray = new byte[this.chunkSize];
        dataInputStream.readFully(byArray);
        this.chunk = new byte[this.xSize * this.ySize * this.zSize * 5 / 2];
        Inflater inflater = new Inflater();
        inflater.setInput(byArray);
        try {
            inflater.inflate(this.chunk);
        }
        catch (DataFormatException dataFormatException) {
            throw new IOException("Bad compressed data format");
        }
        finally {
            inflater.end();
        }
    }

    @Override
    public void writePacketData(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.xPosition);
        dataOutputStream.writeShort(this.yPosition);
        dataOutputStream.writeInt(this.zPosition);
        dataOutputStream.write(this.xSize - 1);
        dataOutputStream.write(this.ySize - 1);
        dataOutputStream.write(this.zSize - 1);
        dataOutputStream.writeInt(this.chunkSize);
        dataOutputStream.write(this.chunk, 0, this.chunkSize);
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handleMapChunk(this);
    }

    @Override
    public int getPacketSize() {
        return 17 + this.chunkSize;
    }
}

