/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.ChatAllowedCharacters;
import net.minecraft.client.c.i;
import net.minecraft.client.c.k;
import net.minecraft.client.c.l;

public class GuiTextField
extends l {
    private final k fontRenderer;
    private final int xPos;
    private final int yPos;
    private final int width;
    private final int height;
    private String text;
    private int maxStringLength;
    private int cursorCounter;
    public boolean isFocused = false;
    public boolean isEnabled = true;
    private i parentGuiScreen;

    public GuiTextField(i i2, k k2, int n2, int n3, int n4, int n5, String string) {
        this.parentGuiScreen = i2;
        this.fontRenderer = k2;
        this.xPos = n2;
        this.yPos = n3;
        this.width = n4;
        this.height = n5;
        this.setText(string);
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getText() {
        return this.text;
    }

    public void updateCursorCounter() {
        ++this.cursorCounter;
    }

    public void textboxKeyTyped(char c2, int n2) {
        if (this.isEnabled && this.isFocused) {
            if (c2 == '\t') {
                this.parentGuiScreen.selectNextField();
            }
            if (c2 == '\u0016') {
                int n3;
                String string = net.minecraft.client.c.i.getClipboardString();
                if (string == null) {
                    string = "";
                }
                if ((n3 = 32 - this.text.length()) > string.length()) {
                    n3 = string.length();
                }
                if (n3 > 0) {
                    this.text = this.text + string.substring(0, n3);
                }
            }
            if (n2 == 14 && this.text.length() > 0) {
                this.text = this.text.substring(0, this.text.length() - 1);
            }
            if (ChatAllowedCharacters.allowedCharacters.indexOf(c2) >= 0 && (this.text.length() < this.maxStringLength || this.maxStringLength == 0)) {
                this.text = this.text + c2;
            }
        }
    }

    public void mouseClicked(int n2, int n3, int n4) {
        boolean bl = this.isEnabled && n2 >= this.xPos && n2 < this.xPos + this.width && n3 >= this.yPos && n3 < this.yPos + this.height;
        this.setFocused(bl);
    }

    public void setFocused(boolean bl) {
        if (bl && !this.isFocused) {
            this.cursorCounter = 0;
        }
        this.isFocused = bl;
    }

    public void drawTextBox() {
        this.drawRect(this.xPos - 1, this.yPos - 1, this.xPos + this.width + 1, this.yPos + this.height + 1, -6250336);
        this.drawRect(this.xPos, this.yPos, this.xPos + this.width, this.yPos + this.height, -16777216);
        if (this.isEnabled) {
            boolean bl = this.isFocused && this.cursorCounter / 6 % 2 == 0;
            GuiTextField.b(this.fontRenderer, this.text + (bl ? "_" : ""), this.xPos + 4, this.yPos + (this.height - 8) / 2, 0xE0E0E0);
        } else {
            GuiTextField.b(this.fontRenderer, this.text, this.xPos + 4, this.yPos + (this.height - 8) / 2, 0x707070);
        }
    }

    public void setMaxStringLength(int n2) {
        this.maxStringLength = n2;
    }
}

