/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.networking;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Random;
import net.minecraft.a.a.b.aa;
import net.minecraft.a.b.o;
import net.minecraft.a.c.b;
import net.minecraft.a.c.c.c;
import net.minecraft.a.c.d.a;
import net.minecraft.a.c.f;
import net.minecraft.client.Explosion;
import net.minecraft.client.c.i;
import net.minecraft.client.controller.PlayerControllerSurvivalMP;
import net.minecraft.client.d;
import net.minecraft.client.f.e;
import net.minecraft.client.gui.GuiConnectFailed;
import net.minecraft.client.gui.GuiDownloadTerrain;
import net.minecraft.client.networking.NetHandler;
import net.minecraft.client.networking.NetworkManager;
import net.minecraft.client.networking.packet.Packet;
import net.minecraft.client.networking.packet.Packet0KeepAlive;
import net.minecraft.client.networking.packet.Packet100OpenWindow;
import net.minecraft.client.networking.packet.Packet101CloseWindow;
import net.minecraft.client.networking.packet.Packet103SetSlot;
import net.minecraft.client.networking.packet.Packet104WindowItems;
import net.minecraft.client.networking.packet.Packet105UpdateProgressbar;
import net.minecraft.client.networking.packet.Packet106Transaction;
import net.minecraft.client.networking.packet.Packet10Flying;
import net.minecraft.client.networking.packet.Packet130UpdateSign;
import net.minecraft.client.networking.packet.Packet18Animation;
import net.minecraft.client.networking.packet.Packet1Login;
import net.minecraft.client.networking.packet.Packet20NamedEntitySpawn;
import net.minecraft.client.networking.packet.Packet21PickupSpawn;
import net.minecraft.client.networking.packet.Packet22Collect;
import net.minecraft.client.networking.packet.Packet23VehicleSpawn;
import net.minecraft.client.networking.packet.Packet24MobSpawn;
import net.minecraft.client.networking.packet.Packet255KickDisconnect;
import net.minecraft.client.networking.packet.Packet25EntityPainting;
import net.minecraft.client.networking.packet.Packet28EntityVelocity;
import net.minecraft.client.networking.packet.Packet29DestroyEntity;
import net.minecraft.client.networking.packet.Packet2Handshake;
import net.minecraft.client.networking.packet.Packet30Entity;
import net.minecraft.client.networking.packet.Packet34EntityTeleport;
import net.minecraft.client.networking.packet.Packet38EntityStatus;
import net.minecraft.client.networking.packet.Packet3Chat;
import net.minecraft.client.networking.packet.Packet40EntityMetadata;
import net.minecraft.client.networking.packet.Packet4UpdateTime;
import net.minecraft.client.networking.packet.Packet50PreChunk;
import net.minecraft.client.networking.packet.Packet51MapChunk;
import net.minecraft.client.networking.packet.Packet52MultiBlockChange;
import net.minecraft.client.networking.packet.Packet53BlockChange;
import net.minecraft.client.networking.packet.Packet5PlayerInventory;
import net.minecraft.client.networking.packet.Packet60Explosion;
import net.minecraft.client.networking.packet.Packet61DoorChange;
import net.minecraft.client.networking.packet.Packet6SpawnPosition;
import net.minecraft.client.networking.packet.Packet8UpdateHealth;
import net.minecraft.client.networking.packet.Packet9Respawn;
import net.minecraft.game.Container;
import net.minecraft.game.InventoryBasic;
import net.minecraft.game.entity.player.EntityOtherPlayerMP;
import net.minecraft.game.world.WorldClient;

public class NetClientHandler
extends NetHandler {
    private boolean disconnected = false;
    private NetworkManager netManager;
    public String field_1209_a;
    private d mc;
    private WorldClient worldClient;
    private boolean field_1210_g = false;
    protected Random rand = new Random();

    public NetClientHandler(d d2, String string, int n2) throws UnknownHostException, IOException {
        this.mc = d2;
        Socket socket = new Socket(InetAddress.getByName(string), n2);
        this.netManager = new NetworkManager(socket, "Client", this);
    }

    public void processReadPackets() {
        if (!this.disconnected) {
            this.netManager.processReadPackets();
        }
        this.netManager.wakeThreads();
    }

    @Override
    public void handleLogin(Packet1Login packet1Login) {
        this.mc.a = new PlayerControllerSurvivalMP(this.mc, this);
        this.worldClient = new WorldClient(this);
        this.worldClient.multiplayerWorld = true;
        this.mc.a(this.worldClient);
        this.mc.a(new GuiDownloadTerrain(this));
        this.mc.f.entityId = packet1Login.protocolVersion;
    }

    @Override
    public void handlePickupSpawn(Packet21PickupSpawn packet21PickupSpawn) {
        double d2 = (double)packet21PickupSpawn.xPosition / 32.0;
        double d3 = (double)packet21PickupSpawn.yPosition / 32.0;
        double d4 = (double)packet21PickupSpawn.zPosition / 32.0;
        net.minecraft.a.c.c.b b2 = new net.minecraft.a.c.c.b(this.worldClient, d2, d3, d4, new o(packet21PickupSpawn.itemID, packet21PickupSpawn.count, packet21PickupSpawn.itemDamage));
        b2.k = (double)packet21PickupSpawn.rotation / 128.0;
        b2.l = (double)packet21PickupSpawn.pitch / 128.0;
        b2.m = (double)packet21PickupSpawn.roll / 128.0;
        b2.serverPosX = packet21PickupSpawn.xPosition;
        b2.serverPosY = packet21PickupSpawn.yPosition;
        b2.serverPosZ = packet21PickupSpawn.zPosition;
        this.worldClient.func_712_a(packet21PickupSpawn.entityId, b2);
    }

    @Override
    public void handleVehicleSpawn(Packet23VehicleSpawn packet23VehicleSpawn) {
        double d2 = (double)packet23VehicleSpawn.xPosition / 32.0;
        double d3 = (double)packet23VehicleSpawn.yPosition / 32.0;
        double d4 = (double)packet23VehicleSpawn.zPosition / 32.0;
        b b2 = null;
        if (packet23VehicleSpawn.type == 10) {
            b2 = new net.minecraft.a.c.c.d(this.worldClient, d2, d3, d4);
        }
        if (packet23VehicleSpawn.type == 60) {
            b2 = new a(this.worldClient, d2, d3, d4);
        }
        if (packet23VehicleSpawn.type == 50) {
            b2 = new net.minecraft.a.c.c.a(this.worldClient, d2, d3, d4);
        }
        if (packet23VehicleSpawn.type == 70) {
            b2 = new c(this.worldClient, d2, d3, d4, aa.r.at);
        }
        if (packet23VehicleSpawn.type == 71) {
            b2 = new c(this.worldClient, d2, d3, d4, aa.s.at);
        }
        if (b2 != null) {
            ((b)b2).serverPosX = packet23VehicleSpawn.xPosition;
            ((b)b2).serverPosY = packet23VehicleSpawn.yPosition;
            ((b)b2).serverPosZ = packet23VehicleSpawn.zPosition;
            ((b)b2).n = 0.0f;
            ((b)b2).o = 0.0f;
            ((b)b2).entityId = packet23VehicleSpawn.entityId;
            this.worldClient.func_712_a(packet23VehicleSpawn.entityId, b2);
            if (packet23VehicleSpawn.field_28044_i > 0) {
                b b3;
                if (packet23VehicleSpawn.type == 60 && (b3 = this.getEntityByID(packet23VehicleSpawn.field_28044_i)) instanceof f) {
                    ((a)b2).U = (f)b3;
                }
                ((b)b2).setVelocity((double)packet23VehicleSpawn.field_28047_e / 8000.0, (double)packet23VehicleSpawn.field_28046_f / 8000.0, (double)packet23VehicleSpawn.field_28045_g / 8000.0);
            }
        }
    }

    @Override
    public void func_21146_a(Packet25EntityPainting packet25EntityPainting) {
        net.minecraft.a.c.a a2 = new net.minecraft.a.c.a(this.worldClient, packet25EntityPainting.xPosition, packet25EntityPainting.yPosition, packet25EntityPainting.zPosition, packet25EntityPainting.direction, packet25EntityPainting.title);
        this.worldClient.func_712_a(packet25EntityPainting.entityId, a2);
    }

    @Override
    public void func_6498_a(Packet28EntityVelocity packet28EntityVelocity) {
        b b2 = this.getEntityByID(packet28EntityVelocity.entityId);
        if (b2 != null) {
            b2.setVelocity((double)packet28EntityVelocity.motionX / 8000.0, (double)packet28EntityVelocity.motionY / 8000.0, (double)packet28EntityVelocity.motionZ / 8000.0);
        }
    }

    @Override
    public void func_21148_a(Packet40EntityMetadata packet40EntityMetadata) {
        b b2 = this.getEntityByID(packet40EntityMetadata.entityId);
        if (b2 != null && packet40EntityMetadata.func_21047_b() != null) {
            b2.getDataWatcher().updateWatchedObjectsFromList(packet40EntityMetadata.func_21047_b());
        }
    }

    @Override
    public void handleNamedEntitySpawn(Packet20NamedEntitySpawn packet20NamedEntitySpawn) {
        double d2 = (double)packet20NamedEntitySpawn.xPosition / 32.0;
        double d3 = (double)packet20NamedEntitySpawn.yPosition / 32.0;
        double d4 = (double)packet20NamedEntitySpawn.zPosition / 32.0;
        float f2 = (float)(packet20NamedEntitySpawn.rotation * 360) / 256.0f;
        float f3 = (float)(packet20NamedEntitySpawn.pitch * 360) / 256.0f;
        EntityOtherPlayerMP entityOtherPlayerMP = new EntityOtherPlayerMP(this.mc.d, packet20NamedEntitySpawn.name);
        entityOtherPlayerMP.serverPosX = packet20NamedEntitySpawn.xPosition;
        entityOtherPlayerMP.e = entityOtherPlayerMP.C = (double)entityOtherPlayerMP.serverPosX;
        entityOtherPlayerMP.serverPosY = packet20NamedEntitySpawn.yPosition;
        entityOtherPlayerMP.f = entityOtherPlayerMP.D = (double)entityOtherPlayerMP.serverPosY;
        entityOtherPlayerMP.serverPosZ = packet20NamedEntitySpawn.zPosition;
        entityOtherPlayerMP.g = entityOtherPlayerMP.E = (double)entityOtherPlayerMP.serverPosZ;
        int n2 = packet20NamedEntitySpawn.currentItem;
        entityOtherPlayerMP.b.a[entityOtherPlayerMP.b.c] = n2 == 0 ? null : new o(n2, 1, 0);
        entityOtherPlayerMP.setPositionAndRotation(d2, d3, d4, f2, f3);
        this.worldClient.func_712_a(packet20NamedEntitySpawn.entityId, entityOtherPlayerMP);
    }

    @Override
    public void handleEntityTeleport(Packet34EntityTeleport packet34EntityTeleport) {
        b b2 = this.getEntityByID(packet34EntityTeleport.entityId);
        if (b2 != null) {
            b2.serverPosX = packet34EntityTeleport.xPosition;
            b2.serverPosY = packet34EntityTeleport.yPosition;
            b2.serverPosZ = packet34EntityTeleport.zPosition;
            double d2 = (double)b2.serverPosX / 32.0;
            double d3 = (double)b2.serverPosY / 32.0 + 0.015625;
            double d4 = (double)b2.serverPosZ / 32.0;
            float f2 = (float)(packet34EntityTeleport.yaw * 360) / 256.0f;
            float f3 = (float)(packet34EntityTeleport.pitch * 360) / 256.0f;
            b2.setPositionAndRotation2(d2, d3, d4, f2, f3, 3);
        }
    }

    @Override
    public void handleEntity(Packet30Entity packet30Entity) {
        b b2 = this.getEntityByID(packet30Entity.entityId);
        if (b2 != null) {
            b2.serverPosX += packet30Entity.xPosition;
            b2.serverPosY += packet30Entity.yPosition;
            b2.serverPosZ += packet30Entity.zPosition;
            double d2 = (double)b2.serverPosX / 32.0;
            double d3 = (double)b2.serverPosY / 32.0;
            double d4 = (double)b2.serverPosZ / 32.0;
            float f2 = packet30Entity.rotating ? (float)(packet30Entity.yaw * 360) / 256.0f : b2.n;
            float f3 = packet30Entity.rotating ? (float)(packet30Entity.pitch * 360) / 256.0f : b2.o;
            b2.setPositionAndRotation2(d2, d3, d4, f2, f3, 3);
        }
    }

    @Override
    public void handleDestroyEntity(Packet29DestroyEntity packet29DestroyEntity) {
        this.worldClient.removeEntityFromWorld(packet29DestroyEntity.entityId);
    }

    @Override
    public void handleFlying(Packet10Flying packet10Flying) {
        net.minecraft.client.g.a a2 = this.mc.f;
        double d2 = a2.h;
        double d3 = a2.i;
        double d4 = a2.j;
        float f2 = a2.n;
        float f3 = a2.o;
        if (packet10Flying.moving) {
            d2 = packet10Flying.xPosition;
            d3 = packet10Flying.yPosition;
            d4 = packet10Flying.zPosition;
        }
        if (packet10Flying.rotating) {
            f2 = packet10Flying.yaw;
            f3 = packet10Flying.pitch;
        }
        a2.Q = 0.0f;
        a2.m = 0.0;
        a2.l = 0.0;
        a2.k = 0.0;
        a2.setPositionAndRotation(d2, d3, d4, f2, f3);
        packet10Flying.xPosition = a2.h;
        packet10Flying.yPosition = a2.r.b;
        packet10Flying.zPosition = a2.j;
        packet10Flying.stance = a2.i;
        this.netManager.addToSendQueue(packet10Flying);
        if (!this.field_1210_g) {
            this.mc.f.e = this.mc.f.h;
            this.mc.f.f = this.mc.f.i;
            this.mc.f.g = this.mc.f.j;
            this.field_1210_g = true;
            this.mc.a((i)null);
        }
    }

    @Override
    public void handlePreChunk(Packet50PreChunk packet50PreChunk) {
        this.worldClient.doPreChunk(packet50PreChunk.xPosition, packet50PreChunk.yPosition, packet50PreChunk.mode);
    }

    @Override
    public void handleMultiBlockChange(Packet52MultiBlockChange packet52MultiBlockChange) {
        net.minecraft.a.a.e.e e2 = this.worldClient.a(packet52MultiBlockChange.xPosition, packet52MultiBlockChange.zPosition);
        int n2 = packet52MultiBlockChange.xPosition * 16;
        int n3 = packet52MultiBlockChange.zPosition * 16;
        for (int i2 = 0; i2 < packet52MultiBlockChange.size; ++i2) {
            short s2 = packet52MultiBlockChange.coordinateArray[i2];
            int n4 = packet52MultiBlockChange.typeArray[i2] & 0xFF;
            byte by = packet52MultiBlockChange.metadataArray[i2];
            int n5 = s2 >> 12 & 0xF;
            int n6 = s2 >> 8 & 0xF;
            int n7 = s2 & 0xFF;
            e2.a(n5, n7, n6, n4, (int)by);
            this.worldClient.func_711_c(n5 + n2, n7, n6 + n3, n5 + n2, n7, n6 + n3);
            this.worldClient.a(n5 + n2, n7, n6 + n3, n5 + n2, n7, n6 + n3);
        }
    }

    @Override
    public void handleMapChunk(Packet51MapChunk packet51MapChunk) {
        this.worldClient.func_711_c(packet51MapChunk.xPosition, packet51MapChunk.yPosition, packet51MapChunk.zPosition, packet51MapChunk.xPosition + packet51MapChunk.xSize - 1, packet51MapChunk.yPosition + packet51MapChunk.ySize - 1, packet51MapChunk.zPosition + packet51MapChunk.zSize - 1);
        this.worldClient.setChunkData(packet51MapChunk.xPosition, packet51MapChunk.yPosition, packet51MapChunk.zPosition, packet51MapChunk.xSize, packet51MapChunk.ySize, packet51MapChunk.zSize, packet51MapChunk.chunk);
    }

    @Override
    public void handleBlockChange(Packet53BlockChange packet53BlockChange) {
        this.worldClient.func_714_c(packet53BlockChange.xPosition, packet53BlockChange.yPosition, packet53BlockChange.zPosition, packet53BlockChange.type, packet53BlockChange.metadata);
    }

    @Override
    public void handleKickDisconnect(Packet255KickDisconnect packet255KickDisconnect) {
        this.netManager.networkShutdown("Was kicked from the game", new Object[0]);
        this.disconnected = true;
        this.mc.closeWorld();
        this.mc.a(new GuiConnectFailed("Disconnected by Server", "%s", packet255KickDisconnect.reason));
    }

    @Override
    public void handleErrorMessage(String string, Object[] objectArray) {
        if (!this.disconnected) {
            this.disconnected = true;
            this.mc.closeWorld();
            this.mc.a(new GuiConnectFailed("Connection lost", string, objectArray));
        }
    }

    public void func_28117_a(Packet packet) {
        if (!this.disconnected) {
            this.netManager.addToSendQueue(packet);
            this.netManager.func_28142_c();
        }
    }

    public void addToSendQueue(Packet packet) {
        if (!this.disconnected) {
            this.netManager.addToSendQueue(packet);
        }
    }

    @Override
    public void handleCollect(Packet22Collect packet22Collect) {
        b b2 = this.getEntityByID(packet22Collect.collectedEntityId);
        f f2 = (f)this.getEntityByID(packet22Collect.collectorEntityId);
        if (f2 == null) {
            f2 = this.mc.f;
        }
        if (b2 != null) {
            this.worldClient.a(b2, "random.pop", 0.2f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            this.mc.g.a(new e(this.mc.d, b2, f2, -0.5f));
            this.worldClient.removeEntityFromWorld(packet22Collect.collectedEntityId);
        }
    }

    @Override
    public void handleChat(Packet3Chat packet3Chat) {
        this.mc.r.addChatMessage(packet3Chat.message);
    }

    @Override
    public void handleArmAnimation(Packet18Animation packet18Animation) {
        b b2 = this.getEntityByID(packet18Animation.entityId);
        if (b2 != null) {
            if (packet18Animation.animate == 1) {
                net.minecraft.a.c.e.a a2 = (net.minecraft.a.c.e.a)b2;
                a2.swingItem();
            } else if (packet18Animation.animate == 2) {
                b2.performHurtAnimation();
            }
        }
    }

    @Override
    public void handleHandshake(Packet2Handshake packet2Handshake) {
        if (packet2Handshake.username.equals("-")) {
            this.addToSendQueue(new Packet1Login(this.mc.h.b, 61806));
        } else {
            try {
                URL uRL = new URL("http://session.minecraft.net/game/joinserver.jsp?user=" + this.mc.h.b + "&sessionId=" + this.mc.h.sessionId + "&serverId=" + packet2Handshake.username);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                String string = bufferedReader.readLine();
                bufferedReader.close();
                if (string.equalsIgnoreCase("ok")) {
                    this.addToSendQueue(new Packet1Login(this.mc.h.b, 61806));
                } else {
                    this.netManager.networkShutdown("Failed to login: %s", string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.netManager.networkShutdown("%s", "Internal client error: " + exception.toString());
            }
        }
    }

    public void disconnect() {
        this.disconnected = true;
        this.netManager.wakeThreads();
        this.netManager.networkShutdown("Connection closed", new Object[0]);
    }

    @Override
    public void handleMobSpawn(Packet24MobSpawn packet24MobSpawn) {
        double d2 = (double)packet24MobSpawn.xPosition / 32.0;
        double d3 = (double)packet24MobSpawn.yPosition / 32.0;
        double d4 = (double)packet24MobSpawn.zPosition / 32.0;
        float f2 = (float)(packet24MobSpawn.yaw * 360) / 256.0f;
        float f3 = (float)(packet24MobSpawn.pitch * 360) / 256.0f;
        f f4 = (f)net.minecraft.a.c.e.createEntity(packet24MobSpawn.type, this.mc.d);
        f4.serverPosX = packet24MobSpawn.xPosition;
        f4.serverPosY = packet24MobSpawn.yPosition;
        f4.serverPosZ = packet24MobSpawn.zPosition;
        f4.entityId = packet24MobSpawn.entityId;
        f4.setPositionAndRotation(d2, d3, d4, f2, f3);
        f4.isMultiplayerEntity = true;
        this.worldClient.func_712_a(packet24MobSpawn.entityId, f4);
        List list = packet24MobSpawn.getMetadata();
        if (list != null) {
            f4.getDataWatcher().updateWatchedObjectsFromList(list);
        }
    }

    @Override
    public void handleUpdateTime(Packet4UpdateTime packet4UpdateTime) {
        this.mc.d.b = packet4UpdateTime.time;
    }

    @Override
    public void handleSpawnPosition(Packet6SpawnPosition packet6SpawnPosition) {
        this.worldClient.i = packet6SpawnPosition.xPosition;
        this.worldClient.j = packet6SpawnPosition.yPosition;
        this.worldClient.k = packet6SpawnPosition.zPosition;
    }

    @Override
    public void func_9447_a(Packet38EntityStatus packet38EntityStatus) {
        b b2 = this.getEntityByID(packet38EntityStatus.entityId);
        if (b2 != null) {
            b2.handleHealthUpdate(packet38EntityStatus.entityStatus);
        }
    }

    private b getEntityByID(int n2) {
        return n2 == this.mc.f.entityId ? this.mc.f : this.worldClient.func_709_b(n2);
    }

    @Override
    public void handleHealth(Packet8UpdateHealth packet8UpdateHealth) {
        this.mc.f.setHealth(packet8UpdateHealth.healthMP);
    }

    @Override
    public void func_9448_a(Packet9Respawn packet9Respawn) {
        this.mc.j();
    }

    @Override
    public void func_12245_a(Packet60Explosion packet60Explosion) {
        Explosion explosion = new Explosion(this.mc.d, null, packet60Explosion.explosionX, packet60Explosion.explosionY, packet60Explosion.explosionZ, packet60Explosion.explosionSize);
        explosion.destroyedBlockPositions = packet60Explosion.destroyedBlockPositions;
        explosion.doExplosionB(true);
    }

    @Override
    public void func_20087_a(Packet100OpenWindow packet100OpenWindow) {
        if (packet100OpenWindow.inventoryType == 0) {
            InventoryBasic inventoryBasic = new InventoryBasic(packet100OpenWindow.windowTitle, packet100OpenWindow.slotsCount);
            this.mc.f.a(inventoryBasic);
            this.mc.f.craftingInventory.windowId = packet100OpenWindow.windowId;
        } else if (packet100OpenWindow.inventoryType == 2) {
            net.minecraft.a.a.b.a.b b2 = new net.minecraft.a.a.b.a.b();
            this.mc.f.a(b2);
            this.mc.f.craftingInventory.windowId = packet100OpenWindow.windowId;
        } else if (packet100OpenWindow.inventoryType == 1) {
            net.minecraft.client.g.a a2 = this.mc.f;
            this.mc.f.openWorkbenchGUI(a.a.b(a2.h), a.a.b(a2.i), a.a.b(a2.j));
            this.mc.f.craftingInventory.windowId = packet100OpenWindow.windowId;
        }
    }

    @Override
    public void func_20088_a(Packet103SetSlot packet103SetSlot) {
        if (packet103SetSlot.windowId == -1) {
            this.mc.f.b.setItemStack(packet103SetSlot.myItemStack);
        } else if (packet103SetSlot.windowId == 0 && packet103SetSlot.itemSlot >= 36 && packet103SetSlot.itemSlot < 45) {
            o o2 = this.mc.f.inventorySlots.getSlot(packet103SetSlot.itemSlot).getStack();
            if (packet103SetSlot.myItemStack != null && (o2 == null || o2.a < packet103SetSlot.myItemStack.a)) {
                packet103SetSlot.myItemStack.b = 5;
            }
            this.mc.f.inventorySlots.putStackInSlot(packet103SetSlot.itemSlot, packet103SetSlot.myItemStack);
        } else if (packet103SetSlot.windowId == this.mc.f.craftingInventory.windowId) {
            this.mc.f.craftingInventory.putStackInSlot(packet103SetSlot.itemSlot, packet103SetSlot.myItemStack);
        }
    }

    @Override
    public void func_20089_a(Packet106Transaction packet106Transaction) {
        Container container = null;
        if (packet106Transaction.windowId == 0) {
            container = this.mc.f.inventorySlots;
        } else if (packet106Transaction.windowId == this.mc.f.craftingInventory.windowId) {
            container = this.mc.f.craftingInventory;
        }
        if (container != null) {
            if (packet106Transaction.field_20030_c) {
                container.func_20113_a(packet106Transaction.field_20028_b);
            } else {
                container.func_20110_b(packet106Transaction.field_20028_b);
                this.addToSendQueue(new Packet106Transaction(packet106Transaction.windowId, packet106Transaction.field_20028_b, true));
            }
        }
    }

    @Override
    public void func_20094_a(Packet104WindowItems packet104WindowItems) {
        if (packet104WindowItems.windowId == 0) {
            this.mc.f.inventorySlots.putStacksInSlots(packet104WindowItems.itemStack);
        } else if (packet104WindowItems.windowId == this.mc.f.craftingInventory.windowId) {
            this.mc.f.craftingInventory.putStacksInSlots(packet104WindowItems.itemStack);
        }
    }

    @Override
    public void handleSignUpdate(Packet130UpdateSign packet130UpdateSign) {
        net.minecraft.a.a.b.a.a a2;
        if (this.mc.d.blockExists(packet130UpdateSign.xPosition, packet130UpdateSign.yPosition, packet130UpdateSign.zPosition) && (a2 = this.mc.d.i(packet130UpdateSign.xPosition, packet130UpdateSign.yPosition, packet130UpdateSign.zPosition)) instanceof net.minecraft.a.a.b.a.d) {
            net.minecraft.a.a.b.a.d d2 = (net.minecraft.a.a.b.a.d)a2;
            for (int i2 = 0; i2 < 4; ++i2) {
                d2.e[i2] = packet130UpdateSign.signLines[i2];
            }
            d2.d();
        }
    }

    @Override
    public void func_20090_a(Packet105UpdateProgressbar packet105UpdateProgressbar) {
        this.registerPacket(packet105UpdateProgressbar);
        if (this.mc.f.craftingInventory != null && this.mc.f.craftingInventory.windowId == packet105UpdateProgressbar.windowId) {
            this.mc.f.craftingInventory.func_20112_a(packet105UpdateProgressbar.progressBar, packet105UpdateProgressbar.progressBarValue);
        }
    }

    @Override
    public void handlePlayerInventory(Packet5PlayerInventory packet5PlayerInventory) {
        b b2 = this.getEntityByID(packet5PlayerInventory.entityID);
        if (b2 != null) {
            b2.outfitWithItem(packet5PlayerInventory.slot, packet5PlayerInventory.itemID, packet5PlayerInventory.itemDamage);
        }
    }

    @Override
    public void func_20092_a(Packet101CloseWindow packet101CloseWindow) {
        this.mc.f.closeScreen();
    }

    @Override
    public void func_28115_a(Packet61DoorChange packet61DoorChange) {
        this.mc.d.func_28106_e(packet61DoorChange.field_28050_a, packet61DoorChange.field_28053_c, packet61DoorChange.field_28052_d, packet61DoorChange.field_28051_e, packet61DoorChange.field_28049_b);
    }

    @Override
    public void handleKeepAlive(Packet0KeepAlive packet0KeepAlive) {
        this.addToSendQueue(new Packet0KeepAlive(packet0KeepAlive.randomId));
    }

    @Override
    public boolean isServerHandler() {
        return false;
    }
}

