/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.networking.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.networking.NetHandler;
import net.minecraft.client.networking.packet.Packet0KeepAlive;
import net.minecraft.client.networking.packet.Packet100OpenWindow;
import net.minecraft.client.networking.packet.Packet101CloseWindow;
import net.minecraft.client.networking.packet.Packet102WindowClick;
import net.minecraft.client.networking.packet.Packet103SetSlot;
import net.minecraft.client.networking.packet.Packet104WindowItems;
import net.minecraft.client.networking.packet.Packet105UpdateProgressbar;
import net.minecraft.client.networking.packet.Packet106Transaction;
import net.minecraft.client.networking.packet.Packet10Flying;
import net.minecraft.client.networking.packet.Packet11PlayerPosition;
import net.minecraft.client.networking.packet.Packet12PlayerLook;
import net.minecraft.client.networking.packet.Packet130UpdateSign;
import net.minecraft.client.networking.packet.Packet13PlayerLookMove;
import net.minecraft.client.networking.packet.Packet14BlockDig;
import net.minecraft.client.networking.packet.Packet15Place;
import net.minecraft.client.networking.packet.Packet16BlockItemSwitch;
import net.minecraft.client.networking.packet.Packet18Animation;
import net.minecraft.client.networking.packet.Packet1Login;
import net.minecraft.client.networking.packet.Packet20NamedEntitySpawn;
import net.minecraft.client.networking.packet.Packet21PickupSpawn;
import net.minecraft.client.networking.packet.Packet22Collect;
import net.minecraft.client.networking.packet.Packet23VehicleSpawn;
import net.minecraft.client.networking.packet.Packet24MobSpawn;
import net.minecraft.client.networking.packet.Packet255KickDisconnect;
import net.minecraft.client.networking.packet.Packet25EntityPainting;
import net.minecraft.client.networking.packet.Packet27Position;
import net.minecraft.client.networking.packet.Packet28EntityVelocity;
import net.minecraft.client.networking.packet.Packet29DestroyEntity;
import net.minecraft.client.networking.packet.Packet2Handshake;
import net.minecraft.client.networking.packet.Packet30Entity;
import net.minecraft.client.networking.packet.Packet31RelEntityMove;
import net.minecraft.client.networking.packet.Packet32EntityLook;
import net.minecraft.client.networking.packet.Packet33RelEntityMoveLook;
import net.minecraft.client.networking.packet.Packet34EntityTeleport;
import net.minecraft.client.networking.packet.Packet38EntityStatus;
import net.minecraft.client.networking.packet.Packet3Chat;
import net.minecraft.client.networking.packet.Packet40EntityMetadata;
import net.minecraft.client.networking.packet.Packet4UpdateTime;
import net.minecraft.client.networking.packet.Packet50PreChunk;
import net.minecraft.client.networking.packet.Packet51MapChunk;
import net.minecraft.client.networking.packet.Packet52MultiBlockChange;
import net.minecraft.client.networking.packet.Packet53BlockChange;
import net.minecraft.client.networking.packet.Packet5PlayerInventory;
import net.minecraft.client.networking.packet.Packet60Explosion;
import net.minecraft.client.networking.packet.Packet61DoorChange;
import net.minecraft.client.networking.packet.Packet6SpawnPosition;
import net.minecraft.client.networking.packet.Packet7UseEntity;
import net.minecraft.client.networking.packet.Packet8UpdateHealth;
import net.minecraft.client.networking.packet.Packet9Respawn;
import net.minecraft.client.networking.packet.PacketCounter;

public abstract class Packet {
    private static Map packetIdToClassMap = new HashMap();
    private static Map packetClassToIdMap = new HashMap();
    private static Set clientPacketIdList = new HashSet();
    private static Set serverPacketIdList = new HashSet();
    public final long creationTimeMillis = System.currentTimeMillis();
    public boolean isChunkDataPacket = false;
    private static HashMap packetStats;
    private static int totalPacketsCount;

    static void addIdClassMapping(int n2, boolean bl, boolean bl2, Class clazz) {
        if (packetIdToClassMap.containsKey(n2)) {
            throw new IllegalArgumentException("Duplicate packet id:" + n2);
        }
        if (packetClassToIdMap.containsKey(clazz)) {
            throw new IllegalArgumentException("Duplicate packet class:" + clazz);
        }
        packetIdToClassMap.put(n2, clazz);
        packetClassToIdMap.put(clazz, n2);
        if (bl) {
            clientPacketIdList.add(n2);
        }
        if (bl2) {
            serverPacketIdList.add(n2);
        }
    }

    public static Packet getNewPacket(int n2) {
        try {
            Class clazz = (Class)packetIdToClassMap.get(n2);
            return clazz == null ? null : (Packet)clazz.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Skipping packet with id " + n2);
            return null;
        }
    }

    public final int getPacketId() {
        return (Integer)packetClassToIdMap.get(this.getClass());
    }

    public static Packet readPacket(DataInputStream dataInputStream, boolean bl) throws IOException {
        int n2;
        boolean bl2 = false;
        Packet packet = null;
        try {
            n2 = dataInputStream.read();
            if (n2 == -1) {
                return null;
            }
            if (bl && !serverPacketIdList.contains(n2) || !bl && !clientPacketIdList.contains(n2)) {
                throw new IOException("Bad packet id " + n2);
            }
            packet = Packet.getNewPacket(n2);
            if (packet == null) {
                throw new IOException("Bad packet id " + n2);
            }
            packet.readPacketData(dataInputStream);
        }
        catch (EOFException eOFException) {
            System.out.println("Reached end of stream");
            return null;
        }
        PacketCounter packetCounter = (PacketCounter)packetStats.get(n2);
        if (packetCounter == null) {
            packetCounter = new PacketCounter();
            packetStats.put(n2, packetCounter);
        }
        packetCounter.addPacket(packet.getPacketSize());
        if (++totalPacketsCount % 1000 == 0) {
            // empty if block
        }
        return packet;
    }

    public static void writePacket(Packet packet, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(packet.getPacketId());
        packet.writePacketData(dataOutputStream);
    }

    public static void writeString(String string, DataOutputStream dataOutputStream) throws IOException {
        if (string.length() > Short.MAX_VALUE) {
            throw new IOException("String too big");
        }
        dataOutputStream.writeShort(string.length());
        dataOutputStream.writeChars(string);
    }

    public static String readString(DataInputStream dataInputStream, int n2) throws IOException {
        int n3 = dataInputStream.readShort();
        if (n3 > n2) {
            throw new IOException("Received string length longer than maximum allowed (" + n3 + " > " + n2 + ")");
        }
        if (n3 < 0) {
            throw new IOException("Received string length is less than zero! Weird string!");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n3; ++i2) {
            stringBuilder.append(dataInputStream.readChar());
        }
        return stringBuilder.toString();
    }

    public abstract void readPacketData(DataInputStream var1) throws IOException;

    public abstract void writePacketData(DataOutputStream var1) throws IOException;

    public abstract void processPacket(NetHandler var1);

    public abstract int getPacketSize();

    static {
        Packet.addIdClassMapping(0, true, true, Packet0KeepAlive.class);
        Packet.addIdClassMapping(1, true, true, Packet1Login.class);
        Packet.addIdClassMapping(2, true, true, Packet2Handshake.class);
        Packet.addIdClassMapping(3, true, true, Packet3Chat.class);
        Packet.addIdClassMapping(4, true, false, Packet4UpdateTime.class);
        Packet.addIdClassMapping(5, true, false, Packet5PlayerInventory.class);
        Packet.addIdClassMapping(6, true, false, Packet6SpawnPosition.class);
        Packet.addIdClassMapping(7, false, true, Packet7UseEntity.class);
        Packet.addIdClassMapping(8, true, false, Packet8UpdateHealth.class);
        Packet.addIdClassMapping(9, true, true, Packet9Respawn.class);
        Packet.addIdClassMapping(10, true, true, Packet10Flying.class);
        Packet.addIdClassMapping(11, true, true, Packet11PlayerPosition.class);
        Packet.addIdClassMapping(12, true, true, Packet12PlayerLook.class);
        Packet.addIdClassMapping(13, true, true, Packet13PlayerLookMove.class);
        Packet.addIdClassMapping(14, false, true, Packet14BlockDig.class);
        Packet.addIdClassMapping(15, false, true, Packet15Place.class);
        Packet.addIdClassMapping(16, false, true, Packet16BlockItemSwitch.class);
        Packet.addIdClassMapping(18, true, true, Packet18Animation.class);
        Packet.addIdClassMapping(20, true, false, Packet20NamedEntitySpawn.class);
        Packet.addIdClassMapping(21, true, false, Packet21PickupSpawn.class);
        Packet.addIdClassMapping(22, true, false, Packet22Collect.class);
        Packet.addIdClassMapping(23, true, false, Packet23VehicleSpawn.class);
        Packet.addIdClassMapping(24, true, false, Packet24MobSpawn.class);
        Packet.addIdClassMapping(25, true, false, Packet25EntityPainting.class);
        Packet.addIdClassMapping(27, false, true, Packet27Position.class);
        Packet.addIdClassMapping(28, true, false, Packet28EntityVelocity.class);
        Packet.addIdClassMapping(29, true, false, Packet29DestroyEntity.class);
        Packet.addIdClassMapping(30, true, false, Packet30Entity.class);
        Packet.addIdClassMapping(31, true, false, Packet31RelEntityMove.class);
        Packet.addIdClassMapping(32, true, false, Packet32EntityLook.class);
        Packet.addIdClassMapping(33, true, false, Packet33RelEntityMoveLook.class);
        Packet.addIdClassMapping(34, true, false, Packet34EntityTeleport.class);
        Packet.addIdClassMapping(38, true, false, Packet38EntityStatus.class);
        Packet.addIdClassMapping(40, true, false, Packet40EntityMetadata.class);
        Packet.addIdClassMapping(50, true, false, Packet50PreChunk.class);
        Packet.addIdClassMapping(51, true, false, Packet51MapChunk.class);
        Packet.addIdClassMapping(52, true, false, Packet52MultiBlockChange.class);
        Packet.addIdClassMapping(53, true, false, Packet53BlockChange.class);
        Packet.addIdClassMapping(60, true, false, Packet60Explosion.class);
        Packet.addIdClassMapping(61, true, false, Packet61DoorChange.class);
        Packet.addIdClassMapping(100, true, false, Packet100OpenWindow.class);
        Packet.addIdClassMapping(101, true, true, Packet101CloseWindow.class);
        Packet.addIdClassMapping(102, false, true, Packet102WindowClick.class);
        Packet.addIdClassMapping(103, true, false, Packet103SetSlot.class);
        Packet.addIdClassMapping(104, true, false, Packet104WindowItems.class);
        Packet.addIdClassMapping(105, true, false, Packet105UpdateProgressbar.class);
        Packet.addIdClassMapping(106, true, true, Packet106Transaction.class);
        Packet.addIdClassMapping(130, true, true, Packet130UpdateSign.class);
        Packet.addIdClassMapping(255, true, true, Packet255KickDisconnect.class);
        packetStats = new HashMap();
        totalPacketsCount = 0;
    }
}

