/*
 * Decompiled with CFR 0.152.
 */
package paulscode.sound.codecs;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import javax.sound.sampled.AudioFormat;
import paulscode.sound.ICodec;
import paulscode.sound.SoundBuffer;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemLogger;

public class CodecJOrbis
implements ICodec {
    private static final boolean GET = false;
    private static final boolean SET = true;
    private static final boolean XXX = false;
    private URL url;
    private URLConnection urlConnection = null;
    private InputStream inputStream;
    private AudioFormat audioFormat;
    private boolean endOfStream = false;
    private boolean initialized = false;
    private byte[] buffer = null;
    private int bufferSize;
    private int count = 0;
    private int index = 0;
    private int convertedBufferSize;
    private byte[] convertedBuffer = null;
    private float[][][] pcmInfo;
    private int[] pcmIndex;
    private Packet joggPacket = new Packet();
    private Page joggPage = new Page();
    private StreamState joggStreamState = new StreamState();
    private SyncState joggSyncState = new SyncState();
    private DspState jorbisDspState = new DspState();
    private Block jorbisBlock = new Block(this.jorbisDspState);
    private Comment jorbisComment = new Comment();
    private Info jorbisInfo = new Info();
    private SoundSystemLogger logger = SoundSystemConfig.getLogger();

    @Override
    public void reverseByteOrder(boolean bl) {
    }

    @Override
    public boolean initialize(URL uRL) {
        this.initialized(true, false);
        if (this.joggStreamState != null) {
            this.joggStreamState.clear();
        }
        if (this.jorbisBlock != null) {
            this.jorbisBlock.clear();
        }
        if (this.jorbisDspState != null) {
            this.jorbisDspState.clear();
        }
        if (this.jorbisInfo != null) {
            this.jorbisInfo.clear();
        }
        if (this.joggSyncState != null) {
            this.joggSyncState.clear();
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.url = uRL;
        this.bufferSize = 8192;
        this.buffer = null;
        this.count = 0;
        this.index = 0;
        this.joggStreamState = new StreamState();
        this.jorbisBlock = new Block(this.jorbisDspState);
        this.jorbisDspState = new DspState();
        this.jorbisInfo = new Info();
        this.joggSyncState = new SyncState();
        try {
            this.urlConnection = uRL.openConnection();
        }
        catch (UnknownServiceException unknownServiceException) {
            this.errorMessage("Unable to create a UrlConnection in method 'initialize'.");
            this.printStackTrace(unknownServiceException);
            this.cleanup();
            return false;
        }
        catch (IOException iOException) {
            this.errorMessage("Unable to create a UrlConnection in method 'initialize'.");
            this.printStackTrace(iOException);
            this.cleanup();
            return false;
        }
        if (this.urlConnection != null) {
            try {
                this.inputStream = this.urlConnection.getInputStream();
            }
            catch (IOException iOException) {
                this.errorMessage("Unable to acquire inputstream in method 'initialize'.");
                this.printStackTrace(iOException);
                this.cleanup();
                return false;
            }
        }
        this.endOfStream(true, false);
        this.joggSyncState.init();
        this.joggSyncState.buffer(this.bufferSize);
        this.buffer = this.joggSyncState.data;
        try {
            if (!this.readHeader()) {
                this.errorMessage("Error reading the header");
                return false;
            }
        }
        catch (IOException iOException) {
            this.errorMessage("Error reading the header");
            return false;
        }
        this.convertedBufferSize = this.bufferSize * 2;
        this.jorbisDspState.synthesis_init(this.jorbisInfo);
        this.jorbisBlock.init(this.jorbisDspState);
        int n2 = this.jorbisInfo.channels;
        int n3 = this.jorbisInfo.rate;
        this.audioFormat = new AudioFormat(n3, 16, n2, true, false);
        this.pcmInfo = new float[1][][];
        this.pcmIndex = new int[this.jorbisInfo.channels];
        this.initialized(true, true);
        return true;
    }

    @Override
    public boolean initialized() {
        return this.initialized(false, false);
    }

    @Override
    public SoundBuffer read() {
        byte[] byArray = null;
        while (!(this.endOfStream(false, false) || byArray != null && byArray.length >= SoundSystemConfig.getStreamingBufferSize())) {
            byArray = byArray == null ? this.readBytes() : CodecJOrbis.appendByteArrays(byArray, this.readBytes());
        }
        if (byArray == null) {
            return null;
        }
        return new SoundBuffer(byArray, this.audioFormat);
    }

    @Override
    public SoundBuffer readAll() {
        byte[] byArray = null;
        while (!this.endOfStream(false, false)) {
            byArray = byArray == null ? this.readBytes() : CodecJOrbis.appendByteArrays(byArray, this.readBytes());
        }
        if (byArray == null) {
            return null;
        }
        return new SoundBuffer(byArray, this.audioFormat);
    }

    @Override
    public boolean endOfStream() {
        return this.endOfStream(false, false);
    }

    @Override
    public void cleanup() {
        this.joggStreamState.clear();
        this.jorbisBlock.clear();
        this.jorbisDspState.clear();
        this.jorbisInfo.clear();
        this.joggSyncState.clear();
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.joggStreamState = null;
        this.jorbisBlock = null;
        this.jorbisDspState = null;
        this.jorbisInfo = null;
        this.joggSyncState = null;
        this.inputStream = null;
    }

    @Override
    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    /*
     * Unable to fully structure code
     */
    private boolean readHeader() {
        block13: {
            this.index = this.joggSyncState.buffer(this.bufferSize);
            var1_1 = this.inputStream.read(this.joggSyncState.data, this.index, this.bufferSize);
            if (var1_1 < 0) {
                var1_1 = 0;
            }
            this.joggSyncState.wrote(var1_1);
            if (this.joggSyncState.pageout(this.joggPage) != 1) {
                if (var1_1 < this.bufferSize) {
                    return true;
                }
                this.errorMessage("Ogg header not recognized in method 'readHeader'.");
                return false;
            }
            this.joggStreamState.init(this.joggPage.serialno());
            this.jorbisInfo.init();
            this.jorbisComment.init();
            if (this.joggStreamState.pagein(this.joggPage) < 0) {
                this.errorMessage("Problem with first Ogg header page in method 'readHeader'.");
                return false;
            }
            if (this.joggStreamState.packetout(this.joggPacket) != 1) {
                this.errorMessage("Problem with first Ogg header packet in method 'readHeader'.");
                return false;
            }
            if (this.jorbisInfo.synthesis_headerin(this.jorbisComment, this.joggPacket) < 0) {
                this.errorMessage("File does not contain Vorbis header in method 'readHeader'.");
                return false;
            }
            var2_2 = 0;
            break block13;
            while ((var3_3 = this.joggSyncState.pageout(this.joggPage)) != 0) {
                if (var3_3 == 1) {
                    this.joggStreamState.pagein(this.joggPage);
                    while (var2_2 < 2) {
                        var3_3 = this.joggStreamState.packetout(this.joggPacket);
                        if (var3_3 == 0) break;
                        if (var3_3 == -1) {
                            this.errorMessage("Secondary Ogg header corrupt in method 'readHeader'.");
                            return false;
                        }
                        this.jorbisInfo.synthesis_headerin(this.jorbisComment, this.joggPacket);
                        ++var2_2;
                    }
                }
lbl40:
                // 5 sources

                ** while (var2_2 >= 2)
lbl41:
                // 1 sources

            }
lbl42:
            // 2 sources

            this.index = this.joggSyncState.buffer(this.bufferSize);
            var1_1 = this.inputStream.read(this.joggSyncState.data, this.index, this.bufferSize);
            if (var1_1 < 0) {
                var1_1 = 0;
            }
            if (var1_1 == 0 && var2_2 < 2) {
                this.errorMessage("End of file reached before finished readingOgg header in method 'readHeader'");
                return false;
            }
            this.joggSyncState.wrote(var1_1);
        }
        if (var2_2 < 2) ** GOTO lbl40
        this.index = this.joggSyncState.buffer(this.bufferSize);
        this.buffer = this.joggSyncState.data;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private byte[] readBytes() {
        if (!this.initialized(false, false)) {
            return null;
        }
        if (this.endOfStream(false, false)) {
            return null;
        }
        if (this.convertedBuffer == null) {
            this.convertedBuffer = new byte[this.convertedBufferSize];
        }
        var1_1 = null;
        switch (this.joggSyncState.pageout(this.joggPage)) {
            case -1: 
            case 0: {
                break;
            }
            default: {
                this.joggStreamState.pagein(this.joggPage);
                if (this.joggPage.granulepos() == 0L) {
                    this.endOfStream(true, true);
                    return null;
                }
                block9: while (true) {
                    switch (this.joggStreamState.packetout(this.joggPacket)) {
                        case 0: {
                            break block9;
                        }
                        case -1: {
                            continue block9;
                        }
                        default: {
                            if (this.jorbisBlock.synthesis(this.joggPacket) == 0) {
                                this.jorbisDspState.synthesis_blockin(this.jorbisBlock);
                            }
                            while (true) {
                                if ((var3_3 = this.jorbisDspState.synthesis_pcmout(this.pcmInfo, this.pcmIndex)) > 0) ** break;
                                continue block9;
                                var2_2 = this.pcmInfo[0];
                                var4_4 = var3_3 < this.convertedBufferSize ? var3_3 : this.convertedBufferSize;
                                var8_8 = 0;
                                while (var8_8 < this.jorbisInfo.channels) {
                                    var5_5 = var8_8 * 2;
                                    var6_6 = this.pcmIndex[var8_8];
                                    var9_9 = 0;
                                    while (var9_9 < var4_4) {
                                        var7_7 = (int)((double)var2_2[var8_8][var6_6 + var9_9] * 32767.0);
                                        if (var7_7 > 32767) {
                                            var7_7 = 32767;
                                        }
                                        if (var7_7 < -32768) {
                                            var7_7 = -32768;
                                        }
                                        if (var7_7 < 0) {
                                            var7_7 |= 32768;
                                        }
                                        this.convertedBuffer[var5_5] = (byte)var7_7;
                                        this.convertedBuffer[var5_5 + 1] = (byte)(var7_7 >>> 8);
                                        var5_5 += 2 * this.jorbisInfo.channels;
                                        ++var9_9;
                                    }
                                    ++var8_8;
                                }
                                this.jorbisDspState.synthesis_read(var4_4);
                                var1_1 = CodecJOrbis.appendByteArrays(var1_1, this.convertedBuffer, 2 * this.jorbisInfo.channels * var4_4);
                            }
                        }
                    }
                    break;
                }
                if (this.joggPage.eos() == 0) break;
                this.endOfStream(true, true);
            }
        }
        if (!this.endOfStream(false, false)) {
            this.index = this.joggSyncState.buffer(this.bufferSize);
            this.buffer = this.joggSyncState.data;
            try {
                this.count = this.inputStream.read(this.buffer, this.index, this.bufferSize);
            }
            catch (Exception var10_10) {
                this.printStackTrace(var10_10);
                return null;
            }
            if (this.count == -1) {
                return var1_1;
            }
            this.joggSyncState.wrote(this.count);
            if (this.count == 0) {
                this.endOfStream(true, true);
            }
        }
        return var1_1;
    }

    private synchronized boolean initialized(boolean bl, boolean bl2) {
        if (bl) {
            this.initialized = bl2;
        }
        return this.initialized;
    }

    private synchronized boolean endOfStream(boolean bl, boolean bl2) {
        if (bl) {
            this.endOfStream = bl2;
        }
        return this.endOfStream;
    }

    private static byte[] trimArray(byte[] byArray, int n2) {
        byte[] byArray2 = null;
        if (byArray != null && byArray.length > n2) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
        }
        return byArray2;
    }

    private static byte[] appendByteArrays(byte[] byArray, byte[] byArray2, int n2) {
        byte[] byArray3;
        int n3 = n2;
        if (byArray2 == null || byArray2.length == 0) {
            n3 = 0;
        } else if (byArray2.length < n2) {
            n3 = byArray2.length;
        }
        if (byArray == null && (byArray2 == null || n3 <= 0)) {
            return null;
        }
        if (byArray == null) {
            byArray3 = new byte[n3];
            System.arraycopy(byArray2, 0, byArray3, 0, n3);
            byArray2 = null;
        } else if (byArray2 == null || n3 <= 0) {
            byArray3 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            byArray = null;
        } else {
            byArray3 = new byte[byArray.length + n3];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, n3);
            byArray = null;
            byArray2 = null;
        }
        return byArray3;
    }

    private static byte[] appendByteArrays(byte[] byArray, byte[] byArray2) {
        byte[] byArray3;
        if (byArray == null && byArray2 == null) {
            return null;
        }
        if (byArray == null) {
            byArray3 = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
            byArray2 = null;
        } else if (byArray2 == null) {
            byArray3 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            byArray = null;
        } else {
            byArray3 = new byte[byArray.length + byArray2.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
            byArray = null;
            byArray2 = null;
        }
        return byArray3;
    }

    private void errorMessage(String string) {
        this.logger.errorMessage("CodecJOrbis", string, 0);
    }

    private void printStackTrace(Exception exception) {
        this.logger.printStackTrace(exception, 1);
    }
}

