/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.mitask;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.mitask.command.Command;
import net.minecraft.mitask.command.CommandErrorHandler;
import net.minecraft.mitask.command.commands.giveCommand;
import net.minecraft.mitask.command.commands.helpCommand;
import net.minecraft.mitask.command.commands.mastersoundCommand;
import net.minecraft.mitask.command.commands.motifCommand;
import net.minecraft.mitask.command.commands.playsoundCommand;
import net.minecraft.mitask.command.commands.printCommand;
import net.minecraft.mitask.command.commands.reloadCommand;
import net.minecraft.mitask.command.commands.timeCommand;
import net.minecraft.mitask.command.commands.tpCommand;
import net.minecraft.src.client.player.EntityPlayerSP;

public class PlayerCommandHandler {
    public static ArrayList<Command> commands = new ArrayList();
    Minecraft mc;
    public static PlayerCommandHandler instance;

    public PlayerCommandHandler(Minecraft mc) {
        if (Command.isCommandsLoaded) {
            return;
        }
        this.mc = mc;
        instance = this;
        this.registerCommands(mc);
        Command.isCommandsLoaded = true;
    }

    private void registerCommands(Minecraft mc) {
        commands.add(new giveCommand(this));
        commands.add(new tpCommand(this));
        commands.add(new reloadCommand(this));
        commands.add(new printCommand(this));
        commands.add(new motifCommand(this));
        commands.add(new playsoundCommand(this));
        commands.add(new mastersoundCommand(this));
        commands.add(new helpCommand(this));
        commands.add(new timeCommand(this));
    }

    public void handleSlashCommand(String message, EntityPlayerSP commandExecutor) {
        for (Command command : commands) {
            String[] commandMessage = message.split(" ");
            if (command.getAliases() != null) {
                String[] stringArray = command.getAliases();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String alias = stringArray[n2];
                    if (commandMessage[0].equalsIgnoreCase("/" + alias)) {
                        this.handleCommand(command, commandExecutor, commandMessage);
                        return;
                    }
                    ++n2;
                }
                if (!commandMessage[0].equalsIgnoreCase("/" + command.getName())) continue;
                this.handleCommand(command, commandExecutor, commandMessage);
                return;
            }
            if (!commandMessage[0].equalsIgnoreCase("/" + command.getName())) continue;
            this.handleCommand(command, commandExecutor, commandMessage);
            return;
        }
        commandExecutor.addChatMessage(String.valueOf(CommandErrorHandler.invalidCommand) + " " + CommandErrorHandler.findHelp);
    }

    private void handleCommand(Command command, EntityPlayerSP commandExecutor, String[] commandMessage) {
        if (command.isOpOnly()) {
            if (this.mc.playerController.isInCreativeMode()) {
                command.onExecute(commandMessage, commandExecutor);
                return;
            }
            commandExecutor.addChatMessage(CommandErrorHandler.opOnly);
            return;
        }
        command.onExecute(commandMessage, commandExecutor);
    }

    public void reloadCommands() {
        commands.clear();
        this.registerCommands(this.mc);
        for (Command command : commands) {
            System.out.println("Reloaded command: " + command.getName());
        }
    }
}

