/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.mitask.command.commands;

import net.minecraft.mitask.PlayerCommandHandler;
import net.minecraft.mitask.command.Command;
import net.minecraft.mitask.command.CommandErrorHandler;
import net.minecraft.src.client.player.EntityPlayerSP;
import net.minecraft.src.game.stats.StatCollector;

public class helpCommand
extends Command {
    public helpCommand(PlayerCommandHandler commandHandler) {
        super("help", false, false, null);
    }

    @Override
    public void onExecute(String[] args, EntityPlayerSP commandExecutor) {
        if (args.length > 1) {
            this.showCommandInfo(args[1], commandExecutor);
        } else {
            this.showCommandList(commandExecutor);
        }
    }

    private void showCommandList(EntityPlayerSP commandExecutor) {
        String commandList = StatCollector.translateToLocal("command.commandList");
        String commandName = StatCollector.translateToLocal("command.commandName");
        commandExecutor.addChatMessage("\u00a7e" + commandList + "\u00a7f:");
        for (Command command : PlayerCommandHandler.commands) {
            if (command.isHidden()) {
                return;
            }
            String cmd = " - " + commandName + ": \u00a7e" + command.getName();
            commandExecutor.addChatMessage(cmd);
            cmd = "";
        }
    }

    private void showCommandInfo(String commandName, EntityPlayerSP commandExecutor) {
        String giveCmd = "\u00a7d" + StatCollector.translateToLocal("command.give");
        String helpCmd = "\u00a7d" + StatCollector.translateToLocal("command.help");
        String mastersoundCmd1 = "\u00a7d" + StatCollector.translateToLocal("command.mastersound.1");
        String mastersoundCmd2 = "\u00a7d" + StatCollector.translateToLocal("command.mastersound.2");
        String motifCmd = "\u00a7d" + StatCollector.translateToLocal("command.motif");
        String playsoundCmd = "\u00a7d" + StatCollector.translateToLocal("command.playsound");
        String printCmd = "\u00a7d" + StatCollector.translateToLocal("command.print");
        String reloadCmd = "\u00a7d" + StatCollector.translateToLocal("command.reload");
        String timeCmd1 = "\u00a7d" + StatCollector.translateToLocal("command.time.1");
        String timeCmd2 = "\u00a77" + StatCollector.translateToLocal("command.time.2");
        String timeCmd3 = "\u00a77" + StatCollector.translateToLocal("command.time.3");
        String tpCmd = "\u00a7d" + StatCollector.translateToLocal("command.tp");
        if (commandName.equals("give")) {
            CommandErrorHandler.commandUsageMessage("\u00a7e/give <player> <id> <count> <metadata>", commandExecutor);
            commandExecutor.addChatMessage(giveCmd);
            return;
        }
        if (commandName.equals("help")) {
            CommandErrorHandler.commandUsageMessage("\u00a7e/help", commandExecutor);
            commandExecutor.addChatMessage(helpCmd);
            return;
        }
        if (commandName.equals("mastersound")) {
            CommandErrorHandler.commandUsageMessage("\u00a7e/mastersound <x> <y> <z> <string> <volume> <pitch>", commandExecutor);
            commandExecutor.addChatMessage(mastersoundCmd1);
            commandExecutor.addChatMessage(mastersoundCmd2);
            return;
        }
        if (commandName.equals("motif")) {
            CommandErrorHandler.commandUsageMessage("\u00a7e/motif", commandExecutor);
            commandExecutor.addChatMessage(motifCmd);
            return;
        }
        if (commandName.equals("playsound")) {
            CommandErrorHandler.commandUsageMessage("\u00a7e/playsound <string> <volume> <pitch>", commandExecutor);
            commandExecutor.addChatMessage(playsoundCmd);
            return;
        }
        if (commandName.equals("print")) {
            CommandErrorHandler.commandUsageMessage("\u00a7e/print <message>", commandExecutor);
            commandExecutor.addChatMessage(printCmd);
            return;
        }
        if (commandName.equals("reload")) {
            CommandErrorHandler.commandUsageMessage("\u00a7e/reload", commandExecutor);
            commandExecutor.addChatMessage(reloadCmd);
            return;
        }
        if (commandName.equals("time")) {
            CommandErrorHandler.commandUsageMessage("\u00a7e/time <add/set> <value>", commandExecutor);
            commandExecutor.addChatMessage(timeCmd1);
            commandExecutor.addChatMessage(timeCmd2);
            commandExecutor.addChatMessage(timeCmd3);
            return;
        }
        if (commandName.equals("tp")) {
            CommandErrorHandler.commandUsageMessage("\u00a7e/tp <x> <y> <z>", commandExecutor);
            commandExecutor.addChatMessage(tpCmd);
            return;
        }
        commandExecutor.addChatMessage(CommandErrorHandler.invalidCommand);
    }
}

