/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.mitask.command.commands;

import net.minecraft.mitask.PlayerCommandHandler;
import net.minecraft.mitask.command.Command;
import net.minecraft.mitask.command.CommandErrorHandler;
import net.minecraft.src.client.player.EntityPlayerSP;
import net.minecraft.src.game.stats.StatCollector;

public class timeCommand
extends Command {
    public timeCommand(PlayerCommandHandler commandHandler) {
        super("time", false, false, null);
    }

    @Override
    public void onExecute(String[] args, EntityPlayerSP commandExecutor) {
        String timeAddedStr = StatCollector.translateToLocal("command.time.add");
        String timeSetStr = StatCollector.translateToLocal("command.time.set");
        String timeDay = StatCollector.translateToLocal("command.time.day");
        String timeNoon = StatCollector.translateToLocal("command.time.noon");
        String timeSunset = StatCollector.translateToLocal("command.time.sunset");
        String timeNight = StatCollector.translateToLocal("command.time.night");
        if (args.length != 3) {
            CommandErrorHandler.commandUsageMessage("\u00a7e/time <add/set> <value>", commandExecutor);
            commandExecutor.addChatMessage("");
            commandExecutor.addChatMessage(String.valueOf(CommandErrorHandler.moreHelpString) + " \u00a77/help time\u00a7e.");
            return;
        }
        String type = args[1];
        String timeToInt = args[2];
        long time = 0L;
        try {
            time = Integer.parseInt(timeToInt);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if ("add".equalsIgnoreCase(type)) {
            commandExecutor.worldObj.setTimeViaCommand(commandExecutor.worldObj.getWorldTime() + time);
            commandExecutor.addChatMessage(String.valueOf(time) + " " + timeAddedStr);
        } else if ("set".equalsIgnoreCase(type) && "day".equalsIgnoreCase(timeToInt)) {
            commandExecutor.worldObj.setTimeViaCommand(0L);
            commandExecutor.addChatMessage(timeDay);
        } else if ("set".equalsIgnoreCase(type) && "noon".equalsIgnoreCase(timeToInt)) {
            commandExecutor.worldObj.setTimeViaCommand(6000L);
            commandExecutor.addChatMessage(timeNoon);
        } else if ("set".equalsIgnoreCase(type) && "sunset".equalsIgnoreCase(timeToInt)) {
            commandExecutor.worldObj.setTimeViaCommand(12000L);
            commandExecutor.addChatMessage(timeSunset);
        } else if ("set".equalsIgnoreCase(type) && "night".equalsIgnoreCase(timeToInt)) {
            commandExecutor.worldObj.setTimeViaCommand(18000L);
            commandExecutor.addChatMessage(timeNight);
        } else if ("set".equalsIgnoreCase(type)) {
            commandExecutor.worldObj.setTimeViaCommand(time);
            commandExecutor.addChatMessage(String.valueOf(timeSetStr) + " " + time);
        }
    }
}

