/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import net.minecraft.client.Minecraft;
import net.minecraft.src.client.EnumOptions;
import net.minecraft.src.client.EnumOptionsMappingHelper;
import net.minecraft.src.client.KeyBinding;
import net.minecraft.src.client.gui.StringTranslate;
import net.minecraft.src.game.stats.StatCollector;
import org.lwjgl.input.Keyboard;

public class GameSettings {
    private static final String[] RENDER_DISTANCES = new String[]{"options.renderDistance.far", "options.renderDistance.normal", "options.renderDistance.short", "options.renderDistance.tiny"};
    private static final String[] DIFFICULTIES = new String[]{"options.difficulty.peaceful", "options.difficulty.easy", "options.difficulty.normal", "options.difficulty.hard"};
    private static final String[] GUISCALES = new String[]{"options.guiScale.auto", "options.guiScale.small", "options.guiScale.normal", "options.guiScale.large"};
    private static final String[] LIMIT_FRAMERATES = new String[]{"performance.max", "performance.balanced", "performance.powersaver"};
    public float musicVolume = 1.0f;
    public float soundVolume = 1.0f;
    public static float musicInterval = 0.5f;
    public static float cloudHeight = 0.5f;
    public float mouseSensitivity = 0.5f;
    public boolean invertMouse = false;
    public int renderDistance = 0;
    public boolean viewBobbing = true;
    public boolean anaglyph = false;
    public boolean advancedOpengl = false;
    public int limitFramerate = 1;
    public boolean fancyGraphics = true;
    public boolean ambientOcclusion = true;
    public String skin = "Default";
    public KeyBinding keyBindForward = new KeyBinding("key.forward", 17);
    public KeyBinding keyBindLeft = new KeyBinding("key.left", 30);
    public KeyBinding keyBindBack = new KeyBinding("key.back", 31);
    public KeyBinding keyBindRight = new KeyBinding("key.right", 32);
    public KeyBinding keyBindJump = new KeyBinding("key.jump", 57);
    public KeyBinding keyBindInventory = new KeyBinding("key.inventory", 18);
    public KeyBinding keyBindDrop = new KeyBinding("key.drop", 16);
    public KeyBinding keyBindChat = new KeyBinding("key.chat", 20);
    public KeyBinding keyBindToggleFog = new KeyBinding("key.fog", 33);
    public KeyBinding keyBindSneak = new KeyBinding("key.sneak", 42);
    public KeyBinding keyBindRun = new KeyBinding("key.run", 29);
    public KeyBinding[] keyBindings;
    protected Minecraft mc;
    private File optionsFile;
    public int difficulty;
    public boolean hideGUI;
    public int thirdPersonView;
    public boolean showDebugInfo;
    public String lastServer;
    public boolean field_22275_C;
    public boolean smoothCamera;
    public boolean debugCamEnable;
    public float field_22272_F;
    public float field_22271_G;
    public int guiScale;
    public String language = "en_US";
    public String defaultLanguage;
    public boolean heldItemTooltips = true;
    public static boolean itemRenderOld = true;
    public static boolean flowerItems3D = true;
    public static boolean gearfunny = true;
    public static boolean doorTexture = false;
    public boolean itemColorGradient = true;
    public boolean particleDistortion = true;
    private static final String[] BLOCK_DISTORTION = new String[]{"options.off", "options.blockDistortion.some", "options.blockDistortion.all"};
    public int blockDistortion = 0;
    private static final String[] ITEM_IN_3D_OPTIONS = new String[]{"options.off", "options.difficulty.normal", "options.items.static", "options.items.grounded"};
    public static int itemsIn3d = 0;
    public static boolean doItemsHover = true;
    public static boolean doItemsRotate = true;
    public static boolean doesBackGroundMove = true;
    public boolean smoothZoomCamera = false;
    public float gammaSetting = 0.0f;
    public boolean showKeys = false;
    public KeyBinding keyBindAttack = new KeyBinding("key.attack", -100);
    public KeyBinding keyBindUseItem = new KeyBinding("key.use", -99);
    public int chatBackground = 2;
    private static final String[] CHAT_WIDTH = new String[]{"options.off", "options.chatBackground.efficient", "options.on"};

    public GameSettings(Minecraft var1, File var2) {
        this.keyBindings = new KeyBinding[]{this.keyBindForward, this.keyBindLeft, this.keyBindBack, this.keyBindRight, this.keyBindJump, this.keyBindSneak, this.keyBindDrop, this.keyBindInventory, this.keyBindChat, this.keyBindToggleFog};
        this.difficulty = 2;
        this.hideGUI = false;
        this.thirdPersonView = 0;
        this.showDebugInfo = false;
        this.lastServer = "";
        this.field_22275_C = false;
        this.smoothCamera = false;
        this.debugCamEnable = false;
        this.field_22272_F = 1.0f;
        this.field_22271_G = 1.0f;
        this.guiScale = 0;
        this.mc = var1;
        this.defaultLanguage = "en_US";
        this.optionsFile = new File(var2, "optionsReIndev.txt");
        gearfunny = true;
        this.loadOptions();
    }

    public GameSettings() {
        this.keyBindings = new KeyBinding[]{this.keyBindForward, this.keyBindLeft, this.keyBindBack, this.keyBindRight, this.keyBindJump, this.keyBindSneak, this.keyBindRun, this.keyBindDrop, this.keyBindInventory, this.keyBindChat, this.keyBindToggleFog};
        this.difficulty = 2;
        this.hideGUI = false;
        this.thirdPersonView = 0;
        this.showDebugInfo = false;
        this.lastServer = "";
        this.field_22275_C = false;
        this.smoothCamera = false;
        this.debugCamEnable = false;
        this.field_22272_F = 1.0f;
        this.field_22271_G = 1.0f;
        this.defaultLanguage = "en_US";
        this.guiScale = 0;
        gearfunny = true;
    }

    public String getKeyBindingDescription(int var1) {
        StringTranslate var2 = StringTranslate.getInstance();
        return var2.translateKey(this.keyBindings[var1].keyDescription);
    }

    public String getOptionDisplayString(int var1) {
        return Keyboard.getKeyName((int)this.keyBindings[var1].keyCode);
    }

    public String getOptionNameString(int var1) {
        return Keyboard.getKeyName((int)var1);
    }

    public void setKeyBinding(int var1, int var2) {
        this.keyBindings[var1].keyCode = var2;
        this.saveOptions();
    }

    public void setOptionFloatValue(EnumOptions var1, float var2) {
        if (var1 == EnumOptions.MUSIC) {
            this.musicVolume = var2;
            this.mc.sndManager.onSoundOptionsChanged();
        }
        if (var1 == EnumOptions.SOUND) {
            this.soundVolume = var2;
            this.mc.sndManager.onSoundOptionsChanged();
        }
        if (var1 == EnumOptions.MUSINTERVAL) {
            musicInterval = var2;
            this.mc.sndManager.onSoundOptionsChanged();
        }
        if (var1 == EnumOptions.SENSITIVITY) {
            this.mouseSensitivity = var2;
        }
        if (var1 == EnumOptions.CLOUD) {
            cloudHeight = var2;
        }
        if (var1 == EnumOptions.GAMMA) {
            this.gammaSetting = var2;
        }
    }

    public void setOptionValue(EnumOptions var1, int var2) {
        if (var1 == EnumOptions.INVERT_MOUSE) {
            boolean bl = this.invertMouse = !this.invertMouse;
        }
        if (var1 == EnumOptions.RENDER_DISTANCE) {
            this.renderDistance = this.renderDistance + var2 & 3;
        }
        if (var1 == EnumOptions.ITEMS_IN_3D) {
            itemsIn3d = itemsIn3d + var2 & 3;
        }
        if (var1 == EnumOptions.MOVING_BACKGROUND) {
            boolean bl = doesBackGroundMove = !doesBackGroundMove;
        }
        if (var1 == EnumOptions.BLOCK_DISTORTION) {
            this.blockDistortion = (this.blockDistortion + var2 + 3) % 3;
            this.mc.renderGlobal.loadRenderers();
        }
        if (var1 == EnumOptions.CHAT_WIDTH) {
            this.chatBackground = (this.chatBackground + var2 + 3) % 3;
        }
        if (var1 == EnumOptions.GUI_SCALE) {
            this.guiScale = this.guiScale + var2 & 3;
        }
        if (var1 == EnumOptions.VIEW_BOBBING) {
            boolean bl = this.viewBobbing = !this.viewBobbing;
        }
        if (var1 == EnumOptions.ADVANCED_OPENGL) {
            this.advancedOpengl = !this.advancedOpengl;
            this.mc.renderGlobal.loadRenderers();
        }
        if (var1 == EnumOptions.ANAGLYPH) {
            this.anaglyph = !this.anaglyph;
            this.mc.renderEngine.refreshTextures();
        }
        if (var1 == EnumOptions.FRAMERATE_LIMIT) {
            this.limitFramerate = (this.limitFramerate + var2 + 3) % 3;
        }
        if (var1 == EnumOptions.DIFFICULTY) {
            this.difficulty = this.difficulty + var2 & 3;
        }
        if (var1 == EnumOptions.GRAPHICS) {
            this.fancyGraphics = !this.fancyGraphics;
            this.mc.renderGlobal.loadRenderers();
        }
        if (var1 == EnumOptions.OLDITEMS) {
            boolean bl = itemRenderOld = !itemRenderOld;
        }
        if (var1 == EnumOptions.ITEMCOLOR) {
            boolean bl = this.itemColorGradient = !this.itemColorGradient;
        }
        if (var1 == EnumOptions.OLD_DOOR) {
            doorTexture = !doorTexture;
            this.mc.renderGlobal.loadRenderers();
        }
        if (var1 == EnumOptions.FLOWERITEMS) {
            boolean bl = flowerItems3D = !flowerItems3D;
        }
        if (var1 == EnumOptions.PARTICLE_DISTORTION) {
            boolean bl = this.particleDistortion = !this.particleDistortion;
        }
        if (var1 == EnumOptions.hovering_items) {
            boolean bl = doItemsHover = !doItemsHover;
        }
        if (var1 == EnumOptions.rotating_items) {
            boolean bl = doItemsRotate = !doItemsRotate;
        }
        if (var1 == EnumOptions.GEAR) {
            boolean bl = gearfunny = !gearfunny;
        }
        if (var1 == EnumOptions.AMBIENT_OCCLUSION) {
            this.ambientOcclusion = !this.ambientOcclusion;
            this.mc.renderGlobal.loadRenderers();
        }
        if (var1 == EnumOptions.SHOW_YOUR_KEYBOARD_INPUTS_NOW) {
            this.showKeys = !this.showKeys;
        }
        this.saveOptions();
    }

    public float getOptionFloatValue(EnumOptions var1) {
        if (var1 == EnumOptions.MUSIC) {
            return this.musicVolume;
        }
        if (var1 == EnumOptions.SOUND) {
            return this.soundVolume;
        }
        if (var1 == EnumOptions.GAMMA) {
            return this.gammaSetting;
        }
        if (var1 == EnumOptions.MUSINTERVAL) {
            return musicInterval;
        }
        if (var1 == EnumOptions.CLOUD) {
            return cloudHeight;
        }
        return var1 == EnumOptions.SENSITIVITY ? this.mouseSensitivity : 0.0f;
    }

    public boolean getOptionOrdinalValue(EnumOptions var1) {
        switch (EnumOptionsMappingHelper.enumOptionsMappingHelperArray[var1.ordinal()]) {
            case 1: {
                return this.invertMouse;
            }
            case 2: {
                return this.viewBobbing;
            }
            case 3: {
                return this.anaglyph;
            }
            case 4: {
                return this.advancedOpengl;
            }
            case 5: {
                return this.ambientOcclusion;
            }
        }
        return false;
    }

    public String getKeyBinding(EnumOptions var1) {
        StringTranslate var2 = StringTranslate.getInstance();
        String var3 = String.valueOf(var2.translateKey(var1.getEnumString())) + ": ";
        if (var1.getEnumFloat()) {
            float var5 = this.getOptionFloatValue(var1);
            if (var1 == EnumOptions.SENSITIVITY) {
                if (var5 == 0.0f) {
                    return String.valueOf(var3) + var2.translateKey("options.sensitivity.min");
                }
                return var5 == 1.0f ? String.valueOf(var3) + var2.translateKey("options.sensitivity.max") : String.valueOf(var3) + (int)(var5 * 200.0f) + "%";
            }
            if (var1 == EnumOptions.MUSINTERVAL) {
                return String.valueOf(var3) + (int)(var5 * 12000.0f / 20.0f) + " seconds";
            }
            return var5 == 0.0f ? String.valueOf(var3) + var2.translateKey("options.off") : String.valueOf(var3) + (int)(var5 * 100.0f) + "%";
        }
        if (var1.getEnumBoolean()) {
            boolean var4 = this.getOptionOrdinalValue(var1);
            return var4 ? String.valueOf(var3) + var2.translateKey("options.on") : String.valueOf(var3) + var2.translateKey("options.off");
        }
        if (var1 == EnumOptions.RENDER_DISTANCE) {
            return String.valueOf(var3) + var2.translateKey(RENDER_DISTANCES[this.renderDistance]);
        }
        if (var1 == EnumOptions.ITEMS_IN_3D) {
            return String.valueOf(var3) + var2.translateKey(ITEM_IN_3D_OPTIONS[itemsIn3d]);
        }
        if (var1 == EnumOptions.DIFFICULTY) {
            return String.valueOf(var3) + var2.translateKey(DIFFICULTIES[this.difficulty]);
        }
        if (var1 == EnumOptions.GUI_SCALE) {
            return String.valueOf(var3) + var2.translateKey(GUISCALES[this.guiScale]);
        }
        if (var1 == EnumOptions.FRAMERATE_LIMIT) {
            return String.valueOf(var3) + StatCollector.translateToLocal(LIMIT_FRAMERATES[this.limitFramerate]);
        }
        if (var1 == EnumOptions.GRAPHICS) {
            return this.fancyGraphics ? String.valueOf(var3) + var2.translateKey("options.graphics.fancy") : String.valueOf(var3) + var2.translateKey("options.graphics.fast");
        }
        if (var1 == EnumOptions.OLD_DOOR) {
            return doorTexture ? String.valueOf(var3) + var2.translateKey("options.on") : String.valueOf(var3) + var2.translateKey("options.off");
        }
        if (var1 == EnumOptions.ITEMCOLOR) {
            return this.itemColorGradient ? String.valueOf(var3) + var2.translateKey("options.top") : String.valueOf(var3) + var2.translateKey("options.bottom");
        }
        if (var1 == EnumOptions.OLDITEMS) {
            return itemRenderOld ? String.valueOf(var3) + var2.translateKey("options.on") : String.valueOf(var3) + var2.translateKey("options.off");
        }
        if (var1 == EnumOptions.FLOWERITEMS) {
            return flowerItems3D ? String.valueOf(var3) + var2.translateKey("options.on") : String.valueOf(var3) + var2.translateKey("options.off");
        }
        if (var1 == EnumOptions.GEAR) {
            return gearfunny ? String.valueOf(var3) + var2.translateKey("options.on") : String.valueOf(var3) + var2.translateKey("options.off");
        }
        if (var1 == EnumOptions.hovering_items) {
            return doItemsHover ? String.valueOf(var3) + var2.translateKey("options.on") : String.valueOf(var3) + var2.translateKey("options.off");
        }
        if (var1 == EnumOptions.rotating_items) {
            return doItemsRotate ? String.valueOf(var3) + var2.translateKey("options.on") : String.valueOf(var3) + var2.translateKey("options.off");
        }
        if (var1 == EnumOptions.MOVING_BACKGROUND) {
            return doesBackGroundMove ? String.valueOf(var3) + var2.translateKey("options.on") : String.valueOf(var3) + var2.translateKey("options.off");
        }
        if (var1 == EnumOptions.PARTICLE_DISTORTION) {
            return this.particleDistortion ? String.valueOf(var3) + var2.translateKey("options.on") : String.valueOf(var3) + var2.translateKey("options.off");
        }
        if (var1 == EnumOptions.BLOCK_DISTORTION) {
            return String.valueOf(var3) + var2.translateKey(BLOCK_DISTORTION[this.blockDistortion]);
        }
        if (var1 == EnumOptions.CHAT_WIDTH) {
            return String.valueOf(var3) + var2.translateKey(CHAT_WIDTH[this.chatBackground]);
        }
        if (var1 == EnumOptions.SHOW_YOUR_KEYBOARD_INPUTS_NOW) {
            return this.showKeys ? String.valueOf(var3) + var2.translateKey("options.on") : String.valueOf(var3) + var2.translateKey("options.off");
        }
        return var3;
    }

    public String getOptionsInfo(EnumOptions var1) {
        StringTranslate var2 = StringTranslate.getInstance();
        String var3 = var2.translateKey(var1.getEnumInfo());
        if (var1 == EnumOptions.MUSIC) {
            return (Object)((Object)var1) + var3;
        }
        return var3;
    }

    public void loadOptions() {
        try {
            if (!this.optionsFile.exists()) {
                return;
            }
            BufferedReader var1 = new BufferedReader(new FileReader(this.optionsFile));
            String var2 = "";
            while ((var2 = var1.readLine()) != null) {
                try {
                    String[] var3 = var2.split(":");
                    if (var3[0].equals("cloudHeight")) {
                        cloudHeight = this.parseFloat(var3[1]);
                    }
                    if (var3[0].equals("music")) {
                        this.musicVolume = this.parseFloat(var3[1]);
                    }
                    if (var3[0].equals("sound")) {
                        this.soundVolume = this.parseFloat(var3[1]);
                    }
                    if (var3[0].equals("gammaSetting")) {
                        this.gammaSetting = this.parseFloat(var3[1]);
                    }
                    if (var3[0].equals("musicInterval")) {
                        musicInterval = this.parseFloat(var3[1]);
                    }
                    if (var3[0].equals("mouseSensitivity")) {
                        this.mouseSensitivity = this.parseFloat(var3[1]);
                    }
                    if (var3[0].equals("invertYMouse")) {
                        this.invertMouse = var3[1].equals("true");
                    }
                    if (var3[0].equals("viewDistance")) {
                        this.renderDistance = Integer.parseInt(var3[1]);
                    }
                    if (var3[0].equals("blockDistortion")) {
                        this.blockDistortion = Integer.parseInt(var3[1]);
                    }
                    if (var3[0].equals("chatBackground")) {
                        this.chatBackground = Integer.parseInt(var3[1]);
                    }
                    if (var3[0].equals("itemsIn3d")) {
                        itemsIn3d = Integer.parseInt(var3[1]);
                    }
                    if (var3[0].equals("doItemsHover")) {
                        doItemsHover = var3[1].equals("true");
                    }
                    if (var3[0].equals("itemColorGradient")) {
                        this.itemColorGradient = var3[1].equals("true");
                    }
                    if (var3[0].equals("showKeys")) {
                        this.showKeys = var3[1].equals("true");
                    }
                    if (var3[0].equals("doItemsRotate")) {
                        doItemsRotate = var3[1].equals("true");
                    }
                    if (var3[0].equals("doesBackGroundMove")) {
                        doesBackGroundMove = var3[1].equals("true");
                    }
                    if (var3[0].equals("guiScale")) {
                        this.guiScale = Integer.parseInt(var3[1]);
                    }
                    if (var3[0].equals("bobView")) {
                        this.viewBobbing = var3[1].equals("true");
                    }
                    if (var3[0].equals("anaglyph3d")) {
                        this.anaglyph = var3[1].equals("true");
                    }
                    if (var3[0].equals("advancedOpengl")) {
                        this.advancedOpengl = var3[1].equals("true");
                    }
                    if (var3[0].equals("fpsLimit")) {
                        this.limitFramerate = Integer.parseInt(var3[1]);
                    }
                    if (var3[0].equals("difficulty")) {
                        this.difficulty = Integer.parseInt(var3[1]);
                    }
                    if (var3[0].equals("fancyGraphics")) {
                        this.fancyGraphics = var3[1].equals("true");
                    }
                    if (var3[0].equals("itemRenderOld")) {
                        itemRenderOld = var3[1].equals("true");
                    }
                    if (var3[0].equals("doorTexture")) {
                        doorTexture = var3[1].equals("true");
                    }
                    if (var3[0].equals("flowersRenderedIn3D")) {
                        flowerItems3D = var3[1].equals("true");
                    }
                    if (var3[0].equals("gears")) {
                        gearfunny = var3[1].equals("true");
                    }
                    if (var3[0].equals("particleDistortion")) {
                        this.particleDistortion = var3[1].equals("true");
                    }
                    if (var3[0].equals("ao")) {
                        this.ambientOcclusion = var3[1].equals("true");
                    }
                    if (var3[0].equals("skin")) {
                        this.skin = var3[1];
                    }
                    if (var3[0].equals("lastServer") && var3.length >= 2) {
                        this.lastServer = var3[1];
                    }
                    if (var3[0].equals("lang") && var3.length >= 2) {
                        this.defaultLanguage = var3[1];
                    }
                    int var4 = 0;
                    while (var4 < this.keyBindings.length) {
                        if (var3[0].equals("key_" + this.keyBindings[var4].keyDescription)) {
                            this.keyBindings[var4].keyCode = Integer.parseInt(var3[1]);
                        }
                        ++var4;
                    }
                }
                catch (Exception var5) {
                    System.out.println("Skipping bad option: " + var2);
                }
            }
            var1.close();
        }
        catch (Exception var6) {
            System.out.println("Failed to load options");
            var6.printStackTrace();
        }
    }

    private float parseFloat(String var1) {
        if (var1.equals("true")) {
            return 1.0f;
        }
        return var1.equals("false") ? 0.0f : Float.parseFloat(var1);
    }

    public void saveOptions() {
        try {
            PrintWriter var1 = new PrintWriter(new FileWriter(this.optionsFile));
            var1.println("cloudHeight:" + cloudHeight);
            var1.println("music:" + this.musicVolume);
            var1.println("sound:" + this.soundVolume);
            var1.println("invertYMouse:" + this.invertMouse);
            var1.println("mouseSensitivity:" + this.mouseSensitivity);
            var1.println("viewDistance:" + this.renderDistance);
            var1.println("guiScale:" + this.guiScale);
            var1.println("bobView:" + this.viewBobbing);
            var1.println("anaglyph3d:" + this.anaglyph);
            var1.println("advancedOpengl:" + this.advancedOpengl);
            var1.println("fpsLimit:" + this.limitFramerate);
            var1.println("difficulty:" + this.difficulty);
            var1.println("fancyGraphics:" + this.fancyGraphics);
            var1.println("ao:" + this.ambientOcclusion);
            var1.println("skin:" + this.skin);
            var1.println("lastServer:" + this.lastServer);
            var1.println("itemRendering:" + itemRenderOld);
            var1.println("flowersRenderedIn3D:" + flowerItems3D);
            var1.println("doorTexture:" + doorTexture);
            var1.println("gears:" + gearfunny);
            var1.println("particleDistortion:" + this.particleDistortion);
            var1.println("itemsIn3d:" + itemsIn3d);
            var1.println("doItemsHover:" + doItemsHover);
            var1.println("doItemsRotate:" + doItemsRotate);
            var1.println("blockDistortion:" + this.blockDistortion);
            var1.println("musicInterval:" + musicInterval);
            var1.println("doesBackGroundMove:" + doesBackGroundMove);
            var1.println("gammaSetting:" + this.gammaSetting);
            var1.println("itemColorGradient:" + this.itemColorGradient);
            var1.println("showKeys:" + this.showKeys);
            var1.println("chatBackground:" + this.chatBackground);
            var1.println("lang:" + this.defaultLanguage);
            int var2 = 0;
            while (var2 < this.keyBindings.length) {
                var1.println("key_" + this.keyBindings[var2].keyDescription + ":" + this.keyBindings[var2].keyCode);
                ++var2;
            }
            var1.close();
        }
        catch (Exception var3) {
            System.out.println("Failed to save options");
            var3.printStackTrace();
        }
    }
}

