/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client.gui;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.text.Bidi;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.src.client.GameSettings;
import net.minecraft.src.client.gui.ChatAllowedCharacters;
import net.minecraft.src.client.renderer.RenderEngine;
import org.lwjgl.opengl.GL11;

public class FontRenderer {
    private int[] charWidth;
    public int fontTextureName = 0;
    public int FONT_HEIGHT = 8;
    public Random field_41064_c;
    private byte[] field_44036_e;
    private final int[] field_44034_f = new int[256];
    private int[] field_44035_g;
    private int field_44038_h;
    private final RenderEngine field_44039_i;
    private float stringX;
    private float stringY;
    private boolean field_44037_j;
    private boolean field_46125_m;

    public FontRenderer(GameSettings gamesettings, String s, RenderEngine renderengine, boolean flag) {
        BufferedImage bufferedimage;
        this.charWidth = new int[256];
        this.field_41064_c = new Random();
        this.field_44036_e = new byte[65536];
        this.field_44035_g = new int[32];
        this.field_44039_i = renderengine;
        this.field_44037_j = flag;
        try {
            bufferedimage = ImageIO.read(RenderEngine.class.getResourceAsStream(s));
            InputStream inputstream = RenderEngine.class.getResourceAsStream("/font/glyph_sizes.bin");
            inputstream.read(this.field_44036_e);
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
        int i = bufferedimage.getWidth();
        int j = bufferedimage.getHeight();
        int[] ai = new int[i * j];
        bufferedimage.getRGB(0, 0, i, j, ai, 0, i);
        int k = 0;
        while (k < 256) {
            int i2;
            int i1 = k % 16;
            int k1 = k / 16;
            for (i2 = 7; i2 >= 0; --i2) {
                int k2 = i1 * 8 + i2;
                boolean flag1 = true;
                int j3 = 0;
                while (j3 < 8 && flag1) {
                    int l3 = (k1 * 8 + j3) * i;
                    int j4 = ai[k2 + l3] & 0xFF;
                    if (j4 > 0) {
                        flag1 = false;
                    }
                    ++j3;
                }
                if (!flag1) break;
            }
            if (k == 32) {
                i2 = 2;
            }
            this.charWidth[k] = i2 + 2;
            ++k;
        }
        this.fontTextureName = renderengine.allocateAndSetupTexture(bufferedimage);
        int l = 0;
        while (l < 32) {
            int j1 = (l >> 3 & 1) * 85;
            int l1 = (l >> 2 & 1) * 170 + j1;
            int j2 = (l >> 1 & 1) * 170 + j1;
            int l2 = (l >> 0 & 1) * 170 + j1;
            if (l == 6) {
                l1 += 85;
            }
            if (gamesettings.anaglyph) {
                int i3 = (l1 * 30 + j2 * 59 + l2 * 11) / 100;
                int k3 = (l1 * 30 + j2 * 70) / 100;
                int i4 = (l1 * 30 + l2 * 70) / 100;
                l1 = i3;
                j2 = k3;
                l2 = i4;
            }
            if (l >= 16) {
                l1 /= 4;
                j2 /= 4;
                l2 /= 4;
            }
            this.field_44035_g[l] = (l1 & 0xFF) << 16 | (j2 & 0xFF) << 8 | l2 & 0xFF;
            ++l;
        }
    }

    private void func_44031_a(int i) {
        float f = i % 16 * 8;
        float f1 = i / 16 * 8;
        if (this.field_44038_h != this.fontTextureName) {
            GL11.glBindTexture((int)3553, (int)this.fontTextureName);
            this.field_44038_h = this.fontTextureName;
        }
        float f2 = (float)this.charWidth[i] - 0.01f;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)(f / 128.0f), (float)(f1 / 128.0f));
        GL11.glVertex3f((float)this.stringX, (float)this.stringY, (float)0.0f);
        GL11.glTexCoord2f((float)(f / 128.0f), (float)((f1 + 7.99f) / 128.0f));
        GL11.glVertex3f((float)this.stringX, (float)(this.stringY + 7.99f), (float)0.0f);
        GL11.glTexCoord2f((float)((f + f2) / 128.0f), (float)(f1 / 128.0f));
        GL11.glVertex3f((float)(this.stringX + f2), (float)this.stringY, (float)0.0f);
        GL11.glTexCoord2f((float)((f + f2) / 128.0f), (float)((f1 + 7.99f) / 128.0f));
        GL11.glVertex3f((float)(this.stringX + f2), (float)(this.stringY + 7.99f), (float)0.0f);
        GL11.glEnd();
        this.stringX += (float)this.charWidth[i];
    }

    private void func_44030_b(int i) {
        BufferedImage bufferedimage;
        String s = String.format("/font/glyph_%02X.png", i);
        try {
            bufferedimage = ImageIO.read(RenderEngine.class.getResourceAsStream(s.toString()));
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
        this.field_44034_f[i] = this.field_44039_i.allocateAndSetupTexture(bufferedimage);
        this.field_44038_h = this.field_44034_f[i];
    }

    private void func_44033_a(char c) {
        if (this.field_44036_e[c] == 0) {
            return;
        }
        int i = c / 256;
        if (this.field_44034_f[i] == 0) {
            this.func_44030_b(i);
        }
        if (this.field_44038_h != this.field_44034_f[i]) {
            GL11.glBindTexture((int)3553, (int)this.field_44034_f[i]);
            this.field_44038_h = this.field_44034_f[i];
        }
        int j = this.field_44036_e[c] >>> 4;
        int k = this.field_44036_e[c] & 0xF;
        float f = j;
        float f1 = k + 1;
        float f2 = (float)(c % 16 * 16) + f;
        float f3 = (c & 0xFF) / 16 * 16;
        float f4 = f1 - f - 0.02f;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)(f2 / 256.0f), (float)(f3 / 256.0f));
        GL11.glVertex3f((float)this.stringX, (float)this.stringY, (float)0.0f);
        GL11.glTexCoord2f((float)(f2 / 256.0f), (float)((f3 + 15.98f) / 256.0f));
        GL11.glVertex3f((float)this.stringX, (float)(this.stringY + 7.99f), (float)0.0f);
        GL11.glTexCoord2f((float)((f2 + f4) / 256.0f), (float)(f3 / 256.0f));
        GL11.glVertex3f((float)(this.stringX + f4 / 2.0f), (float)this.stringY, (float)0.0f);
        GL11.glTexCoord2f((float)((f2 + f4) / 256.0f), (float)((f3 + 15.98f) / 256.0f));
        GL11.glVertex3f((float)(this.stringX + f4 / 2.0f), (float)(this.stringY + 7.99f), (float)0.0f);
        GL11.glEnd();
        this.stringX += (f1 - f) / 2.0f + 1.0f;
    }

    public void drawStringWithShadow(String string, int x, int y, int color) {
        if (this.field_46125_m) {
            string = this.func_46121_b(string);
        }
        this.renderString(string, x + 1, y + 1, color, true);
        this.renderString(string, x, y, color, false);
    }

    public void drawString(String s, int i, int j, int k) {
        if (this.field_46125_m) {
            s = this.func_46121_b(s);
        }
        this.renderString(s, i, j, k, false);
    }

    private String func_46121_b(String s) {
        if (s == null || !Bidi.requiresBidi(s.toCharArray(), 0, s.length())) {
            return s;
        }
        Bidi bidi = new Bidi(s, -2);
        byte[] abyte0 = new byte[bidi.getRunCount()];
        Object[] as = new String[abyte0.length];
        int i = 0;
        while (i < abyte0.length) {
            int j = bidi.getRunStart(i);
            int k = bidi.getRunLimit(i);
            int i1 = bidi.getRunLevel(i);
            String s1 = s.substring(j, k);
            abyte0[i] = (byte)i1;
            as[i] = s1;
            ++i;
        }
        String[] as1 = (String[])as.clone();
        Bidi.reorderVisually(abyte0, 0, as, 0, abyte0.length);
        StringBuilder stringbuilder = new StringBuilder();
        int l = 0;
        while (l < as.length) {
            int j1;
            byte byte0 = abyte0[l];
            for (j1 = 0; j1 < as1.length; ++j1) {
                if (!as1[j1].equals(as[l])) continue;
                byte0 = abyte0[j1];
                break;
            }
            if ((byte0 & 1) == 0) {
                stringbuilder.append((String)as[l]);
            } else {
                for (j1 = ((String)as[l]).length() - 1; j1 >= 0; --j1) {
                    char c = ((String)as[l]).charAt(j1);
                    if (c == '(') {
                        c = ')';
                    } else if (c == ')') {
                        c = '(';
                    }
                    stringbuilder.append(c);
                }
            }
            ++l;
        }
        return stringbuilder.toString();
    }

    private void func_44029_a(String s, boolean flag) {
        boolean flag1 = false;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\u00a7' && i + 1 < s.length()) {
                int j = "0123456789abcdefk".indexOf(s.toLowerCase().charAt(i + 1));
                if (j == 16) {
                    flag1 = true;
                } else {
                    flag1 = false;
                    if (j < 0 || j > 15) {
                        j = 15;
                    }
                    if (flag) {
                        j += 16;
                    }
                    int l = this.field_44035_g[j];
                    GL11.glColor3f((float)((float)(l >> 16) / 255.0f), (float)((float)(l >> 8 & 0xFF) / 255.0f), (float)((float)(l & 0xFF) / 255.0f));
                }
                ++i;
            } else {
                int k = ChatAllowedCharacters.allowedCharacters.indexOf(c);
                if (flag1 && k > 0) {
                    int i1;
                    while (this.charWidth[k + 1] != this.charWidth[(i1 = this.field_41064_c.nextInt(ChatAllowedCharacters.allowedCharacters.length())) + 1]) {
                    }
                    k = i1;
                }
                if (c == ' ') {
                    this.stringX += 4.0f;
                } else if (k > 0 && !this.field_44037_j) {
                    this.func_44031_a(k + 1);
                } else {
                    this.func_44033_a(c);
                }
            }
            ++i;
        }
    }

    private void renderString(String string, int x, int y, int color, boolean flag) {
        if (string != null) {
            this.field_44038_h = 0;
            if ((color & 0xFC000000) == 0) {
                color |= 0xFF000000;
            }
            if (flag) {
                color = (color & 0xFCFCFC) >> 2 | color & 0xFF000000;
            }
            GL11.glColor4f((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >> 24 & 0xFF) / 255.0f));
            this.stringX = x;
            this.stringY = y;
            this.func_44029_a(string, flag);
        }
    }

    public int getStringWidth(String s) {
        if (s == null) {
            return 0;
        }
        int i = 0;
        int j = 0;
        while (j < s.length()) {
            char c = s.charAt(j);
            if (c == '\u00a7') {
                ++j;
            } else {
                int k = ChatAllowedCharacters.allowedCharacters.indexOf(c);
                if (k >= 0 && !this.field_44037_j) {
                    i += this.charWidth[k + 1];
                } else if (this.field_44036_e[c] != 0) {
                    int l = this.field_44036_e[c] >> 4;
                    int i1 = this.field_44036_e[c] & 0xF;
                    if (i1 > 7) {
                        i1 = 15;
                        l = 0;
                    }
                    i += (++i1 - l) / 2 + 1;
                }
            }
            ++j;
        }
        return i;
    }

    public void drawSplitString(String s, int i, int j, int k, int l) {
        if (this.field_46125_m) {
            s = this.func_46121_b(s);
        }
        this.func_46124_b(s, i, j, k, l);
    }

    private void func_46124_b(String s, int i, int j, int k, int l) {
        this.func_46122_b(s, i, j, k, l, false);
    }

    public void func_40609_a(String s, int i, int j, int k, int l, boolean flag) {
        if (this.field_46125_m) {
            s = this.func_46121_b(s);
        }
        this.func_46122_b(s, i, j, k, l, flag);
    }

    private void func_46122_b(String s, int i, int j, int k, int l, boolean flag) {
        String[] as = s.split("\n");
        if (as.length > 1) {
            int i1 = 0;
            while (i1 < as.length) {
                this.func_46124_b(as[i1], i, j, k, l);
                j += this.splitStringWidth(as[i1], k);
                ++i1;
            }
            return;
        }
        String[] as1 = s.split(" ");
        int j1 = 0;
        String s1 = "";
        while (j1 < as1.length) {
            String s2 = s1 + as1[j1++] + " ";
            while (j1 < as1.length && this.getStringWidth(s2 + as1[j1]) < k) {
                s2 = s2 + as1[j1++] + " ";
            }
            while (this.getStringWidth(s2) > k) {
                int k1 = 0;
                while (this.getStringWidth(s2.substring(0, k1 + 1)) <= k) {
                    ++k1;
                }
                if (s2.substring(0, k1).trim().length() > 0) {
                    String s3 = s2.substring(0, k1);
                    if (s3.lastIndexOf("\u00a7") >= 0) {
                        s1 = "\u00a7" + s3.charAt(s3.lastIndexOf("\u00a7") + 1);
                    }
                    this.renderString(s3, i, j, l, flag);
                    j += this.FONT_HEIGHT;
                }
                s2 = s1 + s2.substring(k1);
            }
            if (this.getStringWidth(s2.trim()) <= 0) continue;
            if (s2.lastIndexOf("\u00a7") >= 0) {
                s1 = "\u00a7" + s2.charAt(s2.lastIndexOf("\u00a7") + 1);
            }
            this.renderString(s2, i, j, l, flag);
            j += this.FONT_HEIGHT;
        }
    }

    public int splitStringWidth(String s, int i) {
        String[] as = s.split("\n");
        if (as.length > 1) {
            int j = 0;
            int k = 0;
            while (k < as.length) {
                j += this.splitStringWidth(as[k], i);
                ++k;
            }
            return j;
        }
        String[] as1 = s.split(" ");
        int l = 0;
        int i1 = 0;
        while (l < as1.length) {
            String s1 = as1[l++] + " ";
            while (l < as1.length && this.getStringWidth(s1 + as1[l]) < i) {
                s1 = s1 + as1[l++] + " ";
            }
            while (this.getStringWidth(s1) > i) {
                int j1 = 0;
                while (this.getStringWidth(s1.substring(0, j1 + 1)) <= i) {
                    ++j1;
                }
                if (s1.substring(0, j1).trim().length() > 0) {
                    i1 += this.FONT_HEIGHT;
                }
                s1 = s1.substring(j1);
            }
            if (s1.trim().length() <= 0) continue;
            i1 += this.FONT_HEIGHT;
        }
        if (i1 < this.FONT_HEIGHT) {
            i1 += this.FONT_HEIGHT;
        }
        return i1;
    }

    public void func_44032_a(boolean flag) {
        this.field_44037_j = flag;
    }

    public void func_46123_b(boolean flag) {
        this.field_46125_m = flag;
    }
}

