/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client.gui;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import net.minecraft.src.client.gui.ChatAllowedCharacters;
import net.minecraft.src.client.gui.GuiButton;
import net.minecraft.src.client.gui.GuiScreen;
import net.minecraft.src.client.packets.Packet130UpdateSign;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.tileentity.TileEntityRenderer;
import net.minecraft.src.game.block.tileentity.TileEntitySign;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiEditSign
extends GuiScreen {
    protected String screenTitle = "Edit sign message:";
    private TileEntitySign entitySign;
    private int updateCounter;
    private int editLine = 0;
    private static final String allowedCharacters = ChatAllowedCharacters.allowedCharacters;

    public GuiEditSign(TileEntitySign var1) {
        this.entitySign = var1;
    }

    public static String getClipboardString() {
        try {
            Transferable var0 = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (var0 != null && var0.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String var1 = (String)var0.getTransferData(DataFlavor.stringFlavor);
                return var1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void initGui() {
        this.controlList.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.controlList.add(new GuiButton(0, this.width / 2 - 100, this.height / 4 + 120, "Done"));
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
        if (this.mc.theWorld.multiplayerWorld) {
            this.mc.getSendQueue().addToSendQueue(new Packet130UpdateSign(this.entitySign.xCoord, this.entitySign.yCoord, this.entitySign.zCoord, this.entitySign.signText));
        }
    }

    @Override
    public void updateScreen() {
        ++this.updateCounter;
    }

    @Override
    protected void actionPerformed(GuiButton var1) {
        if (var1.enabled && var1.id == 0) {
            this.entitySign.y_();
            this.mc.displayGuiScreen(null);
        }
    }

    @Override
    protected void keyTyped(char var1, int var2) {
        int line;
        StringBuilder string;
        if (var1 == '\u0016') {
            int var4;
            String var3 = GuiScreen.getClipboardString();
            if (var3 == null) {
                var3 = "";
            }
            if ((var4 = 32 - this.entitySign.signText[this.editLine].length()) > var3.length()) {
                var4 = var3.length();
            }
            if (var4 > 0) {
                this.entitySign.signText[this.editLine] = String.valueOf(this.entitySign.signText[this.editLine]) + var3.substring(0, var4);
            }
        }
        if (var2 == 200) {
            this.editLine = this.editLine - 1 & 3;
        }
        if (var2 == 208 || var2 == 28) {
            this.editLine = this.editLine + 1 & 3;
        }
        if (var2 == 14 && this.entitySign.signText[this.editLine].length() > 0) {
            this.entitySign.signText[this.editLine] = this.entitySign.signText[this.editLine].substring(0, this.entitySign.signText[this.editLine].length() - 1);
        }
        if (allowedCharacters.indexOf(var1) >= 0 && this.entitySign.signText[this.editLine].length() < 15) {
            string = new StringBuilder();
            String[] text = this.entitySign.signText;
            line = this.editLine;
            text[line] = string.append(text[line]).append(var1).toString();
        }
        if (Keyboard.getEventKey() == 59 && this.entitySign.signText[this.editLine].length() < 15) {
            string = new StringBuilder();
            String[] text = this.entitySign.signText;
            line = this.editLine;
            text[line] = string.append(text[line]).append("\u00a7").toString();
        }
    }

    @Override
    public void drawScreen(int var1, int var2, float var3) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRenderer, this.screenTitle, this.width / 2, 40, 0xFFFFFF);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.width / 2), (float)0.0f, (float)50.0f);
        float scale = 93.75f;
        GL11.glScalef((float)(-scale), (float)(-scale), (float)(-scale));
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        Block var5 = this.entitySign.getBlockType();
        if (var5 == Block.signPost) {
            float var6 = (float)(this.entitySign.getBlockMetadata() * 360) / 16.0f;
            GL11.glRotatef((float)var6, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-1.0625f, (float)0.0f);
        } else {
            int var8 = this.entitySign.getBlockMetadata();
            float var7 = 0.0f;
            if (var8 == 2) {
                var7 = 180.0f;
            }
            if (var8 == 4) {
                var7 = 90.0f;
            }
            if (var8 == 5) {
                var7 = -90.0f;
            }
            GL11.glRotatef((float)var7, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-1.0625f, (float)0.0f);
        }
        if (this.updateCounter / 6 % 2 == 0) {
            this.entitySign.lineBeingEdited = this.editLine;
        }
        TileEntityRenderer.instance.renderTileEntityAt(this.entitySign, -0.5, -0.75, -0.5, 0.0f);
        this.entitySign.lineBeingEdited = -1;
        GL11.glPopMatrix();
        super.drawScreen(var1, var2, var3);
    }
}

