/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client.gui;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import net.minecraft.src.client.gui.GuiButton;
import net.minecraft.src.client.gui.GuiButtonLanguage;
import net.minecraft.src.client.gui.GuiLanguage;
import net.minecraft.src.client.gui.GuiMultiplayer;
import net.minecraft.src.client.gui.GuiOptions;
import net.minecraft.src.client.gui.GuiScreen;
import net.minecraft.src.client.gui.GuiSelectWorld;
import net.minecraft.src.client.gui.GuiTexturePacks;
import net.minecraft.src.client.gui.LogoEffectRandomizer;
import net.minecraft.src.client.gui.ScaledResolution;
import net.minecraft.src.client.gui.StringTranslate;
import net.minecraft.src.client.renderer.RenderBlocks;
import net.minecraft.src.client.renderer.Tessellator;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Block;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class GuiMainMenu
extends GuiScreen {
    private static final Random rand = new Random();
    private String splashText = "missingno";
    private GuiButton multiplayerButton;
    private GuiButton tutorialButton;
    private int field_35357_f = 0;
    private int field_35358_g;
    private float updateInt;
    String[] minecraftLogo = new String[]{" *   * * *   * *** *** *** *** *** ***", " ** ** * **  * *   *   * * * * *    * ", " * * * * * * * **  *   **  *** **   * ", " *   * * *  ** *   *   * * * * *    * ", " *   * * *   * *** *** * * * * *    * "};
    String[] reindevLogo = new String[]{"*** *** * *   * ***  *** * *", "* * *   * **  * *  * *   * *", "**  **  * * * * *  * **  * *", "* * *   * *  ** *  * *   * *", "* * *** * *   * ***  ***  * "};
    String[] minceraft = new String[]{" *   * * *   * *** *** *** *** *** ***", " ** ** * **  * *   *   * * * * *    * ", " * * * * * * * *   **  **  *** **   * ", " *   * * *  ** *   *   * * * * *    * ", " *   * * *   * *** *** * * * * *    * "};
    private LogoEffectRandomizer[][] logoEffects;

    public GuiMainMenu() {
        try {
            ArrayList<String> var1 = new ArrayList<String>();
            BufferedReader var2 = new BufferedReader(new InputStreamReader(GuiMainMenu.class.getResourceAsStream("/title/splashes.txt"), Charset.forName("UTF-8")));
            String var3 = "";
            while ((var3 = var2.readLine()) != null) {
                if ((var3 = var3.trim()).length() <= 0) continue;
                var1.add(var3);
            }
            this.splashText = (String)var1.get(rand.nextInt(var1.size()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void updateScreen() {
        ++this.field_35357_f;
        this.updateInt += 0.005f;
        if (this.logoEffects != null) {
            int i = 0;
            while (i < this.logoEffects.length) {
                int j = 0;
                while (j < this.logoEffects[i].length) {
                    this.logoEffects[i][j].func_875_a();
                    ++j;
                }
                ++i;
            }
        }
    }

    @Override
    protected void keyTyped(char var1, int var2) {
    }

    @Override
    public void initGui() {
        this.field_35358_g = this.mc.renderEngine.allocateAndSetupTexture(new BufferedImage(256, 256, 2));
        Calendar var1 = Calendar.getInstance();
        var1.setTime(new Date());
        if (var1.get(2) + 1 == 11 && var1.get(5) == 3) {
            this.splashText = "Happy birthday, Silver!";
        } else if (var1.get(2) + 1 == 12 && var1.get(5) == 22) {
            this.splashText = "Happy birthday, Vodka!";
        } else if (var1.get(2) + 1 == 12 && var1.get(5) == 24) {
            this.splashText = "Merry X-mas!";
        } else if (var1.get(2) + 1 == 1 && var1.get(5) == 1) {
            this.splashText = "Happy new year!";
        }
        StringTranslate var2 = StringTranslate.getInstance();
        int var4 = this.height / 4 + 48;
        this.controlList.add(new GuiButton(1, this.width / 2 - 100, var4, var2.translateKey("menu.singleplayer")));
        this.multiplayerButton = new GuiButton(2, this.width / 2 - 100, var4 + 24, var2.translateKey("menu.multiplayer"));
        this.controlList.add(this.multiplayerButton);
        this.tutorialButton = new GuiButton(3, this.width / 2 - 100, var4 + 48, var2.translateKey("menu.tutorial"));
        this.controlList.add(this.tutorialButton);
        this.controlList.add(new GuiButton(0, this.width / 2 - 100, var4 + 72 + 12, 98, 20, var2.translateKey("menu.options")));
        this.controlList.add(new GuiButton(4, this.width / 2 + 2, var4 + 72 + 12, 98, 20, var2.translateKey("menu.quit")));
        this.controlList.add(new GuiButtonLanguage(5, this.width / 2 - 124, var4 + 72 + 12));
        if (this.mc.session == null) {
            this.multiplayerButton.enabled = false;
        }
        this.tutorialButton.enabled = false;
    }

    @Override
    protected void actionPerformed(GuiButton var1) {
        if (var1.id == 0) {
            this.mc.displayGuiScreen(new GuiOptions(this, this.mc.gameSettings));
        }
        if (var1.id == 1) {
            this.mc.displayGuiScreen(new GuiSelectWorld(this));
        }
        if (var1.id == 2) {
            this.mc.displayGuiScreen(new GuiMultiplayer(this));
        }
        if (var1.id == 3) {
            this.mc.displayGuiScreen(new GuiTexturePacks(this));
        }
        if (var1.id == 5) {
            this.mc.displayGuiScreen(new GuiLanguage(this, this.mc.gameSettings));
        }
        if (var1.id == 4) {
            this.mc.shutdown();
        }
    }

    private void func_35355_b(int i, int j, float f) {
        Tessellator tessellator = Tessellator.instance;
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GLU.gluPerspective((float)120.0f, (float)1.0f, (float)0.05f, (float)10.0f);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2884);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        int k = 8;
        int l = 0;
        while (l < k * k) {
            GL11.glPushMatrix();
            float f1 = ((float)(l % k) / (float)k - 0.5f) / 64.0f;
            float f2 = ((float)(l / k) / (float)k - 0.5f) / 64.0f;
            float f3 = 0.0f;
            GL11.glTranslatef((float)f1, (float)f2, (float)f3);
            GL11.glRotatef((float)(MathHelper.sin(((float)this.field_35357_f + f) / 400.0f) * 25.0f + 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(-((float)this.field_35357_f + f) * 0.1f), (float)0.0f, (float)1.0f, (float)0.0f);
            int panoramaFace = 0;
            while (panoramaFace < 6) {
                GL11.glPushMatrix();
                if (panoramaFace == 1) {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (panoramaFace == 2) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (panoramaFace == 3) {
                    GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (panoramaFace == 4) {
                    GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
                if (panoramaFace == 5) {
                    GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
                GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/bg/panorama" + panoramaFace + ".png"));
                tessellator.setBrightness(255);
                tessellator.startDrawingQuads();
                tessellator.setColorRGBA_I(0xFFFFFF, 255 / (l + 2));
                float f4 = 0.0f;
                tessellator.addVertexWithUV(-1.0, -1.0, 1.0, 0.0f + f4, 0.0f + f4);
                tessellator.addVertexWithUV(1.0, -1.0, 1.0, 1.0f - f4, 0.0f + f4);
                tessellator.addVertexWithUV(1.0, 1.0, 1.0, 1.0f - f4, 1.0f - f4);
                tessellator.addVertexWithUV(-1.0, 1.0, 1.0, 0.0f + f4, 1.0f - f4);
                tessellator.draw();
                GL11.glPopMatrix();
                ++panoramaFace;
            }
            GL11.glPopMatrix();
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            ++l;
        }
        tessellator.setTranslationF(0.0f, 0.0f, 0.0f);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2929);
    }

    private void func_35354_a(float f) {
        GL11.glBindTexture((int)3553, (int)this.field_35358_g);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        int byte0 = 3;
        int i = 0;
        while (i < byte0) {
            int screenWidth = this.width;
            int screenHeight = this.height;
            float f1 = (float)(i - byte0 / 2) / 256.0f;
            tessellator.addVertexWithUV(screenWidth, screenHeight, this.zLevel, 0.0f + f1, 0.0);
            tessellator.addVertexWithUV(screenWidth, 0.0, this.zLevel, 1.0f + f1, 0.0);
            tessellator.addVertexWithUV(0.0, 0.0, this.zLevel, 1.0f + f1, 1.0);
            tessellator.addVertexWithUV(0.0, screenHeight, this.zLevel, 0.0f + f1, 1.0);
            ++i;
        }
        tessellator.draw();
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    private void func_35356_c(int i, int j, float f) {
        GL11.glViewport((int)0, (int)0, (int)this.mc.displayWidth, (int)this.mc.displayHeight);
        this.func_35355_b(i, j, f);
        this.func_35354_a(f);
        this.func_35354_a(f);
        this.func_35354_a(f);
        this.func_35354_a(f);
        this.func_35354_a(f);
        this.func_35354_a(f);
        this.func_35354_a(f);
        this.func_35354_a(f);
        GL11.glViewport((int)0, (int)0, (int)this.mc.displayWidth, (int)this.mc.displayHeight);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        float f1 = this.width <= this.height ? 120.0f / (float)this.height : 120.0f / (float)this.width;
        float f2 = (float)this.height * f1 / 256.0f;
        float f3 = (float)this.width * f1 / 256.0f;
        int screenWidth = this.width;
        int screenHeight = this.height;
        tessellator.addVertexWithUV(0.0, screenHeight, this.zLevel, 0.5f - f2, 0.5f + f3);
        tessellator.addVertexWithUV(screenWidth, screenHeight, this.zLevel, 0.5f - f2, 0.5f - f3);
        tessellator.addVertexWithUV(screenWidth, 0.0, this.zLevel, 0.5f + f2, 0.5f - f3);
        tessellator.addVertexWithUV(0.0, 0.0, this.zLevel, 0.5f + f2, 0.5f + f3);
        tessellator.draw();
    }

    @Override
    public final void drawScreen(int n, int n2, float n3) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        this.func_35356_c(n, n2, n3);
        if (calendar.get(2) + 1 == 1 || calendar.get(2) + 1 == 1 || calendar.get(2) + 1 == 12) {
            this.drawDefaultMainMenuBackground(this.updateInt);
        }
        Tessellator instance = Tessellator.instance;
        if (!Keyboard.isKeyDown((int)2)) {
            this.drawLogo(n, n2, n3);
            this.drawLogoLower(n, n2, n3);
        }
        if (Keyboard.isKeyDown((int)2)) {
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/misc/gus.png"));
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            instance.setColorOpaque_I(0xFFFFFF);
            this.drawTexturedModalRect((this.width - 256) / 2, 0, 0, 0, 256, 256);
        }
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/logo.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        instance.setColorOpaque_I(0xFFFFFF);
        this.drawTexturedModalRect((this.width - 256) / 2, 10, 0, 0, 256, 100);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.width / 2 + 90), (float)70.0f, (float)0.0f);
        GL11.glRotatef((float)-20.0f, (float)0.0f, (float)0.0f, (float)0.5f);
        int versionWidth = 31;
        float n4 = 1.8f - MathHelper.abs(MathHelper.sin((float)(System.currentTimeMillis() % 1000L) / 1000.0f * (float)Math.PI * 2.0f) * 0.1f);
        n4 = n4 * 100.0f / (float)(this.fontRenderer.getStringWidth(this.splashText) + 32);
        GL11.glScalef((float)n4, (float)n4, (float)n4);
        this.drawCenteredString(this.fontRenderer, this.splashText, 16, 4, 0xFFFF00);
        GL11.glPopMatrix();
        String s = "Copyright Mojang Specifications. Do not distribute.";
        this.drawString(this.fontRenderer, "Copyright Mojang Specifications. Do not distribute.", this.width - this.fontRenderer.getStringWidth("Copyright Mojang Specifications. Do not distribute.") - 2, this.height - 10, 0xFFFFFF);
        String s1 = "ReIndev Mod created by Silveros.";
        this.drawString(this.fontRenderer, "ReIndev Mod created by Silveros.", this.width - this.fontRenderer.getStringWidth("ReIndev Mod created by Silveros.") - 2, this.height - 22, 0xFFFFFF);
        String s2 = "Minecraft ReIndev";
        this.drawCenteredString(this.fontRenderer, "Minecraft ReIndev", this.fontRenderer.getStringWidth("Minecraft ReIndev") - 44, this.height - 22, 0xFFFFFF);
        String s21 = "Release 2.5.1";
        this.drawCenteredString(this.fontRenderer, "Release 2.5.1", this.fontRenderer.getStringWidth("Release 2.5.1") - versionWidth, this.height - 10, 0xFFFFFF);
        super.drawScreen(n, n2, n3);
    }

    public void drawLogo(int var1, int var2, float var3) {
        if (this.logoEffects == null) {
            this.logoEffects = new LogoEffectRandomizer[this.minecraftLogo[0].length()][this.minecraftLogo.length];
            int i = 0;
            while (i < this.logoEffects.length) {
                int j = 0;
                while (j < this.logoEffects[i].length) {
                    this.logoEffects[i][j] = new LogoEffectRandomizer(this, i, j);
                    ++j;
                }
                ++i;
            }
        }
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        ScaledResolution scaledresolution = new ScaledResolution(this.mc.gameSettings, this.mc.displayWidth, this.mc.displayHeight);
        int totalScale = 120 * scaledresolution.scaleFactor;
        GLU.gluPerspective((float)70.0f, (float)((float)this.mc.displayWidth / (float)totalScale), (float)0.05f, (float)100.0f);
        GL11.glViewport((int)0, (int)(this.mc.displayHeight - totalScale), (int)this.mc.displayWidth, (int)totalScale);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glDisable((int)2884);
        GL11.glCullFace((int)1029);
        GL11.glDepthMask((boolean)true);
        RenderBlocks renderblocks = new RenderBlocks();
        int l = 0;
        while (l < 3) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.4f, (float)2.0f, (float)-13.0f);
            if (l == 0) {
                GL11.glClear((int)256);
                GL11.glTranslatef((float)0.0f, (float)-0.4f, (float)0.0f);
                GL11.glScalef((float)0.98f, (float)1.0f, (float)1.0f);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
            }
            if (l == 1) {
                GL11.glDisable((int)3042);
                GL11.glClear((int)256);
            }
            if (l == 2) {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)768, (int)1);
            }
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
            GL11.glRotatef((float)15.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)0.89f, (float)1.0f, (float)0.4f);
            GL11.glTranslatef((float)((float)(-this.minecraftLogo[0].length()) * 0.5f), (float)((float)(-this.minecraftLogo.length) * 0.5f), (float)0.0f);
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/terrain.png"));
            if (l == 0) {
                GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/title/black.png"));
            }
            int i1 = 0;
            while (i1 < this.minecraftLogo.length) {
                int j1 = 0;
                while (j1 < this.minecraftLogo[i1].length()) {
                    char c = this.minecraftLogo[i1].charAt(j1);
                    if (c != ' ') {
                        GL11.glPushMatrix();
                        LogoEffectRandomizer logoeffectrandomizer = this.logoEffects[j1][i1];
                        float f1 = (float)(logoeffectrandomizer.field_1311_b + (logoeffectrandomizer.field_1312_a - logoeffectrandomizer.field_1311_b) * (double)var3);
                        float scale = 1.0f;
                        float f3 = 1.0f;
                        float rotation = 0.0f;
                        if (l == 0) {
                            scale = f1 * 0.04f + 1.0f;
                            f3 = 1.0f / scale;
                            f1 = 0.0f;
                        }
                        GL11.glTranslatef((float)j1, (float)i1, (float)f1);
                        GL11.glScalef((float)scale, (float)scale, (float)scale);
                        GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
                        if (Block.logoBlock.blockID == Block.cloth.blockID || Block.logoBlock.blockID == Block.stucco.blockID) {
                            renderblocks.titleScreenBlocks(Block.logoBlock, f3, Block.logoBlockMetadataColors);
                        } else if (Block.logoBlock.blockID == Block.planks.blockID) {
                            renderblocks.titleScreenBlocks(Block.logoBlock, f3, Block.logoBlockMetadataPlanks);
                        } else {
                            renderblocks.titleScreenBlocks(Block.logoBlock, f3, 0);
                        }
                        GL11.glPopMatrix();
                    }
                    ++j1;
                }
                ++i1;
            }
            GL11.glPopMatrix();
            ++l;
        }
        GL11.glDisable((int)3042);
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glViewport((int)0, (int)0, (int)this.mc.displayWidth, (int)this.mc.displayHeight);
        GL11.glEnable((int)2884);
    }

    public void drawLogoLower(int var1, int var2, float var3) {
        if (this.logoEffects == null) {
            this.logoEffects = new LogoEffectRandomizer[this.reindevLogo[0].length()][this.reindevLogo.length];
            int i = 0;
            while (i < this.logoEffects.length) {
                int j = 0;
                while (j < this.logoEffects[i].length) {
                    this.logoEffects[i][j] = new LogoEffectRandomizer(this, i, j);
                    ++j;
                }
                ++i;
            }
        }
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        ScaledResolution scaledresolution = new ScaledResolution(this.mc.gameSettings, this.mc.displayWidth, this.mc.displayHeight);
        int totalScale = 100 * scaledresolution.scaleFactor;
        GLU.gluPerspective((float)70.0f, (float)((float)this.mc.displayWidth / (float)totalScale), (float)0.05f, (float)100.0f);
        GL11.glViewport((int)0, (int)(this.mc.displayHeight - totalScale), (int)this.mc.displayWidth, (int)totalScale);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glDisable((int)2884);
        GL11.glCullFace((int)1029);
        GL11.glDepthMask((boolean)true);
        RenderBlocks renderblocks = new RenderBlocks();
        int l = 0;
        while (l < 3) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.4f, (float)-5.2f, (float)-13.0f);
            if (l == 0) {
                GL11.glClear((int)256);
                GL11.glTranslatef((float)0.0f, (float)-0.4f, (float)0.0f);
                GL11.glScalef((float)0.98f, (float)1.0f, (float)1.0f);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
            }
            if (l == 1) {
                GL11.glDisable((int)3042);
                GL11.glClear((int)256);
            }
            if (l == 2) {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)768, (int)1);
            }
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
            GL11.glRotatef((float)15.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)0.89f, (float)1.0f, (float)0.4f);
            GL11.glTranslatef((float)((float)(-this.reindevLogo[0].length()) * 0.5f), (float)((float)(-this.reindevLogo.length) * 0.5f), (float)0.0f);
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/terrain.png"));
            if (l == 0) {
                GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/title/black.png"));
            }
            int i1 = 0;
            while (i1 < this.reindevLogo.length) {
                int j1 = 0;
                while (j1 < this.reindevLogo[i1].length()) {
                    char c = this.reindevLogo[i1].charAt(j1);
                    if (c != ' ') {
                        GL11.glPushMatrix();
                        LogoEffectRandomizer logoeffectrandomizer = this.logoEffects[j1][i1];
                        float f1 = (float)(logoeffectrandomizer.field_1311_b + (logoeffectrandomizer.field_1312_a - logoeffectrandomizer.field_1311_b) * (double)var3);
                        float scale = 1.0f;
                        float f3 = 1.0f;
                        float rotation = 0.0f;
                        if (l == 0) {
                            scale = f1 * 0.04f + 1.0f;
                            f3 = 1.0f / scale;
                            f1 = 0.0f;
                        }
                        GL11.glTranslatef((float)j1, (float)i1, (float)f1);
                        GL11.glScalef((float)scale, (float)scale, (float)scale);
                        GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
                        if (Block.logoBlock.blockID == Block.cloth.blockID || Block.logoBlock.blockID == Block.stucco.blockID) {
                            renderblocks.titleScreenBlocks(Block.logoBlock, f3, Block.logoBlockMetadataColors);
                        } else if (Block.logoBlock.blockID == Block.planks.blockID) {
                            renderblocks.titleScreenBlocks(Block.logoBlock, f3, Block.logoBlockMetadataPlanks);
                        } else {
                            renderblocks.titleScreenBlocks(Block.logoBlock, f3, 0);
                        }
                        GL11.glPopMatrix();
                    }
                    ++j1;
                }
                ++i1;
            }
            GL11.glPopMatrix();
            ++l;
        }
        GL11.glDisable((int)3042);
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glViewport((int)0, (int)0, (int)this.mc.displayWidth, (int)this.mc.displayHeight);
        GL11.glEnable((int)2884);
    }

    static Random getRand() {
        return rand;
    }

    public String[] logoChoice(Random rand) {
        return rand.nextInt(10) == 0 ? this.minceraft : this.minecraftLogo;
    }
}

