/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client.model;

import net.minecraft.src.client.renderer.Tessellator;
import net.minecraft.src.client.renderer.Vec3D;
import net.minecraft.src.client.renderer.block.PositionTextureVertex;

public class TexturedQuad2 {
    public PositionTextureVertex[] vertexPositions;
    public int nVertices = 0;
    private boolean invertNormal = false;

    public TexturedQuad2(PositionTextureVertex[] apositiontexturevertex) {
        this.vertexPositions = apositiontexturevertex;
        this.nVertices = apositiontexturevertex.length;
    }

    public TexturedQuad2(PositionTextureVertex[] apositiontexturevertex, int i, int j, int k, int l, float f, float f1) {
        this(apositiontexturevertex);
        float f2 = 0.0f / f;
        float f3 = 0.0f / f1;
        apositiontexturevertex[0] = apositiontexturevertex[0].setTexturePosition((float)k / f - f2, (float)j / f1 + f3);
        apositiontexturevertex[1] = apositiontexturevertex[1].setTexturePosition((float)i / f + f2, (float)j / f1 + f3);
        apositiontexturevertex[2] = apositiontexturevertex[2].setTexturePosition((float)i / f + f2, (float)l / f1 - f3);
        apositiontexturevertex[3] = apositiontexturevertex[3].setTexturePosition((float)k / f - f2, (float)l / f1 - f3);
    }

    public void flipFace() {
        PositionTextureVertex[] apositiontexturevertex = new PositionTextureVertex[this.vertexPositions.length];
        int i = 0;
        while (i < this.vertexPositions.length) {
            apositiontexturevertex[i] = this.vertexPositions[this.vertexPositions.length - i - 1];
            ++i;
        }
        this.vertexPositions = apositiontexturevertex;
    }

    public void draw(Tessellator tessellator, float f) {
        Vec3D vec3d = this.vertexPositions[1].vector3D.subtract(this.vertexPositions[0].vector3D);
        Vec3D vec3d1 = this.vertexPositions[1].vector3D.subtract(this.vertexPositions[2].vector3D);
        Vec3D vec3d2 = vec3d1.crossProduct(vec3d).normalize();
        tessellator.startDrawingQuads();
        if (this.invertNormal) {
            tessellator.setNormal(-((float)vec3d2.xCoord), -((float)vec3d2.yCoord), -((float)vec3d2.zCoord));
        } else {
            tessellator.setNormal((float)vec3d2.xCoord, (float)vec3d2.yCoord, (float)vec3d2.zCoord);
        }
        int i = 0;
        while (i < 4) {
            PositionTextureVertex positiontexturevertex = this.vertexPositions[i];
            tessellator.addVertexWithUV((float)positiontexturevertex.vector3D.xCoord * f, (float)positiontexturevertex.vector3D.yCoord * f, (float)positiontexturevertex.vector3D.zCoord * f, positiontexturevertex.texturePositionX, positiontexturevertex.texturePositionY);
            ++i;
        }
        tessellator.draw();
    }
}

