/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client.packets;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.mitask.Config;
import net.minecraft.src.client.gui.Container;
import net.minecraft.src.client.gui.GuiConnectFailed;
import net.minecraft.src.client.gui.GuiDownloadTerrain;
import net.minecraft.src.client.gui.PlayerListStats;
import net.minecraft.src.client.inventory.InventoryBasic;
import net.minecraft.src.client.packets.NetHandler;
import net.minecraft.src.client.packets.NetworkManager;
import net.minecraft.src.client.packets.Packet;
import net.minecraft.src.client.packets.Packet100OpenWindow;
import net.minecraft.src.client.packets.Packet101CloseWindow;
import net.minecraft.src.client.packets.Packet103SetSlot;
import net.minecraft.src.client.packets.Packet104WindowItems;
import net.minecraft.src.client.packets.Packet105UpdateProgressbar;
import net.minecraft.src.client.packets.Packet106Transaction;
import net.minecraft.src.client.packets.Packet10Flying;
import net.minecraft.src.client.packets.Packet130UpdateSign;
import net.minecraft.src.client.packets.Packet131MapData;
import net.minecraft.src.client.packets.Packet17Sleep;
import net.minecraft.src.client.packets.Packet18Animation;
import net.minecraft.src.client.packets.Packet1Login;
import net.minecraft.src.client.packets.Packet200Statistic;
import net.minecraft.src.client.packets.Packet201PlayerInfo;
import net.minecraft.src.client.packets.Packet20NamedEntitySpawn;
import net.minecraft.src.client.packets.Packet21PickupSpawn;
import net.minecraft.src.client.packets.Packet22Collect;
import net.minecraft.src.client.packets.Packet23VehicleSpawn;
import net.minecraft.src.client.packets.Packet24MobSpawn;
import net.minecraft.src.client.packets.Packet252CommandList;
import net.minecraft.src.client.packets.Packet255KickDisconnect;
import net.minecraft.src.client.packets.Packet25EntityPainting;
import net.minecraft.src.client.packets.Packet28EntityVelocity;
import net.minecraft.src.client.packets.Packet29DestroyEntity;
import net.minecraft.src.client.packets.Packet2Handshake;
import net.minecraft.src.client.packets.Packet30Entity;
import net.minecraft.src.client.packets.Packet34EntityTeleport;
import net.minecraft.src.client.packets.Packet38EntityStatus;
import net.minecraft.src.client.packets.Packet39AttachEntity;
import net.minecraft.src.client.packets.Packet3Chat;
import net.minecraft.src.client.packets.Packet40EntityMetadata;
import net.minecraft.src.client.packets.Packet4UpdateTime;
import net.minecraft.src.client.packets.Packet50PreChunk;
import net.minecraft.src.client.packets.Packet51MapChunk;
import net.minecraft.src.client.packets.Packet52MultiBlockChange;
import net.minecraft.src.client.packets.Packet53BlockChange;
import net.minecraft.src.client.packets.Packet54PlayNoteBlock;
import net.minecraft.src.client.packets.Packet5PlayerInventory;
import net.minecraft.src.client.packets.Packet60Explosion;
import net.minecraft.src.client.packets.Packet61DoorChange;
import net.minecraft.src.client.packets.Packet64Potion;
import net.minecraft.src.client.packets.Packet65Potion2;
import net.minecraft.src.client.packets.Packet66Cauldron;
import net.minecraft.src.client.packets.Packet67Anvil;
import net.minecraft.src.client.packets.Packet68Effects;
import net.minecraft.src.client.packets.Packet6SpawnPosition;
import net.minecraft.src.client.packets.Packet70Bed;
import net.minecraft.src.client.packets.Packet71Weather;
import net.minecraft.src.client.packets.Packet80EntityChair;
import net.minecraft.src.client.packets.Packet8UpdateHealth;
import net.minecraft.src.client.packets.Packet9Respawn;
import net.minecraft.src.client.particle.EntityPickupFX;
import net.minecraft.src.client.player.EntityClientPlayerMP;
import net.minecraft.src.client.player.EntityOtherPlayerMP;
import net.minecraft.src.client.player.EntityPlayerSP;
import net.minecraft.src.client.player.PlayerControllerMP;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.tileentity.TileEntity;
import net.minecraft.src.game.block.tileentity.TileEntityAnvil;
import net.minecraft.src.game.block.tileentity.TileEntityBlastFurnace;
import net.minecraft.src.game.block.tileentity.TileEntityCauldron;
import net.minecraft.src.game.block.tileentity.TileEntityDispenser;
import net.minecraft.src.game.block.tileentity.TileEntityFurnace;
import net.minecraft.src.game.block.tileentity.TileEntitySign;
import net.minecraft.src.game.effect.Effect;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.EntityList;
import net.minecraft.src.game.entity.EntityLiving;
import net.minecraft.src.game.entity.other.EntityArrow;
import net.minecraft.src.game.entity.other.EntityArrowGolden;
import net.minecraft.src.game.entity.other.EntityArrowPurple;
import net.minecraft.src.game.entity.other.EntityBoat;
import net.minecraft.src.game.entity.other.EntityBrick;
import net.minecraft.src.game.entity.other.EntityChair;
import net.minecraft.src.game.entity.other.EntityDynamite;
import net.minecraft.src.game.entity.other.EntityEgg;
import net.minecraft.src.game.entity.other.EntityFallingSand;
import net.minecraft.src.game.entity.other.EntityFireball;
import net.minecraft.src.game.entity.other.EntityFish;
import net.minecraft.src.game.entity.other.EntityItem;
import net.minecraft.src.game.entity.other.EntityLightningBolt;
import net.minecraft.src.game.entity.other.EntityMinecart;
import net.minecraft.src.game.entity.other.EntityPainting;
import net.minecraft.src.game.entity.other.EntitySnowball;
import net.minecraft.src.game.entity.other.EntitySpeechBubble;
import net.minecraft.src.game.entity.other.EntityTNTPrimed;
import net.minecraft.src.game.entity.other.EntityTorch;
import net.minecraft.src.game.entity.other.SignEntity;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemMap;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.Explosion;
import net.minecraft.src.game.level.WorldClient;
import net.minecraft.src.game.level.chunk.Chunk;
import net.minecraft.src.game.level.chunk.ChunkCoordinates;
import net.minecraft.src.game.level.map.MapStorage;
import net.minecraft.src.game.stats.StatList;

public class NetClientHandler
extends NetHandler {
    private boolean disconnected = false;
    private NetworkManager netManager;
    public String field_1209_a;
    private Minecraft mc;
    private WorldClient worldClient;
    private boolean field_1210_g = false;
    public MapStorage field_28118_b = new MapStorage(null);
    private Map playerNameList;
    public List field_35786_c;
    public int playerPing;
    Random rand = new Random();

    public NetClientHandler(Minecraft var1, String var2, int var3) throws UnknownHostException, IOException {
        this.mc = var1;
        Socket var4 = new Socket(InetAddress.getByName(var2), var3);
        this.netManager = new NetworkManager(var4, "Client", this);
        this.playerNameList = new HashMap();
        this.field_35786_c = new ArrayList();
        this.playerPing = 20;
    }

    public void processReadPackets() {
        if (!this.disconnected) {
            this.netManager.processReadPackets();
        }
        this.netManager.wakeThreads();
    }

    @Override
    public void handlePlayerInfo(Packet201PlayerInfo packet201playerinfo) {
        PlayerListStats playerstats = (PlayerListStats)this.playerNameList.get(packet201playerinfo.playerName);
        if (playerstats == null && packet201playerinfo.isConnected) {
            playerstats = new PlayerListStats(packet201playerinfo.playerName);
            this.playerNameList.put(packet201playerinfo.playerName, playerstats);
            this.field_35786_c.add(playerstats);
        }
        if (playerstats != null && !packet201playerinfo.isConnected) {
            this.playerNameList.remove(packet201playerinfo.playerName);
            this.field_35786_c.remove(playerstats);
        }
        if (packet201playerinfo.isConnected && playerstats != null) {
            playerstats.ping = packet201playerinfo.ping;
            this.mc.thePlayer.score = playerstats.score = packet201playerinfo.score;
        }
    }

    @Override
    public void handleLogin(Packet1Login var1) {
        this.mc.playerController = new PlayerControllerMP(this.mc, this);
        this.mc.statFileWriter.readStat(StatList.joinMultiplayerStat, 1);
        this.worldClient = new WorldClient(this, var1.mapSeed, var1.dimension);
        this.worldClient.multiplayerWorld = true;
        this.mc.changeWorld1(this.worldClient);
        this.mc.thePlayer.dimension = var1.dimension;
        this.mc.displayGuiScreen(new GuiDownloadTerrain(this));
        this.mc.thePlayer.entityId = var1.protocolVersion;
        System.out.println("client protocol version: " + Config.protocolVersion);
        System.out.println("client protocol id: " + this.mc.thePlayer.entityId);
    }

    @Override
    public void handlePickupSpawn(Packet21PickupSpawn var1) {
        double var2 = (double)var1.xPosition / 32.0;
        double var4 = (double)var1.yPosition / 32.0;
        double var6 = (double)var1.zPosition / 32.0;
        EntityItem var8 = new EntityItem(this.worldClient, var2, var4, var6, new ItemStack(var1.itemID, var1.count, var1.itemDamage));
        var8.motionX = (double)var1.rotation / 128.0;
        var8.motionY = (double)var1.pitch / 128.0;
        var8.motionZ = (double)var1.roll / 128.0;
        var8.serverPosX = var1.xPosition;
        var8.serverPosY = var1.yPosition;
        var8.serverPosZ = var1.zPosition;
        this.worldClient.func_712_a(var1.entityId, var8);
    }

    @Override
    public void handleVehicleSpawn(Packet23VehicleSpawn var1) {
        double var2 = (double)var1.xPosition / 32.0;
        double var4 = (double)var1.yPosition / 32.0;
        double var6 = (double)var1.zPosition / 32.0;
        Entity var8 = null;
        if (var1.type == 10) {
            var8 = new EntityMinecart(this.worldClient, var2, var4, var6, 0);
        }
        if (var1.type == 11) {
            var8 = new EntityMinecart(this.worldClient, var2, var4, var6, 1);
        }
        if (var1.type == 12) {
            var8 = new EntityMinecart(this.worldClient, var2, var4, var6, 2);
        }
        if (var1.type == 90) {
            var8 = new EntityFish(this.worldClient, var2, var4, var6);
        }
        if (var1.type == 3) {
            var8 = new EntityChair(this.worldClient, var2, var4, var6);
        }
        if (var1.type == 4) {
            EntityPlayerSP var200 = this.mc.thePlayer;
            float playrot = var200.rotationPitch;
            var8 = new SignEntity(this.worldClient, var2, var4, var6, playrot);
        }
        if (var1.type == 51) {
            var8 = new EntityFallingSand(this.worldClient, var2, var4, var6, Block.ashPile.blockID, 0);
        }
        if (var1.type == 52) {
            var8 = new EntityFallingSand(this.worldClient, var2, var4, var6, Block.ashPile.blockID, 1);
        }
        if (var1.type == 53) {
            var8 = new EntityFallingSand(this.worldClient, var2, var4, var6, Block.ashPile.blockID, 2);
        }
        if (var1.type == 54) {
            var8 = new EntityFallingSand(this.worldClient, var2, var4, var6, Block.ashPile.blockID, 3);
        }
        if (var1.type == 55) {
            var8 = new EntityFallingSand(this.worldClient, var2, var4, var6, Block.ashPile.blockID, 4);
        }
        if (var1.type == 56) {
            var8 = new EntityFallingSand(this.worldClient, var2, var4, var6, Block.ashPile.blockID, 5);
        }
        if (var1.type == 57) {
            var8 = new EntityFallingSand(this.worldClient, var2, var4, var6, Block.ashPile.blockID, 6);
        }
        if (var1.type == 58) {
            var8 = new EntityFallingSand(this.worldClient, var2, var4, var6, Block.ashPile.blockID, 7);
        }
        if (var1.type == 30) {
            var8 = new EntityDynamite(this.worldClient, (float)var2, (float)var4, (float)var6);
        }
        if (var1.type == 31) {
            var8 = new EntityTorch(this.worldClient, (float)var2, (float)var4, (float)var6);
        }
        if (var1.type == 32) {
            var8 = new EntityBrick(this.worldClient, (float)var2, (float)var4, (float)var6);
        }
        if (var1.type == 33) {
            var8 = new EntitySpeechBubble(this.worldClient, (float)var2, (float)var4, (float)var6);
        }
        if (var1.type == 60) {
            var8 = new EntityArrow(this.worldClient, var2, var4, var6);
        }
        if (var1.type == 61) {
            var8 = new EntitySnowball(this.worldClient, var2, var4, var6);
        }
        if (var1.type == 63) {
            var8 = new EntityFireball(this.worldClient, var2, var4, var6, (double)var1.field_28047_e / 8000.0, (double)var1.field_28046_f / 8000.0, (double)var1.field_28045_g / 8000.0);
            var1.field_28044_i = 0;
        }
        if (var1.type == 62) {
            var8 = new EntityEgg(this.worldClient, var2, var4, var6);
        }
        if (var1.type == 1) {
            var8 = new EntityBoat(this.worldClient, var2, var4, var6);
        }
        if (var1.type == 50) {
            var8 = new EntityTNTPrimed(this.worldClient, var2, var4, var6);
        }
        if (var1.type == 70) {
            var8 = new EntityFallingSand(this.worldClient, var2, var4, var6, Block.sand.blockID, 0);
        }
        if (var1.type == 71) {
            var8 = new EntityFallingSand(this.worldClient, var2, var4, var6, Block.gravel.blockID, 0);
        }
        if (var1.type == 72) {
            var8 = new EntityFallingSand(this.worldClient, var2, var4, var6, Block.ashBlock.blockID, 0);
        }
        if (var1.type == 69) {
            var8 = new EntityArrowGolden(this.worldClient, var2, var4, var6);
        }
        if (var1.type == 99) {
            var8 = new EntityArrowPurple(this.worldClient, var2, var4, var6);
        }
        if (var8 != null) {
            ((Entity)var8).serverPosX = var1.xPosition;
            ((Entity)var8).serverPosY = var1.yPosition;
            ((Entity)var8).serverPosZ = var1.zPosition;
            ((Entity)var8).rotationYaw = 0.0f;
            ((Entity)var8).rotationPitch = 0.0f;
            ((Entity)var8).entityId = var1.entityId;
            this.worldClient.func_712_a(var1.entityId, var8);
            if (var1.field_28044_i > 0) {
                Entity var9;
                if (var1.type == 60 && (var9 = this.getEntityByID(var1.field_28044_i)) instanceof EntityLiving) {
                    ((EntityArrow)var8).shootingEntity = (EntityLiving)var9;
                }
                ((Entity)var8).setVelocity((double)var1.field_28047_e / 8000.0, (double)var1.field_28046_f / 8000.0, (double)var1.field_28045_g / 8000.0);
            }
        }
    }

    @Override
    public void handleWeather(Packet71Weather var1) {
        double var2 = (double)var1.field_27053_b / 32.0;
        double var4 = (double)var1.field_27057_c / 32.0;
        double var6 = (double)var1.field_27056_d / 32.0;
        EntityLightningBolt var8 = null;
        if (var1.field_27055_e == 1) {
            var8 = new EntityLightningBolt(this.worldClient, var2, var4, var6);
        }
        if (var8 != null) {
            var8.serverPosX = var1.field_27053_b;
            var8.serverPosY = var1.field_27057_c;
            var8.serverPosZ = var1.field_27056_d;
            var8.rotationYaw = 0.0f;
            var8.rotationPitch = 0.0f;
            var8.entityId = var1.field_27054_a;
            this.worldClient.addWeatherEffect(var8);
        }
    }

    @Override
    public void func_21146_a(Packet25EntityPainting var1) {
        EntityPainting var2 = new EntityPainting(this.worldClient, var1.xPosition, var1.yPosition, var1.zPosition, var1.direction, var1.title);
        this.worldClient.func_712_a(var1.entityId, var2);
    }

    @Override
    public void chairSitting(Packet80EntityChair var1) {
        EntityChair var2 = new EntityChair(this.worldClient, var1.xPosition, var1.yPosition, var1.zPosition, var1.direction);
        this.worldClient.func_712_a(var1.entityId, var2);
    }

    @Override
    public void func_6498_a(Packet28EntityVelocity var1) {
        Entity var2 = this.getEntityByID(var1.entityId);
        if (var2 != null) {
            var2.setVelocity((double)var1.motionX / 8000.0, (double)var1.motionY / 8000.0, (double)var1.motionZ / 8000.0);
        }
    }

    @Override
    public void func_21148_a(Packet40EntityMetadata var1) {
        Entity var2 = this.getEntityByID(var1.entityId);
        if (var2 != null && var1.func_21047_b() != null) {
            var2.getDataWatcher().updateWatchedObjectsFromList(var1.func_21047_b());
        }
    }

    @Override
    public void handleCauldron(Packet66Cauldron var1) {
        TileEntity var2;
        if (this.mc.theWorld.blockExists(var1.xPosition, var1.yPosition, var1.zPosition) && (var2 = this.mc.theWorld.getBlockTileEntity(var1.xPosition, var1.yPosition, var1.zPosition)) instanceof TileEntityCauldron) {
            TileEntityCauldron var3 = (TileEntityCauldron)var2;
            var3.curpotion = var1.potionid;
            var3.holdingpotion = var1.hasPotion;
            var3.recipestage = var1.stage;
            var3.y_();
        }
    }

    @Override
    public void handleAnvil(Packet67Anvil var1) {
        TileEntity var2;
        if (this.mc.theWorld.blockExists(var1.xPosition, var1.yPosition, var1.zPosition) && (var2 = this.mc.theWorld.getBlockTileEntity(var1.xPosition, var1.yPosition, var1.zPosition)) instanceof TileEntityAnvil) {
            TileEntityAnvil var3 = (TileEntityAnvil)var2;
            var1.itemdamage = var3.anvilItemStacks[0].getItemDamage();
            var3.y_();
        }
    }

    @Override
    public void handleNamedEntitySpawn(Packet20NamedEntitySpawn var1) {
        double var2 = (double)var1.xPosition / 32.0;
        double var4 = (double)var1.yPosition / 32.0;
        double var6 = (double)var1.zPosition / 32.0;
        float var8 = (float)(var1.rotation * 360) / 256.0f;
        float var9 = (float)(var1.pitch * 360) / 256.0f;
        EntityOtherPlayerMP var10 = new EntityOtherPlayerMP(this.mc.theWorld, var1.name);
        var10.serverPosX = var1.xPosition;
        var10.prevPosX = var10.lastTickPosX = (double)var10.serverPosX;
        var10.serverPosY = var1.yPosition;
        var10.prevPosY = var10.lastTickPosY = (double)var10.serverPosY;
        var10.serverPosZ = var1.zPosition;
        var10.prevPosZ = var10.lastTickPosZ = (double)var10.serverPosZ;
        int var11 = var1.currentItem;
        var10.inventory.mainInventory[var10.inventory.currentItem] = var11 == 0 ? null : new ItemStack(var11, 1, 0);
        var10.setPositionAndRotation(var2, var4, var6, var8, var9);
        this.worldClient.func_712_a(var1.entityId, var10);
    }

    @Override
    public void handleEntityTeleport(Packet34EntityTeleport var1) {
        Entity var2 = this.getEntityByID(var1.entityId);
        if (var2 != null) {
            var2.serverPosX = var1.xPosition;
            var2.serverPosY = var1.yPosition;
            var2.serverPosZ = var1.zPosition;
            double var3 = (double)var2.serverPosX / 32.0;
            double var5 = (double)var2.serverPosY / 32.0 + 0.015625;
            double var7 = (double)var2.serverPosZ / 32.0;
            float var9 = (float)(var1.yaw * 360) / 256.0f;
            float var10 = (float)(var1.pitch * 360) / 256.0f;
            var2.setPositionAndRotation2(var3, var5, var7, var9, var10, 3);
        }
    }

    @Override
    public void handleEntity(Packet30Entity var1) {
        Entity var2 = this.getEntityByID(var1.entityId);
        if (var2 != null) {
            var2.serverPosX += var1.xPosition;
            var2.serverPosY += var1.yPosition;
            var2.serverPosZ += var1.zPosition;
            double var3 = (double)var2.serverPosX / 32.0;
            double var5 = (double)var2.serverPosY / 32.0;
            double var7 = (double)var2.serverPosZ / 32.0;
            float var9 = var1.rotating ? (float)(var1.yaw * 360) / 256.0f : var2.rotationYaw;
            float var10 = var1.rotating ? (float)(var1.pitch * 360) / 256.0f : var2.rotationPitch;
            var2.setPositionAndRotation2(var3, var5, var7, var9, var10, 3);
        }
    }

    @Override
    public void handleDestroyEntity(Packet29DestroyEntity var1) {
        this.worldClient.removeEntityFromWorld(var1.entityId);
    }

    @Override
    public void handleFlying(Packet10Flying var1) {
        EntityPlayerSP var2 = this.mc.thePlayer;
        double var3 = var2.posX;
        double var5 = var2.posY;
        double var7 = var2.posZ;
        float var9 = var2.rotationYaw;
        float var10 = var2.rotationPitch;
        if (var1.moving) {
            var3 = var1.xPosition;
            var5 = var1.yPosition;
            var7 = var1.zPosition;
        }
        if (var1.rotating) {
            var9 = var1.yaw;
            var10 = var1.pitch;
        }
        var2.ySize = 0.0f;
        var2.motionZ = 0.0;
        var2.motionY = 0.0;
        var2.motionX = 0.0;
        var2.setPositionAndRotation(var3, var5, var7, var9, var10);
        var1.xPosition = var2.posX;
        var1.yPosition = var2.boundingBox.minY;
        var1.zPosition = var2.posZ;
        var1.stance = var2.posY;
        this.netManager.addToSendQueue(var1);
        if (!this.field_1210_g) {
            this.mc.thePlayer.prevPosX = this.mc.thePlayer.posX;
            this.mc.thePlayer.prevPosY = this.mc.thePlayer.posY;
            this.mc.thePlayer.prevPosZ = this.mc.thePlayer.posZ;
            this.field_1210_g = true;
            this.mc.displayGuiScreen(null);
        }
    }

    @Override
    public void handlePreChunk(Packet50PreChunk var1) {
        this.worldClient.doPreChunk(var1.xPosition, var1.yPosition, var1.mode);
    }

    @Override
    public void handleMultiBlockChange(Packet52MultiBlockChange var1) {
        Chunk var2 = this.worldClient.getChunkFromChunkCoords(var1.xPosition, var1.zPosition);
        int var3 = var1.xPosition * 16;
        int var4 = var1.zPosition * 16;
        int var5 = 0;
        while (var5 < var1.size) {
            short var6 = var1.coordinateArray[var5];
            int var7 = var1.typeArray[var5] & 0xFF;
            byte var8 = var1.metadataArray[var5];
            int var9 = var6 >> 12 & 0xF;
            int var10 = var6 >> 8 & 0xF;
            int var11 = var6 & 0xFF;
            var2.setBlockIDWithMetadata(var9, var11, var10, var7, var8);
            this.worldClient.func_711_c(var9 + var3, var11, var10 + var4, var9 + var3, var11, var10 + var4);
            this.worldClient.markBlocksDirty(var9 + var3, var11, var10 + var4, var9 + var3, var11, var10 + var4);
            ++var5;
        }
    }

    @Override
    public void handleMapChunk(Packet51MapChunk var1) {
        this.worldClient.func_711_c(var1.xPosition, var1.yPosition, var1.zPosition, var1.xPosition + var1.xSize - 1, var1.yPosition + var1.ySize - 1, var1.zPosition + var1.zSize - 1);
        this.worldClient.setChunkData(var1.xPosition, var1.yPosition, var1.zPosition, var1.xSize, var1.ySize, var1.zSize, var1.chunk);
    }

    @Override
    public void handleBlockChange(Packet53BlockChange var1) {
        this.worldClient.func_714_c(var1.xPosition, var1.yPosition, var1.zPosition, var1.type, var1.metadata);
    }

    @Override
    public void handleKickDisconnect(Packet255KickDisconnect var1) {
        this.netManager.networkShutdown("disconnect.kicked", new Object[0]);
        this.disconnected = true;
        this.mc.changeWorld1(null);
        this.mc.displayGuiScreen(new GuiConnectFailed("disconnect.disconnected", "disconnect.genericReason", var1.reason));
    }

    @Override
    public void handleErrorMessage(String var1, Object[] var2) {
        if (!this.disconnected) {
            this.disconnected = true;
            this.mc.changeWorld1(null);
            this.mc.displayGuiScreen(new GuiConnectFailed("disconnect.lost", var1, var2));
        }
    }

    public void func_28117_a(Packet var1) {
        if (!this.disconnected) {
            this.netManager.addToSendQueue(var1);
            this.netManager.func_28142_c();
        }
    }

    public void addToSendQueue(Packet var1) {
        if (!this.disconnected) {
            this.netManager.addToSendQueue(var1);
        }
    }

    @Override
    public void handleCollect(Packet22Collect var1) {
        Entity var2 = this.getEntityByID(var1.collectedEntityId);
        EntityLiving var3 = (EntityLiving)this.getEntityByID(var1.collectorEntityId);
        if (var3 == null) {
            var3 = this.mc.thePlayer;
        }
        if (var2 != null) {
            this.worldClient.playSoundAtEntity(var2, "random.pop", 0.2f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            this.mc.effectRenderer.addEffect(new EntityPickupFX(this.mc.theWorld, var2, var3, -0.5f));
            this.worldClient.removeEntityFromWorld(var1.collectedEntityId);
        }
    }

    @Override
    public void handleChat(Packet3Chat var1) {
        this.mc.ingameGUI.addChatMessageTranslateCommand(var1.message);
    }

    @Override
    public void handlePotion(Packet64Potion var1) {
        Effect.applyEffect(this.mc.thePlayer, var1.effectid, var1.effectlevel, var1.effectduration);
    }

    @Override
    public void handleEffects(Packet68Effects var1) {
        int effecttimers = var1.effecttimer.length / 4;
        int i = 0;
        while (i < effecttimers) {
            this.mc.thePlayer.effectlevel[i] = var1.effectlevel[i];
            this.mc.thePlayer.effecttimers[i] = (var1.effecttimer[i * 4] + 256) % 256 + ((var1.effecttimer[i * 4 + 1] + 256) % 256 << 8) + ((var1.effecttimer[i * 4 + 2] + 256) % 256 << 16) + ((var1.effecttimer[i * 4 + 3] + 256) % 256 << 24);
            ++i;
        }
    }

    @Override
    public void handlePotion2(Packet65Potion2 var1) {
        Effect.applyEffect(this.mc.thePlayer, var1.effectid, var1.effectlevel, var1.effectduration);
        Effect.applyEffect(this.mc.thePlayer, var1.effectid2, var1.effectlevel2, var1.effectduration2);
    }

    @Override
    public void handleCommandList(Packet252CommandList var1) {
    }

    @Override
    public void handleArmAnimation(Packet18Animation var1) {
        Entity var2 = this.getEntityByID(var1.entityId);
        if (var2 != null) {
            if (var1.animate == 1) {
                EntityPlayer var3 = (EntityPlayer)var2;
                var3.swingItem();
            } else if (var1.animate == 2) {
                var2.performHurtAnimation();
            } else if (var1.animate == 3) {
                EntityPlayer var3 = (EntityPlayer)var2;
                var3.wakeUpPlayer(false, false, false);
            } else if (var1.animate == 4) {
                EntityPlayer var3 = (EntityPlayer)var2;
                var3.func_6420_o();
            }
        }
    }

    @Override
    public void func_22186_a(Packet17Sleep var1) {
        Entity var2 = this.getEntityByID(var1.field_22045_a);
        if (var2 != null && var1.field_22046_e == 0) {
            EntityPlayer var3 = (EntityPlayer)var2;
            var3.sleepInBedAt(var1.field_22044_b, var1.field_22048_c, var1.field_22047_d);
        }
    }

    @Override
    public void handleHandshake(Packet2Handshake var1) {
        if (var1.username.equals("-")) {
            this.addToSendQueue(new Packet1Login(this.mc.session.username, Config.protocolVersion));
        } else {
            try {
                URL var2 = new URL("http://session.minecraft.net/game/joinserver.jsp?user=" + this.mc.session.username + "&sessionId=" + this.mc.session.sessionId + "&serverId=" + var1.username);
                BufferedReader var3 = new BufferedReader(new InputStreamReader(var2.openStream()));
                String var4 = var3.readLine();
                var3.close();
                if (var4.equalsIgnoreCase("ok")) {
                    this.addToSendQueue(new Packet1Login(this.mc.session.username, Config.protocolVersion));
                } else {
                    this.netManager.networkShutdown("disconnect.loginFailedInfo", var4);
                }
            }
            catch (Exception var5) {
                var5.printStackTrace();
                this.netManager.networkShutdown("disconnect.genericReason", "Internal client error: " + var5.toString());
            }
        }
    }

    public void disconnect() {
        this.disconnected = true;
        this.netManager.wakeThreads();
        this.netManager.networkShutdown("disconnect.closed", new Object[0]);
    }

    @Override
    public void handleMobSpawn(Packet24MobSpawn var1) {
        double var2 = (double)var1.xPosition / 32.0;
        double var4 = (double)var1.yPosition / 32.0;
        double var6 = (double)var1.zPosition / 32.0;
        float var8 = (float)(var1.yaw * 360) / 256.0f;
        float var9 = (float)(var1.pitch * 360) / 256.0f;
        EntityLiving var10 = (EntityLiving)EntityList.createEntity(var1.type, this.mc.theWorld);
        var10.serverPosX = var1.xPosition;
        var10.serverPosY = var1.yPosition;
        var10.serverPosZ = var1.zPosition;
        var10.entityId = var1.entityId;
        var10.setPositionAndRotation(var2, var4, var6, var8, var9);
        var10.isMultiplayerEntity = true;
        this.worldClient.func_712_a(var1.entityId, var10);
        List var11 = var1.getMetadata();
        if (var11 != null) {
            var10.getDataWatcher().updateWatchedObjectsFromList(var11);
        }
    }

    @Override
    public void handleUpdateTime(Packet4UpdateTime var1) {
        this.mc.theWorld.setWorldTime(var1.time);
    }

    @Override
    public void handleSpawnPosition(Packet6SpawnPosition var1) {
        this.mc.thePlayer.setPlayerSpawnCoordinate(new ChunkCoordinates(var1.xPosition, var1.yPosition, var1.zPosition));
        this.mc.theWorld.getWorldInfo().setSpawn(var1.xPosition, var1.yPosition, var1.zPosition);
    }

    @Override
    public void func_6497_a(Packet39AttachEntity var1) {
        Entity var2 = this.getEntityByID(var1.entityId);
        Entity var3 = this.getEntityByID(var1.vehicleEntityId);
        if (var1.entityId == this.mc.thePlayer.entityId) {
            var2 = this.mc.thePlayer;
        }
        if (var2 != null) {
            var2.mountEntity(var3);
        }
    }

    @Override
    public void func_9447_a(Packet38EntityStatus var1) {
        Entity var2 = this.getEntityByID(var1.entityId);
        if (var2 != null) {
            var2.handleHealthUpdate(var1.entityStatus);
        }
    }

    private Entity getEntityByID(int var1) {
        return var1 == this.mc.thePlayer.entityId ? this.mc.thePlayer : this.worldClient.func_709_b(var1);
    }

    @Override
    public void handleHealth(Packet8UpdateHealth var1) {
        this.mc.thePlayer.setHealth(var1.healthMP);
    }

    @Override
    public void func_9448_a(Packet9Respawn var1) {
        if (var1.field_28048_a != this.mc.thePlayer.dimension) {
            this.field_1210_g = false;
            this.worldClient = new WorldClient(this, this.worldClient.getWorldInfo().getRandomSeed(), var1.field_28048_a);
            this.worldClient.multiplayerWorld = true;
            this.mc.changeWorld1(this.worldClient);
            this.mc.thePlayer.dimension = var1.field_28048_a;
            this.mc.displayGuiScreen(new GuiDownloadTerrain(this));
        }
        this.mc.respawn(true, var1.field_28048_a);
    }

    @Override
    public void func_12245_a(Packet60Explosion var1) {
        Explosion var2 = new Explosion(this.mc.theWorld, null, var1.explosionX, var1.explosionY, var1.explosionZ, var1.explosionSize);
        var2.destroyedBlockPositions = var1.destroyedBlockPositions;
        var2.doExplosionB(true, false);
    }

    @Override
    public void func_20087_a(Packet100OpenWindow var1) {
        if (var1.inventoryType == 0) {
            InventoryBasic var2 = new InventoryBasic(var1.windowTitle, var1.slotsCount);
            this.mc.thePlayer.displayGUIChest(var2);
            this.mc.thePlayer.craftingInventory.windowId = var1.windowId;
        } else if (var1.inventoryType == 2) {
            TileEntityFurnace var3 = new TileEntityFurnace();
            this.mc.thePlayer.displayGUIFurnace(var3);
            this.mc.thePlayer.craftingInventory.windowId = var1.windowId;
        } else if (var1.inventoryType == 3) {
            TileEntityDispenser var4 = new TileEntityDispenser();
            this.mc.thePlayer.displayGUIDispenser(var4);
            this.mc.thePlayer.craftingInventory.windowId = var1.windowId;
        } else if (var1.inventoryType == 4) {
            TileEntityBlastFurnace var6 = new TileEntityBlastFurnace();
            this.mc.thePlayer.displayGUIBlastFurnace(var6);
            this.mc.thePlayer.craftingInventory.windowId = var1.windowId;
        } else if (var1.inventoryType == 5) {
            TileEntityAnvil var6 = new TileEntityAnvil();
            this.mc.thePlayer.displayGUIAnvil(var6, var6.xCoord, var6.yCoord, var6.zCoord);
            this.mc.thePlayer.craftingInventory.windowId = var1.windowId;
        } else if (var1.inventoryType == 1) {
            EntityPlayerSP var5 = this.mc.thePlayer;
            this.mc.thePlayer.displayWorkbenchGUI(MathHelper.floor_double(var5.posX), MathHelper.floor_double(var5.posY), MathHelper.floor_double(var5.posZ));
            this.mc.thePlayer.craftingInventory.windowId = var1.windowId;
        }
    }

    @Override
    public void func_20088_a(Packet103SetSlot var1) {
        if (var1.windowId == -1) {
            this.mc.thePlayer.inventory.setItemStack(var1.myItemStack);
        } else if (var1.windowId == 0 && var1.itemSlot >= 36 && var1.itemSlot < 45) {
            ItemStack var2 = this.mc.thePlayer.inventorySlots.getSlot(var1.itemSlot).getStack();
            if (var1.myItemStack != null && (var2 == null || var2.stackSize < var1.myItemStack.stackSize)) {
                var1.myItemStack.animationsToGo = 5;
            }
            this.mc.thePlayer.inventorySlots.putStackInSlot(var1.itemSlot, var1.myItemStack);
        } else if (var1.windowId == this.mc.thePlayer.craftingInventory.windowId) {
            this.mc.thePlayer.craftingInventory.putStackInSlot(var1.itemSlot, var1.myItemStack);
        }
    }

    @Override
    public void func_20089_a(Packet106Transaction var1) {
        Container var2 = null;
        if (var1.windowId == 0) {
            var2 = this.mc.thePlayer.inventorySlots;
        } else if (var1.windowId == this.mc.thePlayer.craftingInventory.windowId) {
            var2 = this.mc.thePlayer.craftingInventory;
        }
        if (var2 != null) {
            if (var1.field_20030_c) {
                var2.func_20113_a(var1.field_20028_b);
            } else {
                var2.func_20110_b(var1.field_20028_b);
                this.addToSendQueue(new Packet106Transaction(var1.windowId, var1.field_20028_b, true));
            }
        }
    }

    @Override
    public void func_20094_a(Packet104WindowItems var1) {
        if (var1.windowId == 0) {
            this.mc.thePlayer.inventorySlots.putStacksInSlots(var1.itemStack);
        } else if (var1.windowId == this.mc.thePlayer.craftingInventory.windowId) {
            this.mc.thePlayer.craftingInventory.putStacksInSlots(var1.itemStack);
        }
    }

    @Override
    public void handleSignUpdate(Packet130UpdateSign var1) {
        TileEntity var2;
        if (this.mc.theWorld.blockExists(var1.xPosition, var1.yPosition, var1.zPosition) && (var2 = this.mc.theWorld.getBlockTileEntity(var1.xPosition, var1.yPosition, var1.zPosition)) instanceof TileEntitySign) {
            TileEntitySign var3 = (TileEntitySign)var2;
            int var4 = 0;
            while (var4 < 4) {
                var3.signText[var4] = var1.signLines[var4];
                ++var4;
            }
            var3.y_();
        }
    }

    @Override
    public void func_20090_a(Packet105UpdateProgressbar var1) {
        this.registerPacket(var1);
        if (this.mc.thePlayer.craftingInventory != null && this.mc.thePlayer.craftingInventory.windowId == var1.windowId) {
            this.mc.thePlayer.craftingInventory.func_20112_a(var1.progressBar, var1.progressBarValue);
        }
    }

    @Override
    public void handlePlayerInventory(Packet5PlayerInventory var1) {
        Entity var2 = this.getEntityByID(var1.entityID);
        if (var2 != null) {
            var2.outfitWithItem(var1.slot, var1.itemID, var1.itemDamage);
        }
    }

    @Override
    public void func_20092_a(Packet101CloseWindow var1) {
        this.mc.thePlayer.closeScreen();
    }

    @Override
    public void handleNotePlay(Packet54PlayNoteBlock var1) {
        this.mc.theWorld.playNoteAt(var1.xLocation, var1.yLocation, var1.zLocation, var1.instrumentType, var1.pitch);
    }

    @Override
    public void func_25118_a(Packet70Bed var1) {
        int var2 = var1.bedState;
        if (var2 >= 0 && var2 < Packet70Bed.bedChat.length && Packet70Bed.bedChat[var2] != null) {
            this.mc.thePlayer.addChatMessage(Packet70Bed.bedChat[var2]);
        }
        if (var2 == 1) {
            this.worldClient.getWorldInfo().setRaining(true);
            this.worldClient.func_27158_h(1.0f);
        } else if (var2 == 2) {
            this.worldClient.getWorldInfo().setRaining(false);
            this.worldClient.func_27158_h(0.0f);
        }
    }

    @Override
    public void func_28116_a(Packet131MapData var1) {
        if (var1.field_28055_a == Item.mapItem.itemID) {
            ItemMap.func_28013_a(var1.field_28054_b, this.mc.theWorld).func_28171_a(var1.field_28056_c);
        } else {
            System.out.println("Unknown itemid: " + var1.field_28054_b);
        }
    }

    @Override
    public void func_28115_a(Packet61DoorChange var1) {
        this.mc.theWorld.func_28106_e(var1.field_28050_a, var1.field_28053_c, var1.field_28052_d, var1.field_28051_e, var1.field_28049_b);
    }

    @Override
    public void func_27245_a(Packet200Statistic var1) {
        ((EntityClientPlayerMP)this.mc.thePlayer).func_27027_b(StatList.func_27361_a(var1.field_27052_a), var1.field_27051_b);
    }

    @Override
    public boolean isServerHandler() {
        return false;
    }
}

