/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client.packets;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.src.client.CompressedStreamTools;
import net.minecraft.src.client.packets.NetHandler;
import net.minecraft.src.client.packets.Packet0KeepAlive;
import net.minecraft.src.client.packets.Packet100OpenWindow;
import net.minecraft.src.client.packets.Packet101CloseWindow;
import net.minecraft.src.client.packets.Packet102WindowClick;
import net.minecraft.src.client.packets.Packet103SetSlot;
import net.minecraft.src.client.packets.Packet104WindowItems;
import net.minecraft.src.client.packets.Packet105UpdateProgressbar;
import net.minecraft.src.client.packets.Packet106Transaction;
import net.minecraft.src.client.packets.Packet10Flying;
import net.minecraft.src.client.packets.Packet11PlayerPosition;
import net.minecraft.src.client.packets.Packet12PlayerLook;
import net.minecraft.src.client.packets.Packet130UpdateSign;
import net.minecraft.src.client.packets.Packet131MapData;
import net.minecraft.src.client.packets.Packet13PlayerLookMove;
import net.minecraft.src.client.packets.Packet14BlockDig;
import net.minecraft.src.client.packets.Packet15Place;
import net.minecraft.src.client.packets.Packet16BlockItemSwitch;
import net.minecraft.src.client.packets.Packet17Sleep;
import net.minecraft.src.client.packets.Packet18Animation;
import net.minecraft.src.client.packets.Packet19EntityAction;
import net.minecraft.src.client.packets.Packet1Login;
import net.minecraft.src.client.packets.Packet200Statistic;
import net.minecraft.src.client.packets.Packet201PlayerInfo;
import net.minecraft.src.client.packets.Packet20NamedEntitySpawn;
import net.minecraft.src.client.packets.Packet21PickupSpawn;
import net.minecraft.src.client.packets.Packet22Collect;
import net.minecraft.src.client.packets.Packet23VehicleSpawn;
import net.minecraft.src.client.packets.Packet24MobSpawn;
import net.minecraft.src.client.packets.Packet252CommandList;
import net.minecraft.src.client.packets.Packet254ServerPing;
import net.minecraft.src.client.packets.Packet255KickDisconnect;
import net.minecraft.src.client.packets.Packet25EntityPainting;
import net.minecraft.src.client.packets.Packet27Position;
import net.minecraft.src.client.packets.Packet28EntityVelocity;
import net.minecraft.src.client.packets.Packet29DestroyEntity;
import net.minecraft.src.client.packets.Packet2Handshake;
import net.minecraft.src.client.packets.Packet30Entity;
import net.minecraft.src.client.packets.Packet31RelEntityMove;
import net.minecraft.src.client.packets.Packet32EntityLook;
import net.minecraft.src.client.packets.Packet33RelEntityMoveLook;
import net.minecraft.src.client.packets.Packet34EntityTeleport;
import net.minecraft.src.client.packets.Packet38EntityStatus;
import net.minecraft.src.client.packets.Packet39AttachEntity;
import net.minecraft.src.client.packets.Packet3Chat;
import net.minecraft.src.client.packets.Packet40EntityMetadata;
import net.minecraft.src.client.packets.Packet4UpdateTime;
import net.minecraft.src.client.packets.Packet50PreChunk;
import net.minecraft.src.client.packets.Packet51MapChunk;
import net.minecraft.src.client.packets.Packet52MultiBlockChange;
import net.minecraft.src.client.packets.Packet53BlockChange;
import net.minecraft.src.client.packets.Packet54PlayNoteBlock;
import net.minecraft.src.client.packets.Packet5PlayerInventory;
import net.minecraft.src.client.packets.Packet60Explosion;
import net.minecraft.src.client.packets.Packet61DoorChange;
import net.minecraft.src.client.packets.Packet64Potion;
import net.minecraft.src.client.packets.Packet65Potion2;
import net.minecraft.src.client.packets.Packet66Cauldron;
import net.minecraft.src.client.packets.Packet67Anvil;
import net.minecraft.src.client.packets.Packet68Effects;
import net.minecraft.src.client.packets.Packet6SpawnPosition;
import net.minecraft.src.client.packets.Packet70Bed;
import net.minecraft.src.client.packets.Packet71Weather;
import net.minecraft.src.client.packets.Packet7UseEntity;
import net.minecraft.src.client.packets.Packet80EntityChair;
import net.minecraft.src.client.packets.Packet8UpdateHealth;
import net.minecraft.src.client.packets.Packet9Respawn;
import net.minecraft.src.client.packets.PacketCounter;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.nbt.NBTTagCompound;

public abstract class Packet {
    private static Map packetIdToClassMap = new HashMap();
    private static Map packetClassToIdMap = new HashMap();
    private static Set clientPacketIdList = new HashSet();
    private static Set serverPacketIdList = new HashSet();
    public final long creationTimeMillis = System.currentTimeMillis();
    public boolean isChunkDataPacket = false;
    private static HashMap packetStats;
    private static int totalPacketsCount;

    static {
        Packet.addIdClassMapping(0, true, true, Packet0KeepAlive.class);
        Packet.addIdClassMapping(1, true, true, Packet1Login.class);
        Packet.addIdClassMapping(2, true, true, Packet2Handshake.class);
        Packet.addIdClassMapping(3, true, true, Packet3Chat.class);
        Packet.addIdClassMapping(4, true, false, Packet4UpdateTime.class);
        Packet.addIdClassMapping(5, true, false, Packet5PlayerInventory.class);
        Packet.addIdClassMapping(6, true, false, Packet6SpawnPosition.class);
        Packet.addIdClassMapping(7, false, true, Packet7UseEntity.class);
        Packet.addIdClassMapping(8, true, false, Packet8UpdateHealth.class);
        Packet.addIdClassMapping(9, true, true, Packet9Respawn.class);
        Packet.addIdClassMapping(10, true, true, Packet10Flying.class);
        Packet.addIdClassMapping(11, true, true, Packet11PlayerPosition.class);
        Packet.addIdClassMapping(12, true, true, Packet12PlayerLook.class);
        Packet.addIdClassMapping(13, true, true, Packet13PlayerLookMove.class);
        Packet.addIdClassMapping(14, false, true, Packet14BlockDig.class);
        Packet.addIdClassMapping(15, false, true, Packet15Place.class);
        Packet.addIdClassMapping(16, false, true, Packet16BlockItemSwitch.class);
        Packet.addIdClassMapping(17, true, false, Packet17Sleep.class);
        Packet.addIdClassMapping(18, true, true, Packet18Animation.class);
        Packet.addIdClassMapping(19, false, true, Packet19EntityAction.class);
        Packet.addIdClassMapping(20, true, false, Packet20NamedEntitySpawn.class);
        Packet.addIdClassMapping(21, true, false, Packet21PickupSpawn.class);
        Packet.addIdClassMapping(22, true, false, Packet22Collect.class);
        Packet.addIdClassMapping(23, true, false, Packet23VehicleSpawn.class);
        Packet.addIdClassMapping(24, true, false, Packet24MobSpawn.class);
        Packet.addIdClassMapping(25, true, false, Packet25EntityPainting.class);
        Packet.addIdClassMapping(27, false, true, Packet27Position.class);
        Packet.addIdClassMapping(28, true, false, Packet28EntityVelocity.class);
        Packet.addIdClassMapping(29, true, false, Packet29DestroyEntity.class);
        Packet.addIdClassMapping(30, true, false, Packet30Entity.class);
        Packet.addIdClassMapping(31, true, false, Packet31RelEntityMove.class);
        Packet.addIdClassMapping(32, true, false, Packet32EntityLook.class);
        Packet.addIdClassMapping(33, true, false, Packet33RelEntityMoveLook.class);
        Packet.addIdClassMapping(34, true, false, Packet34EntityTeleport.class);
        Packet.addIdClassMapping(38, true, false, Packet38EntityStatus.class);
        Packet.addIdClassMapping(39, true, false, Packet39AttachEntity.class);
        Packet.addIdClassMapping(40, true, false, Packet40EntityMetadata.class);
        Packet.addIdClassMapping(50, true, false, Packet50PreChunk.class);
        Packet.addIdClassMapping(51, true, false, Packet51MapChunk.class);
        Packet.addIdClassMapping(52, true, false, Packet52MultiBlockChange.class);
        Packet.addIdClassMapping(53, true, false, Packet53BlockChange.class);
        Packet.addIdClassMapping(54, true, false, Packet54PlayNoteBlock.class);
        Packet.addIdClassMapping(60, true, false, Packet60Explosion.class);
        Packet.addIdClassMapping(61, true, false, Packet61DoorChange.class);
        Packet.addIdClassMapping(64, true, false, Packet64Potion.class);
        Packet.addIdClassMapping(65, true, false, Packet65Potion2.class);
        Packet.addIdClassMapping(66, true, true, Packet66Cauldron.class);
        Packet.addIdClassMapping(67, true, true, Packet67Anvil.class);
        Packet.addIdClassMapping(68, true, false, Packet68Effects.class);
        Packet.addIdClassMapping(70, true, false, Packet70Bed.class);
        Packet.addIdClassMapping(71, true, false, Packet71Weather.class);
        Packet.addIdClassMapping(80, true, false, Packet80EntityChair.class);
        Packet.addIdClassMapping(100, true, false, Packet100OpenWindow.class);
        Packet.addIdClassMapping(101, true, true, Packet101CloseWindow.class);
        Packet.addIdClassMapping(102, false, true, Packet102WindowClick.class);
        Packet.addIdClassMapping(103, true, false, Packet103SetSlot.class);
        Packet.addIdClassMapping(104, true, false, Packet104WindowItems.class);
        Packet.addIdClassMapping(105, true, false, Packet105UpdateProgressbar.class);
        Packet.addIdClassMapping(106, true, true, Packet106Transaction.class);
        Packet.addIdClassMapping(130, true, true, Packet130UpdateSign.class);
        Packet.addIdClassMapping(131, true, false, Packet131MapData.class);
        Packet.addIdClassMapping(200, true, false, Packet200Statistic.class);
        Packet.addIdClassMapping(201, true, false, Packet201PlayerInfo.class);
        Packet.addIdClassMapping(252, true, true, Packet252CommandList.class);
        Packet.addIdClassMapping(254, false, true, Packet254ServerPing.class);
        Packet.addIdClassMapping(255, true, true, Packet255KickDisconnect.class);
        packetStats = new HashMap();
        totalPacketsCount = 0;
    }

    static void addIdClassMapping(int var0, boolean var1, boolean var2, Class var3) {
        if (packetIdToClassMap.containsKey(var0)) {
            throw new IllegalArgumentException("Duplicate packet id:" + var0);
        }
        if (packetClassToIdMap.containsKey(var3)) {
            throw new IllegalArgumentException("Duplicate packet class:" + var3);
        }
        packetIdToClassMap.put(var0, var3);
        packetClassToIdMap.put(var3, var0);
        if (var1) {
            clientPacketIdList.add(var0);
        }
        if (var2) {
            serverPacketIdList.add(var0);
        }
    }

    public static Packet getNewPacket(int var0) {
        try {
            Class var1 = (Class)packetIdToClassMap.get(var0);
            return var1 == null ? null : (Packet)var1.newInstance();
        }
        catch (Exception var2) {
            var2.printStackTrace();
            System.out.println("Skipping packet with id " + var0);
            return null;
        }
    }

    public final int getPacketId() {
        return (Integer)packetClassToIdMap.get(this.getClass());
    }

    protected ItemStack func_40187_b(DataInputStream datainputstream) throws IOException {
        ItemStack itemstack = null;
        short word0 = datainputstream.readShort();
        if (word0 >= 0) {
            byte byte0 = datainputstream.readByte();
            short word1 = datainputstream.readShort();
            itemstack = new ItemStack(word0, (int)byte0, (int)word1);
            if (Item.itemsList[word0].isDamagable()) {
                itemstack.field_40715_d = this.func_40186_c(datainputstream);
            }
        }
        return itemstack;
    }

    protected NBTTagCompound func_40186_c(DataInputStream datainputstream) throws IOException {
        short word0 = datainputstream.readShort();
        if (word0 < 0) {
            return null;
        }
        byte[] abyte0 = new byte[word0];
        datainputstream.readFully(abyte0);
        return CompressedStreamTools.func_40592_a(abyte0);
    }

    protected void writeItemStack(ItemStack itemstack, DataOutputStream dataoutputstream) throws IOException {
        if (itemstack == null) {
            dataoutputstream.writeShort(-1);
        } else {
            dataoutputstream.writeShort(itemstack.itemID);
            dataoutputstream.writeByte(itemstack.stackSize);
            dataoutputstream.writeShort(itemstack.getItemDamage());
            if (itemstack.getItem().isDamagable()) {
                this.func_40189_a(itemstack.field_40715_d, dataoutputstream);
            }
        }
    }

    protected void func_40189_a(NBTTagCompound nbttagcompound, DataOutputStream dataoutputstream) throws IOException {
        if (nbttagcompound == null) {
            dataoutputstream.writeShort(-1);
        } else {
            byte[] abyte0 = CompressedStreamTools.func_40591_a(nbttagcompound);
            dataoutputstream.writeShort((short)abyte0.length);
            dataoutputstream.write(abyte0);
        }
    }

    public static Packet readPacket(DataInputStream var0, boolean var1) throws IOException {
        int var6;
        Packet var3;
        block6: {
            var3 = null;
            try {
                var6 = var0.read();
                if (var6 != -1) break block6;
                return null;
            }
            catch (EOFException var5) {
                System.out.println("Reached end of stream");
                return null;
            }
        }
        if (var1 && !serverPacketIdList.contains(var6) || !var1 && !clientPacketIdList.contains(var6)) {
            throw new IOException("Bad packet id " + var6);
        }
        var3 = Packet.getNewPacket(var6);
        if (var3 == null) {
            throw new IOException("Bad packet id " + var6);
        }
        var3.readPacketData(var0);
        PacketCounter var4 = (PacketCounter)packetStats.get(var6);
        if (var4 == null) {
            var4 = new PacketCounter(null);
            packetStats.put(var6, var4);
        }
        var4.addPacket(var3.getPacketSize());
        int cfr_ignored_0 = ++totalPacketsCount % 1000;
        return var3;
    }

    public static void writePacket(Packet var0, DataOutputStream var1) throws IOException {
        var1.write(var0.getPacketId());
        var0.writePacketData(var1);
    }

    public static void writeString(String var0, DataOutputStream var1) throws IOException {
        if (var0.length() > Short.MAX_VALUE) {
            throw new IOException("String too big");
        }
        var1.writeShort(var0.length());
        var1.writeChars(var0);
    }

    public static String readString(DataInputStream var0, int var1) throws IOException {
        int var2 = var0.readShort();
        if (var2 > var1) {
            throw new IOException("Received string length longer than maximum allowed (" + var2 + " > " + var1 + ")");
        }
        if (var2 < 0) {
            throw new IOException("Received string length is less than zero! Weird string!");
        }
        StringBuilder var3 = new StringBuilder();
        int var4 = 0;
        while (var4 < var2) {
            var3.append(var0.readChar());
            ++var4;
        }
        return var3.toString();
    }

    public abstract void readPacketData(DataInputStream var1) throws IOException;

    public abstract void writePacketData(DataOutputStream var1) throws IOException;

    public abstract void processPacket(NetHandler var1);

    public abstract int getPacketSize();
}

