/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client.packets;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.src.client.packets.NetHandler;
import net.minecraft.src.client.packets.Packet;

public class Packet201PlayerInfo
extends Packet {
    public String playerName;
    public boolean isConnected;
    public int ping;
    public long score;

    @Override
    public void readPacketData(DataInputStream datainputstream) throws IOException {
        this.playerName = Packet201PlayerInfo.readString(datainputstream, 16);
        this.isConnected = datainputstream.readByte() != 0;
        this.ping = datainputstream.readShort();
        this.score = datainputstream.readLong();
    }

    @Override
    public void writePacketData(DataOutputStream dataoutputstream) throws IOException {
        Packet201PlayerInfo.writeString(this.playerName, dataoutputstream);
        dataoutputstream.writeByte(this.isConnected ? 1 : 0);
        dataoutputstream.writeShort(this.ping);
        dataoutputstream.writeLong(this.score);
    }

    @Override
    public void processPacket(NetHandler nethandler) {
        nethandler.handlePlayerInfo(this);
    }

    @Override
    public int getPacketSize() {
        return this.playerName.length() + 2 + 1 + 2 + 8;
    }
}

