/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client.player;

import net.minecraft.client.Minecraft;
import net.minecraft.src.client.Session;
import net.minecraft.src.client.gui.Container;
import net.minecraft.src.client.gui.GuiAnvil;
import net.minecraft.src.client.gui.GuiBlastFurnace;
import net.minecraft.src.client.gui.GuiChest;
import net.minecraft.src.client.gui.GuiCrafting;
import net.minecraft.src.client.gui.GuiDispenser;
import net.minecraft.src.client.gui.GuiEditSign;
import net.minecraft.src.client.gui.GuiFurnace;
import net.minecraft.src.client.inventory.IInventory;
import net.minecraft.src.client.particle.EntityPickupFX;
import net.minecraft.src.client.player.MovementInput;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.achievements.Achievement;
import net.minecraft.src.game.achievements.AchievementList;
import net.minecraft.src.game.block.tileentity.TileEntityAnvil;
import net.minecraft.src.game.block.tileentity.TileEntityBlastFurnace;
import net.minecraft.src.game.block.tileentity.TileEntityDispenser;
import net.minecraft.src.game.block.tileentity.TileEntityFurnace;
import net.minecraft.src.game.block.tileentity.TileEntitySign;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.level.chunk.Chunk;
import net.minecraft.src.game.nbt.NBTTagCompound;
import net.minecraft.src.game.stats.StatBase;
import org.lwjgl.input.Keyboard;

public class EntityPlayerSP
extends EntityPlayer {
    public boolean isInSlimeChunk = false;
    public MovementInput movementInput;
    public Minecraft mc;
    public Container inventoryContainer;
    public boolean isRunning = false;
    int i = 0;
    int j = 0;
    boolean flagFovCheck = false;
    float sensitivityInMemory;
    public float renderArmYaw;
    public float renderArmPitch;
    public float prevRenderArmYaw;
    public float prevRenderArmPitch;

    public EntityPlayerSP(Minecraft var1, World var2, Session var3, int var4) {
        super(var2);
        this.mc = var1;
        this.dimension = var4;
        if (var3 != null && var3.username != null && var3.username.length() > 0) {
            this.skinUrl = "http://www.betacraft.uk/MinecraftSkins/" + var3.username + ".png";
        }
        this.sensitivityInMemory = this.mc.gameSettings.mouseSensitivity;
        this.username = var3.username;
        this.prevRenderArmYaw = this.renderArmYaw;
        this.prevRenderArmPitch = this.renderArmPitch;
        this.renderArmPitch = (float)((double)this.renderArmPitch + (double)(this.rotationPitch - this.renderArmPitch) * 0.5);
        this.renderArmYaw = (float)((double)this.renderArmYaw + (double)(this.rotationYaw - this.renderArmYaw) * 0.5);
    }

    @Override
    public void moveEntity(double var1, double var3, double var5) {
        super.moveEntity(var1, var3, var5);
    }

    @Override
    public void updatePlayerActionState() {
        super.updatePlayerActionState();
        this.moveStrafing = this.movementInput.moveStrafe;
        this.moveForward = this.movementInput.moveForward;
        this.isJumping = this.movementInput.jump;
        this.isRunning = false;
    }

    private int getMaxStamina() {
        return 100;
    }

    @Override
    public void onLivingUpdate() {
        Chunk chunk;
        if (Keyboard.isKeyDown((int)46) && this.mc.currentScreen == null) {
            if (!this.flagFovCheck) {
                this.sensitivityInMemory = this.mc.gameSettings.mouseSensitivity;
                this.mc.gameSettings.smoothZoomCamera = true;
                this.flagFovCheck = true;
                this.zoomFov = 50;
            }
            this.mc.gameSettings.mouseSensitivity = 0.325f;
        } else {
            this.mc.gameSettings.mouseSensitivity = this.sensitivityInMemory;
            this.mc.gameSettings.smoothZoomCamera = false;
            this.flagFovCheck = false;
            this.zoomFov = 0;
        }
        this.staminaNegation = this.stamina / 2 % 5 * 9;
        if (this.stamina <= 0) {
            this.exhausted = true;
            if (this.i != 1) {
                this.i = 1;
            }
        }
        if (this.i == 1) {
            this.i = 0;
            int cfr_ignored_0 = this.worldObj.difficultySetting;
        }
        if (this.stamina < this.getMaxStamina() && (!this.isRunning || this.exhausted) && (this.worldObj.difficultySetting == 0 || this.worldObj.difficultySetting == 1) || this.capabilities.allowFlying) {
            ++this.stamina;
        }
        if (this.stamina >= this.getMaxStamina()) {
            this.exhausted = false;
        }
        if (this.stamina > this.getMaxStamina()) {
            this.stamina = this.getMaxStamina();
        }
        if (!this.exhausted && this.isRunning && this.worldObj.difficultySetting != 3 && (this.movementInput.moveForward > 0.0f || this.movementInput.moveStrafe > 0.0f)) {
            ++this.j;
            if (this.j > 1) {
                --this.stamina;
                this.j = 0;
            }
        }
        if (this.worldObj.difficultySetting == 3) {
            this.stamina = 0;
        }
        this.isInSlimeChunk = (chunk = this.worldObj.getChunkFromBlockCoords(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posZ))).getRandomWithSeed(987234911L).nextInt(10) == 0;
        if (!this.mc.statFileWriter.hasAchievementUnlocked(AchievementList.openInventory)) {
            this.mc.guiAchievement.queueAchievementInformation(AchievementList.openInventory);
        }
        this.prevTimeInPortal = this.timeInPortal;
        if (this.inPortal) {
            if (!this.worldObj.multiplayerWorld && this.ridingEntity != null) {
                this.mountEntity(null);
            }
            if (this.mc.currentScreen != null) {
                this.mc.displayGuiScreen(null);
            }
            if (this.timeInPortal == 0.0f) {
                this.mc.sndManager.playSoundFX("portal.trigger", 1.0f, this.rand.nextFloat() * 0.4f + 0.8f);
            }
            this.timeInPortal += 0.0125f;
            if (this.timeInPortal >= 1.0f) {
                this.timeInPortal = 1.0f;
                if (!this.worldObj.multiplayerWorld) {
                    this.timeUntilPortal = 10;
                    this.mc.sndManager.playSoundFX("portal.travel", 1.0f, this.rand.nextFloat() * 0.4f + 0.8f);
                    this.mc.usePortal();
                    this.triggerAchievement(AchievementList.portal);
                }
            }
            this.inPortal = false;
        } else {
            if (this.timeInPortal > 0.0f) {
                this.timeInPortal -= 0.05f;
            }
            if (this.timeInPortal < 0.0f) {
                this.timeInPortal = 0.0f;
            }
        }
        if (this.timeUntilPortal > 0) {
            --this.timeUntilPortal;
        }
        boolean flag = this.movementInput.jump;
        this.movementInput.updatePlayerMoveState(this);
        if (this.movementInput.sneak && this.ySize < 0.2f) {
            this.ySize = 0.2f;
        }
        this.pushOutOfBlocks(this.posX - (double)this.width * 0.35, this.boundingBox.minY + 0.5, this.posZ + (double)this.width * 0.35);
        this.pushOutOfBlocks(this.posX - (double)this.width * 0.35, this.boundingBox.minY + 0.5, this.posZ - (double)this.width * 0.35);
        this.pushOutOfBlocks(this.posX + (double)this.width * 0.35, this.boundingBox.minY + 0.5, this.posZ - (double)this.width * 0.35);
        this.pushOutOfBlocks(this.posX + (double)this.width * 0.35, this.boundingBox.minY + 0.5, this.posZ + (double)this.width * 0.35);
        if ((this.capabilities.allowFlying || this.effecttimers[5] > 0) && !flag && this.movementInput.jump) {
            if (this.flyToggleTimer == 0) {
                this.flyToggleTimer = 7;
            } else {
                this.capabilities.isFlying = !this.capabilities.isFlying;
                this.flyToggleTimer = 0;
            }
        }
        if (this.capabilities.isFlying) {
            if (this.movementInput.sneak) {
                this.motionY -= 0.15;
            }
            if (this.movementInput.jump) {
                this.motionY += 0.15;
            }
        }
        super.onLivingUpdate();
        if (this.onGround && this.capabilities.isFlying) {
            this.capabilities.isFlying = false;
        }
    }

    public void resetPlayerKeyState() {
        this.movementInput.resetKeyState();
    }

    public void handleKeyPress(int var1, boolean var2) {
        this.movementInput.checkKeyForMovementInput(var1, var2);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound var1) {
        super.writeEntityToNBT(var1);
        var1.setLong("Score", this.score);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound var1) {
        super.readEntityFromNBT(var1);
        this.score = var1.getLong("Score");
    }

    @Override
    public void closeScreen() {
        super.closeScreen();
        this.mc.displayGuiScreen(null);
    }

    @Override
    public void displayGUIEditSign(TileEntitySign var1) {
        this.mc.displayGuiScreen(new GuiEditSign(var1));
    }

    @Override
    public void displayGUIChest(IInventory var1) {
        this.mc.displayGuiScreen(new GuiChest(this.inventory, var1));
    }

    @Override
    public void displayWorkbenchGUI(int var1, int var2, int var3) {
        this.mc.displayGuiScreen(new GuiCrafting(this.inventory, this.worldObj, var1, var2, var3));
    }

    @Override
    public void displayGUIFurnace(TileEntityFurnace var1) {
        this.mc.displayGuiScreen(new GuiFurnace(this.inventory, var1));
    }

    @Override
    public void displayGUIAnvil(TileEntityAnvil var1, int var2, int var3, int var4) {
        System.out.println("b" + var2 + " " + var3 + " " + var4);
        this.mc.displayGuiScreen(new GuiAnvil(this.inventory, var1, var2, var3, var4));
    }

    @Override
    public void displayGUIDispenser(TileEntityDispenser var1) {
        this.mc.displayGuiScreen(new GuiDispenser(this.inventory, var1));
    }

    @Override
    public void displayGUIBlastFurnace(TileEntityBlastFurnace var1) {
        this.mc.displayGuiScreen(new GuiBlastFurnace(this.inventory, var1));
    }

    @Override
    public void onItemPickup(Entity var1, int var2) {
        this.mc.effectRenderer.addEffect(new EntityPickupFX(this.mc.theWorld, var1, this, -0.5f));
    }

    public int getPlayerArmorValue() {
        return this.inventory.getTotalArmorValue();
    }

    public void sendChatMessage(String var1) {
        this.addChatMessage("<" + this.username + "> " + var1);
    }

    @Override
    public boolean isSneaking() {
        return this.movementInput.sneak && !this.sleeping;
    }

    public void setHealth(int var1) {
        int var2 = this.health - var1;
        if (var2 <= 0) {
            this.health = var1;
            if (var2 < 0) {
                this.heartsLife = this.heartsHalvesLife / 2;
            }
        } else {
            this.field_9346_af = var2;
            this.prevHealth = this.health;
            this.heartsLife = this.heartsHalvesLife;
            this.damageEntity(var2);
            this.maxHurtTime = 10;
            this.hurtTime = 10;
        }
    }

    @Override
    public void respawnPlayer() {
        this.mc.respawn(false, 0);
    }

    @Override
    public void func_6420_o() {
    }

    @Override
    public void addChatMessage(String var1) {
        this.mc.ingameGUI.addChatMessageTranslate(var1);
    }

    @Override
    public void addStat(StatBase var1, int var2) {
        if (var1 != null) {
            if (var1.func_25067_a()) {
                Achievement var3 = (Achievement)var1;
                if (var3.parentAchievement == null || this.mc.statFileWriter.hasAchievementUnlocked(var3.parentAchievement)) {
                    if (!this.mc.statFileWriter.hasAchievementUnlocked(var3)) {
                        this.mc.guiAchievement.queueTakenAchievement(var3);
                    }
                    this.mc.statFileWriter.readStat(var1, var2);
                }
            } else {
                this.mc.statFileWriter.readStat(var1, var2);
            }
        }
    }

    private boolean isBlockTranslucent(int var1, int var2, int var3) {
        return this.worldObj.isBlockNormalCube(var1, var2, var3);
    }

    @Override
    protected boolean pushOutOfBlocks(double var1, double var3, double var5) {
        int var7 = MathHelper.floor_double(var1);
        int var8 = MathHelper.floor_double(var3);
        int var9 = MathHelper.floor_double(var5);
        double var10 = var1 - (double)var7;
        double var12 = var5 - (double)var9;
        if (this.isBlockTranslucent(var7, var8, var9) || this.isBlockTranslucent(var7, var8 + 1, var9)) {
            boolean var14 = !this.isBlockTranslucent(var7 - 1, var8, var9) && !this.isBlockTranslucent(var7 - 1, var8 + 1, var9);
            boolean var15 = !this.isBlockTranslucent(var7 + 1, var8, var9) && !this.isBlockTranslucent(var7 + 1, var8 + 1, var9);
            boolean var16 = !this.isBlockTranslucent(var7, var8, var9 - 1) && !this.isBlockTranslucent(var7, var8 + 1, var9 - 1);
            boolean var17 = !this.isBlockTranslucent(var7, var8, var9 + 1) && !this.isBlockTranslucent(var7, var8 + 1, var9 + 1);
            int var18 = -1;
            double var19 = 9999.0;
            if (var14 && var10 < var19) {
                var19 = var10;
                var18 = 0;
            }
            if (var15 && 1.0 - var10 < var19) {
                var19 = 1.0 - var10;
                var18 = 1;
            }
            if (var16 && var12 < var19) {
                var19 = var12;
                var18 = 4;
            }
            if (var17 && 1.0 - var12 < var19) {
                var19 = 1.0 - var12;
                var18 = 5;
            }
            float var21 = 0.1f;
            if (var18 == 0) {
                this.motionX = -var21;
            }
            if (var18 == 1) {
                this.motionX = var21;
            }
            if (var18 == 4) {
                this.motionZ = -var21;
            }
            if (var18 == 5) {
                this.motionZ = var21;
            }
        }
        return false;
    }

    public float getFOVMultiplier() {
        if (this.bowCounter > 0) {
            this.fovModif = this.bowCounter;
            return -this.fovModif / 2.0f;
        }
        if (this.isRunning && (this.movementInput.moveForward > 0.0f || this.movementInput.moveStrafe > 0.0f)) {
            this.fovModif = this.stamina;
            return this.fovModif / 20.0f;
        }
        if (this.speedCounter > 0) {
            this.fovModif = this.speedCounter;
            return this.fovModif / 20.0f;
        }
        if (this.zoomFov > 0) {
            this.fovModif = -this.zoomFov;
            return this.fovModif;
        }
        return 0.0f;
    }
}

