/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client.renderer;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Frustrum2;
import net.minecraft.src.client.MouseFilter;
import net.minecraft.src.client.gui.ScaledResolution;
import net.minecraft.src.client.particle.EffectRenderer;
import net.minecraft.src.client.particle.EntityRainFX;
import net.minecraft.src.client.particle.EntitySmokeFX;
import net.minecraft.src.client.physics.AxisAlignedBB;
import net.minecraft.src.client.physics.ClippingHelperImpl;
import net.minecraft.src.client.physics.MovingObjectPosition;
import net.minecraft.src.client.player.EntityPlayerSP;
import net.minecraft.src.client.player.PlayerControllerTest;
import net.minecraft.src.client.renderer.Frustrum;
import net.minecraft.src.client.renderer.GLAllocation;
import net.minecraft.src.client.renderer.ItemRenderer;
import net.minecraft.src.client.renderer.RenderGlobal;
import net.minecraft.src.client.renderer.RenderHelper;
import net.minecraft.src.client.renderer.Tessellator;
import net.minecraft.src.client.renderer.Vec3D;
import net.minecraft.src.client.renderer.entity.OpenGlHelper;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.EntityLiving;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.level.biomes.BiomeGenBase;
import net.minecraft.src.game.level.chunk.ChunkProviderLoadOrGenerate;
import net.minecraft.src.game.level.chunk.IChunkProvider;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;

public class EntityRenderer {
    public static boolean field_28135_a = false;
    public static int anaglyphField;
    private Minecraft mc;
    private float farPlaneDistance = 0.0f;
    public ItemRenderer itemRenderer;
    private int rendererUpdateCount;
    private Entity pointedEntity = null;
    private MouseFilter mouseFilterXAxis = new MouseFilter();
    private MouseFilter mouseFilterYAxis = new MouseFilter();
    private MouseFilter mouseFilterDummy1 = new MouseFilter();
    private MouseFilter mouseFilterDummy2 = new MouseFilter();
    private MouseFilter mouseFilterDummy3 = new MouseFilter();
    private MouseFilter mouseFilterDummy4 = new MouseFilter();
    private float field_22228_r = 4.0f;
    private float field_22227_s = 4.0f;
    private float debugCamYaw = 0.0f;
    private float prevDebugCamYaw = 0.0f;
    private float debugCamPitch = 0.0f;
    private float prevDebugCamPitch = 0.0f;
    private float field_22222_x = 0.0f;
    private float field_22221_y = 0.0f;
    private float field_22220_z = 0.0f;
    private float field_22230_A = 0.0f;
    private boolean cloudFog = false;
    private double cameraZoom = 1.0;
    private double cameraYaw = 0.0;
    private double cameraPitch = 0.0;
    private long prevFrameTime = System.currentTimeMillis();
    private long field_28133_I = 0L;
    private Random random = new Random();
    private int rainSoundCounter = 0;
    volatile int field_1394_b = 0;
    volatile int field_1393_c = 0;
    FloatBuffer fogColorBuffer = GLAllocation.createDirectFloatBuffer(16);
    float fogColorRed;
    float fogColorGreen;
    float fogColorBlue;
    private float fogColor2;
    private float fogColor1;
    public int lightmapTexture;
    private int[] lightmapColors;
    private boolean lightmapUpdateNeeded = false;
    float torchFlickerX = 0.0f;
    float torchFlickerDX = 0.0f;
    float torchFlickerY = 0.0f;
    float torchFlickerDY = 0.0f;
    private DecimalFormat entityDecimalFormat;
    private ByteBuffer entityByteBuffer;
    private FloatBuffer entityFloatBuffer;

    public EntityRenderer(Minecraft var1) {
        this.mc = var1;
        this.itemRenderer = new ItemRenderer(var1);
        this.lightmapTexture = var1.renderEngine.allocateAndSetupTexture(new BufferedImage(16, 16, 1));
        this.lightmapColors = new int[256];
        this.entityDecimalFormat = new DecimalFormat("0000");
        this.entityFloatBuffer = BufferUtils.createFloatBuffer((int)16);
    }

    public void updateRenderer() {
        this.updateTorchFlicker();
        this.fogColor2 = this.fogColor1;
        this.field_22227_s = this.field_22228_r;
        this.prevDebugCamYaw = this.debugCamYaw;
        this.prevDebugCamPitch = this.debugCamPitch;
        this.field_22221_y = this.field_22222_x;
        this.field_22230_A = this.field_22220_z;
        if (this.mc.renderViewEntity == null) {
            this.mc.renderViewEntity = this.mc.thePlayer;
        }
        float var1 = this.mc.theWorld.getLightBrightness(MathHelper.floor_double(this.mc.renderViewEntity.posX), MathHelper.floor_double(this.mc.renderViewEntity.posY), MathHelper.floor_double(this.mc.renderViewEntity.posZ));
        float var2 = (float)(3 - this.mc.gameSettings.renderDistance) / 3.0f;
        float var3 = var1 * (1.0f - var2) + var2;
        this.fogColor1 += (var3 - this.fogColor1) * 0.1f;
        ++this.rendererUpdateCount;
        this.itemRenderer.updateEquippedItem();
        this.addRainParticles();
    }

    public void disableLightmap(double var1) {
        OpenGlHelper.setActiveTexture(OpenGlHelper.lightmapTexUnit);
        GL11.glDisable((int)3553);
        OpenGlHelper.setActiveTexture(OpenGlHelper.defaultTexUnit);
    }

    public void enableLightmap(double var1) {
        OpenGlHelper.setActiveTexture(OpenGlHelper.lightmapTexUnit);
        GL11.glMatrixMode((int)5890);
        GL11.glLoadIdentity();
        float var3 = 3.90625E-6f;
        GL11.glScalef((float)var3, (float)var3, (float)var3);
        GL11.glTranslatef((float)8.0f, (float)8.0f, (float)8.0f);
        GL11.glMatrixMode((int)5888);
        this.mc.renderEngine.bindTexture(this.lightmapTexture);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        OpenGlHelper.setActiveTexture(OpenGlHelper.defaultTexUnit);
    }

    private void updateTorchFlicker() {
        this.torchFlickerDX = (float)((double)this.torchFlickerDX + (Math.random() - Math.random()) * Math.random() * Math.random());
        this.torchFlickerDY = (float)((double)this.torchFlickerDY + (Math.random() - Math.random()) * Math.random() * Math.random());
        this.torchFlickerDX = (float)((double)this.torchFlickerDX * 0.9);
        this.torchFlickerDY = (float)((double)this.torchFlickerDY * 0.9);
        this.torchFlickerX += (this.torchFlickerDX - this.torchFlickerX) * 1.0f;
        this.torchFlickerY += (this.torchFlickerDY - this.torchFlickerY) * 1.0f;
        this.lightmapUpdateNeeded = true;
    }

    public void updateLightmap() {
        World var1 = this.mc.theWorld;
        if (var1 != null) {
            int var2 = 0;
            while (var2 < 256) {
                float var3 = var1.func_35464_b(1.0f) * 0.95f + 0.05f;
                float var4 = var1.worldProvider.lightBrightnessTable[var2 / 16] * var3;
                float var5 = var1.worldProvider.lightBrightnessTable[var2 % 16] * (this.torchFlickerX * 0.1f + 1.5f);
                if (var1.field_27172_i > 0) {
                    var4 = var1.worldProvider.lightBrightnessTable[var2 / 16];
                }
                float var6 = var4 * (var1.func_35464_b(1.0f) * 0.65f + 0.35f);
                float var7 = var4 * (var1.func_35464_b(1.0f) * 0.65f + 0.35f);
                float var10 = var5 * ((var5 * 0.6f + 0.4f) * 0.6f + 0.4f);
                float var11 = var5 * (var5 * var5 * 0.6f + 0.4f);
                float var12 = var6 + var5;
                float var13 = var7 + var10;
                float var14 = var4 + var11;
                var12 = var12 * 0.96f + 0.03f;
                var13 = var13 * 0.96f + 0.03f;
                var14 = var14 * 0.96f + 0.03f;
                if (var1.worldProvider.worldType == 1) {
                    var12 = 0.22f + var5 * 0.75f;
                    var13 = 0.28f + var10 * 0.75f;
                    var14 = 0.25f + var11 * 0.75f;
                }
                float var15 = 0.0f;
                if (var12 > 1.0f) {
                    var12 = 1.0f;
                }
                if (var13 > 1.0f) {
                    var13 = 1.0f;
                }
                if (var14 > 1.0f) {
                    var14 = 1.0f;
                }
                float var16 = 1.0f - var12;
                float var17 = 1.0f - var13;
                float var18 = 1.0f - var14;
                var16 = 1.0f - var16 * var16 * var16 * var16;
                var17 = 1.0f - var17 * var17 * var17 * var17;
                var18 = 1.0f - var18 * var18 * var18 * var18;
                var12 = var12 * (1.0f - var15) + var16 * var15;
                var13 = var13 * (1.0f - var15) + var17 * var15;
                var14 = var14 * (1.0f - var15) + var18 * var15;
                var12 = var12 * 0.96f + 0.03f;
                var13 = var13 * 0.96f + 0.03f;
                var14 = var14 * 0.96f + 0.03f;
                if (var12 > 1.0f) {
                    var12 = 1.0f;
                }
                if (var13 > 1.0f) {
                    var13 = 1.0f;
                }
                if (var14 > 1.0f) {
                    var14 = 1.0f;
                }
                if (var12 < 0.0f) {
                    var12 = 0.0f;
                }
                if (var13 < 0.0f) {
                    var13 = 0.0f;
                }
                if (var14 < 0.0f) {
                    var14 = 0.0f;
                }
                int var19 = 255;
                int var20 = (int)(var12 * 255.0f);
                int var21 = (int)(var13 * 255.0f);
                int var22 = (int)(var14 * 255.0f);
                this.lightmapColors[var2] = var19 << 24 | var20 << 16 | var21 << 8 | var22;
                ++var2;
            }
            this.mc.renderEngine.createTextureFromBytes(this.lightmapColors, 16, 16, this.lightmapTexture);
        }
    }

    public void getMouseOver(float var1) {
        if (this.mc.renderViewEntity != null && this.mc.theWorld != null) {
            double var2 = this.mc.playerController.getBlockReachDistance();
            this.mc.objectMouseOver = this.mc.renderViewEntity.rayTrace(var2, var1);
            double var4 = var2;
            Vec3D var6 = this.mc.renderViewEntity.getPosition(var1);
            if (this.mc.objectMouseOver != null) {
                var4 = this.mc.objectMouseOver.hitVec.distanceTo(var6);
            }
            if (this.mc.playerController instanceof PlayerControllerTest) {
                var2 = 3.0;
                var4 = 3.0;
            } else {
                if (var4 > 3.0) {
                    var4 = 3.0;
                }
                var2 = var4;
            }
            Vec3D var7 = this.mc.renderViewEntity.getLook(var1);
            Vec3D var8 = var6.addVector(var7.xCoord * var2, var7.yCoord * var2, var7.zCoord * var2);
            this.pointedEntity = null;
            float var9 = 1.0f;
            List var10 = this.mc.theWorld.getEntitiesWithinAABBExcludingEntity(this.mc.renderViewEntity, this.mc.renderViewEntity.boundingBox.addCoord(var7.xCoord * var2, var7.yCoord * var2, var7.zCoord * var2).expand(var9, var9, var9));
            double var11 = 0.0;
            int var13 = 0;
            while (var13 < var10.size()) {
                Entity var14 = (Entity)var10.get(var13);
                if (var14.canBeCollidedWith()) {
                    double var18;
                    float var15 = var14.getCollisionBorderSize();
                    AxisAlignedBB var16 = var14.boundingBox.expand(var15, var15, var15);
                    MovingObjectPosition var17 = var16.func_1169_a(var6, var8);
                    if (var16.isVecInside(var6)) {
                        if (0.0 < var11 || var11 == 0.0) {
                            this.pointedEntity = var14;
                            var11 = 0.0;
                        }
                    } else if (var17 != null && ((var18 = var6.distanceTo(var17.hitVec)) < var11 || var11 == 0.0)) {
                        this.pointedEntity = var14;
                        var11 = var18;
                    }
                }
                ++var13;
            }
            if (this.pointedEntity != null) {
                this.mc.objectMouseOver = new MovingObjectPosition(this.pointedEntity);
            }
        }
    }

    private float getFOVModifier(float modifier) {
        EntityPlayerSP player = (EntityPlayerSP)this.mc.renderViewEntity;
        float fov = 70.0f;
        if (player.isInsideOfMaterial(Material.water)) {
            fov = 60.0f;
        }
        if (player.health <= 0) {
            float howLongIsPlayerDead = (float)player.deathTime + modifier;
            fov /= (1.0f - 500.0f / (howLongIsPlayerDead + 500.0f)) * 2.0f + 1.0f;
        }
        return fov + this.field_22221_y + (this.field_22222_x - this.field_22221_y) * modifier + player.getFOVMultiplier();
    }

    private void hurtCameraEffect(float modifier) {
        float var4;
        EntityLiving player = this.mc.renderViewEntity;
        float var3 = (float)player.hurtTime - modifier;
        if (player.health <= 0) {
            var4 = (float)player.deathTime + modifier;
            GL11.glRotatef((float)(40.0f - 8000.0f / (var4 + 200.0f)), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (var3 >= 0.0f) {
            var3 /= (float)player.maxHurtTime;
            var3 = MathHelper.sin(var3 * var3 * var3 * var3 * (float)Math.PI);
            var4 = player.attackedAtYaw;
            GL11.glRotatef((float)(-var4), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-var3 * 14.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)var4, (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    private void setupViewBobbing(float var1) {
        if (this.mc.renderViewEntity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)this.mc.renderViewEntity;
            float var3 = player.distanceWalkedModified - player.prevDistanceWalkedModified;
            float var4 = -(player.distanceWalkedModified + var3 * var1);
            float var5 = player.field_775_e + (player.field_774_f - player.field_775_e) * var1;
            float var6 = player.cameraPitch + (player.field_9328_R - player.cameraPitch) * var1;
            GL11.glTranslatef((float)(MathHelper.sin(var4 * (float)Math.PI) * var5 * 0.5f), (float)(-Math.abs(MathHelper.cos(var4 * (float)Math.PI) * var5)), (float)0.0f);
            GL11.glRotatef((float)(MathHelper.sin(var4 * (float)Math.PI) * var5 * 3.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(Math.abs(MathHelper.cos(var4 * (float)Math.PI - 0.2f) * var5) * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)var6, (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    private void orientCamera(float var1) {
        EntityLiving player = this.mc.renderViewEntity;
        float var3 = player.yOffset - 1.62f;
        double var4 = player.prevPosX + (player.posX - player.prevPosX) * (double)var1;
        double var6 = player.prevPosY + (player.posY - player.prevPosY) * (double)var1 - (double)var3;
        double var8 = player.prevPosZ + (player.posZ - player.prevPosZ) * (double)var1;
        GL11.glRotatef((float)(this.field_22230_A + (this.field_22220_z - this.field_22230_A) * var1), (float)0.0f, (float)0.0f, (float)1.0f);
        if (player.isPlayerSleeping()) {
            var3 = (float)((double)var3 + 1.0);
            GL11.glTranslatef((float)0.0f, (float)0.3f, (float)0.0f);
            if (!this.mc.gameSettings.debugCamEnable) {
                int var10 = this.mc.theWorld.getBlockId(MathHelper.floor_double(player.posX), MathHelper.floor_double(player.posY), MathHelper.floor_double(player.posZ));
                if (var10 == Block.blockBed.blockID) {
                    int var11 = this.mc.theWorld.getBlockMetadata(MathHelper.floor_double(player.posX), MathHelper.floor_double(player.posY), MathHelper.floor_double(player.posZ));
                    int var12 = var11 & 3;
                    GL11.glRotatef((float)(var12 * 90), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                GL11.glRotatef((float)(player.prevRotationYaw + (player.rotationYaw - player.prevRotationYaw) * var1 + 180.0f), (float)0.0f, (float)-1.0f, (float)0.0f);
                GL11.glRotatef((float)(player.prevRotationPitch + (player.rotationPitch - player.prevRotationPitch) * var1), (float)-1.0f, (float)0.0f, (float)0.0f);
            }
        } else if (this.mc.gameSettings.thirdPersonView > 0) {
            double var27 = this.field_22227_s + (this.field_22228_r - this.field_22227_s) * var1;
            if (this.mc.gameSettings.debugCamEnable) {
                float var28 = this.prevDebugCamYaw + (this.debugCamYaw - this.prevDebugCamYaw) * var1;
                float var13 = this.prevDebugCamPitch + (this.debugCamPitch - this.prevDebugCamPitch) * var1;
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)((float)(-var27)));
                GL11.glRotatef((float)var13, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)var28, (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                float var28 = player.rotationYaw;
                float var13 = player.rotationPitch;
                if (this.mc.gameSettings.thirdPersonView == 2) {
                    var13 += 180.0f;
                }
                double var14 = (double)(-MathHelper.sin(var28 / 180.0f * (float)Math.PI) * MathHelper.cos(var13 / 180.0f * (float)Math.PI)) * var27;
                double var16 = (double)(MathHelper.cos(var28 / 180.0f * (float)Math.PI) * MathHelper.cos(var13 / 180.0f * (float)Math.PI)) * var27;
                double var18 = (double)(-MathHelper.sin(var13 / 180.0f * (float)Math.PI)) * var27;
                int var20 = 0;
                while (var20 < 8) {
                    double var25;
                    MovingObjectPosition var24;
                    float var21 = (var20 & 1) * 2 - 1;
                    float var22 = (var20 >> 1 & 1) * 2 - 1;
                    float var23 = (var20 >> 2 & 1) * 2 - 1;
                    if ((var24 = this.mc.theWorld.rayTraceBlocks(Vec3D.createVector(var4 + (double)(var21 *= 0.1f), var6 + (double)(var22 *= 0.1f), var8 + (double)(var23 *= 0.1f)), Vec3D.createVector(var4 - var14 + (double)var21 + (double)var23, var6 - var18 + (double)var22, var8 - var16 + (double)var23))) != null && (var25 = var24.hitVec.distanceTo(Vec3D.createVector(var4, var6, var8))) < var27) {
                        var27 = var25;
                    }
                    ++var20;
                }
                if (this.mc.gameSettings.thirdPersonView == 2) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                GL11.glRotatef((float)(player.rotationPitch - var13), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)(player.rotationYaw - var28), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)((float)(-var27)));
                GL11.glRotatef((float)(var28 - player.rotationYaw), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(var13 - player.rotationPitch), (float)1.0f, (float)0.0f, (float)0.0f);
            }
        } else {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.1f);
        }
        if (!this.mc.gameSettings.debugCamEnable) {
            GL11.glRotatef((float)(player.prevRotationPitch + (player.rotationPitch - player.prevRotationPitch) * var1), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(player.prevRotationYaw + (player.rotationYaw - player.prevRotationYaw) * var1 + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glTranslatef((float)0.0f, (float)var3, (float)0.0f);
        var4 = player.prevPosX + (player.posX - player.prevPosX) * (double)var1;
        var6 = player.prevPosY + (player.posY - player.prevPosY) * (double)var1 - (double)var3;
        var8 = player.prevPosZ + (player.posZ - player.prevPosZ) * (double)var1;
        this.cloudFog = this.mc.renderGlobal.func_27307_a(var4, var6, var8, var1);
    }

    public final void grabLargeScreenshot() {
        File file2;
        int size = 128;
        File file = new File(System.getProperty("user.home", "."));
        int n = 0;
        while ((file2 = new File(file, "mc_map_" + this.entityDecimalFormat.format(n) + ".png")).exists()) {
            ++n;
        }
        File absoluteFile = file2.getAbsoluteFile();
        this.mc.loadingScreen.printText("Rendering");
        this.mc.loadingScreen.setLoadingProgress(0);
        try {
            int n2 = (size << 4) * 2;
            int n3 = 2048 + n2 / 2;
            BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
            Graphics graphics = bufferedImage.getGraphics();
            int displayWidth = this.mc.displayWidth;
            int displayHeight = this.mc.displayHeight;
            int n32 = (n2 / displayWidth + 1) * (n3 / displayHeight + 1);
            int n4 = 0;
            int i = 0;
            while (i < n2) {
                int j = 0;
                while (j < n3) {
                    this.mc.loadingScreen.setLoadingProgress(++n4 * 100 / n32);
                    int n5 = i - n2 / 2;
                    int n6 = j - n3 / 2;
                    int sortAndRender = n5;
                    if (this.entityByteBuffer == null) {
                        this.entityByteBuffer = BufferUtils.createByteBuffer((int)(this.mc.displayWidth * this.mc.displayHeight << 2));
                    }
                    EntityPlayerSP thePlayer = this.mc.thePlayer;
                    World theWorld = this.mc.theWorld;
                    RenderGlobal renderGlobal = this.mc.renderGlobal;
                    GL11.glViewport((int)0, (int)0, (int)this.mc.displayWidth, (int)this.mc.displayHeight);
                    this.updateFogColor(0.0f);
                    GL11.glClear((int)16640);
                    GL11.glEnable((int)2884);
                    this.farPlaneDistance = 512 >> (this.mc.gameSettings.renderDistance << 1);
                    GL11.glMatrixMode((int)5889);
                    GL11.glLoadIdentity();
                    GL11.glOrtho((double)0.0, (double)this.mc.displayWidth, (double)0.0, (double)this.mc.displayHeight, (double)10.0, (double)10000.0);
                    GL11.glMatrixMode((int)5888);
                    GL11.glLoadIdentity();
                    GL11.glTranslatef((float)(-sortAndRender), (float)(-n6), (float)-5000.0f);
                    GL11.glScalef((float)16.0f, (float)-16.0f, (float)-16.0f);
                    this.entityFloatBuffer.clear();
                    this.entityFloatBuffer.put(1.0f).put(-0.5f).put(0.0f).put(0.0f);
                    this.entityFloatBuffer.put(0.0f).put(1.0f).put(-1.0f).put(0.0f);
                    this.entityFloatBuffer.put(1.0f).put(0.5f).put(0.0f).put(0.0f);
                    this.entityFloatBuffer.put(0.0f).put(0.0f).put(0.0f).put(1.0f);
                    this.entityFloatBuffer.flip();
                    GL11.glMultMatrix((FloatBuffer)this.entityFloatBuffer);
                    GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslated((double)this.mc.thePlayer.posX, (double)-63.5, (double)this.mc.thePlayer.posZ);
                    Frustrum2 frustrum2 = new Frustrum2();
                    this.mc.renderGlobal.clipRenderersByFrustrum(frustrum2, 0.0f);
                    this.mc.renderGlobal.updateRenderers(thePlayer, false);
                    GL11.glEnable((int)2912);
                    GL11.glFogi((int)2917, (int)9729);
                    float n7 = 1016.0f;
                    GL11.glFogf((int)2915, (float)3984.0f);
                    GL11.glFogf((int)2916, (float)13128.0f);
                    RenderHelper.enableStandardItemLighting();
                    renderGlobal.renderEntities(this.orientCameraVec(0.0), frustrum2, 0.0f);
                    RenderHelper.disableStandardItemLighting();
                    GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/terrain.png"));
                    renderGlobal.sortAndRender(thePlayer, 0, 0.0);
                    renderGlobal.f();
                    if (theWorld.worldProvider.getCloudHeight() < 127.0f) {
                        renderGlobal.renderSky(0.0f);
                    }
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                    sortAndRender = renderGlobal.sortAndRender(thePlayer, 1, 0.0);
                    GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    if (sortAndRender > 0) {
                        renderGlobal.renderAllRenderLists(sortAndRender, this.cameraPitch);
                    }
                    GL11.glDepthMask((boolean)true);
                    GL11.glDisable((int)3042);
                    GL11.glDisable((int)2912);
                    this.entityByteBuffer.clear();
                    GL11.glPixelStorei((int)3333, (int)1);
                    GL11.glReadPixels((int)0, (int)0, (int)this.mc.displayWidth, (int)this.mc.displayHeight, (int)6407, (int)5121, (ByteBuffer)this.entityByteBuffer);
                    graphics.drawImage(EntityRenderer.screenshotBuffer(this.entityByteBuffer, displayWidth, displayHeight), i, j, null);
                    j += displayHeight;
                }
                i += displayWidth;
            }
            graphics.dispose();
            this.mc.loadingScreen.printText("Saving as " + absoluteFile.toString());
            this.mc.loadingScreen.setLoadingProgress(100);
            FileOutputStream fileOutputStream = new FileOutputStream(absoluteFile);
            ImageIO.write((RenderedImage)bufferedImage, "png", fileOutputStream);
            fileOutputStream.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static BufferedImage screenshotBuffer(ByteBuffer byteBuffer, int n, int n2) {
        byteBuffer.position(0).limit(n * n2 << 2);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        int[] data = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        int i = 0;
        while (i < n * n2) {
            data[i] = (byteBuffer.get(i * 3) & 0xFF) << 16 | (byteBuffer.get(i * 3 + 1) & 0xFF) << 8 | byteBuffer.get(i * 3 + 2) & 0xFF;
            ++i;
        }
        return bufferedImage;
    }

    private Vec3D orientCameraVec(double n) {
        EntityPlayerSP thePlayer = this.mc.thePlayer;
        double n2 = thePlayer.prevPosX + (thePlayer.posX - thePlayer.prevPosX) * n;
        double n3 = thePlayer.prevPosY + (thePlayer.posY - thePlayer.prevPosY) * n;
        n = thePlayer.prevPosZ + (thePlayer.posZ - thePlayer.prevPosZ) * n;
        return new Vec3D(n2, n3, n);
    }

    private void setupCameraTransform(float var1, int var2) {
        float var4;
        this.farPlaneDistance = 256 >> this.mc.gameSettings.renderDistance;
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        float var3 = 0.07f;
        if (this.mc.gameSettings.anaglyph) {
            GL11.glTranslatef((float)((float)(-(var2 * 2 - 1)) * var3), (float)0.0f, (float)0.0f);
        }
        if (this.cameraZoom != 1.0) {
            GL11.glTranslatef((float)((float)this.cameraYaw), (float)((float)(-this.cameraPitch)), (float)0.0f);
            GL11.glScaled((double)this.cameraZoom, (double)this.cameraZoom, (double)1.0);
            GLU.gluPerspective((float)this.getFOVModifier(var1), (float)((float)this.mc.displayWidth / (float)this.mc.displayHeight), (float)0.05f, (float)(this.farPlaneDistance * 2.0f));
        } else {
            GLU.gluPerspective((float)this.getFOVModifier(var1), (float)((float)this.mc.displayWidth / (float)this.mc.displayHeight), (float)0.05f, (float)(this.farPlaneDistance * 2.0f));
        }
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        if (this.mc.gameSettings.anaglyph) {
            GL11.glTranslatef((float)((float)(var2 * 2 - 1) * 0.1f), (float)0.0f, (float)0.0f);
        }
        this.hurtCameraEffect(var1);
        if (this.mc.gameSettings.viewBobbing) {
            this.setupViewBobbing(var1);
        }
        if ((var4 = this.mc.thePlayer.prevTimeInPortal + (this.mc.thePlayer.timeInPortal - this.mc.thePlayer.prevTimeInPortal) * var1) > 0.0f) {
            float var5 = 5.0f / (var4 * var4 + 5.0f) - var4 * 0.04f;
            var5 *= var5;
            GL11.glRotatef((float)(((float)this.rendererUpdateCount + var1) * 20.0f), (float)0.0f, (float)1.0f, (float)1.0f);
            GL11.glScalef((float)(1.0f / var5), (float)1.0f, (float)1.0f);
            GL11.glRotatef((float)(-((float)this.rendererUpdateCount + var1) * 20.0f), (float)0.0f, (float)1.0f, (float)1.0f);
        }
        this.orientCamera(var1);
    }

    private void func_4135_b(float var1, int var2) {
        GL11.glLoadIdentity();
        if (this.mc.gameSettings.anaglyph) {
            GL11.glTranslatef((float)((float)(var2 * 2 - 1) * 0.1f), (float)0.0f, (float)0.0f);
        }
        GL11.glPushMatrix();
        this.hurtCameraEffect(var1);
        if (this.mc.gameSettings.viewBobbing) {
            this.setupViewBobbing(var1);
        }
        if (this.mc.gameSettings.thirdPersonView <= 0 && !this.mc.renderViewEntity.isPlayerSleeping() && !this.mc.gameSettings.hideGUI) {
            this.itemRenderer.renderItemInFirstPerson(var1);
        }
        GL11.glPopMatrix();
        if (this.mc.gameSettings.thirdPersonView <= 0 && !this.mc.renderViewEntity.isPlayerSleeping()) {
            this.itemRenderer.renderOverlays(var1);
            this.hurtCameraEffect(var1);
        }
        if (this.mc.gameSettings.viewBobbing) {
            this.setupViewBobbing(var1);
        }
    }

    public void updateCameraAndRender(float var1) {
        if (this.lightmapUpdateNeeded) {
            this.updateLightmap();
        }
        if (!Display.isActive()) {
            if (System.currentTimeMillis() - this.prevFrameTime > 500L) {
                this.mc.displayInGameMenu();
            }
        } else {
            this.prevFrameTime = System.currentTimeMillis();
        }
        if (this.mc.inGameHasFocus) {
            this.mc.mouseHelper.mouseXYChange();
            float var2 = this.mc.gameSettings.mouseSensitivity * 0.6f + 0.2f;
            float var3 = var2 * var2 * var2 * 8.0f;
            float var4 = (float)this.mc.mouseHelper.deltaX * var3;
            float var5 = (float)this.mc.mouseHelper.deltaY * var3;
            int var6 = 1;
            if (this.mc.gameSettings.invertMouse) {
                var6 = -1;
            }
            if (this.mc.gameSettings.smoothCamera || this.mc.gameSettings.smoothZoomCamera) {
                var4 = this.mouseFilterXAxis.func_22386_a(var4, 0.05f * var3);
                var5 = this.mouseFilterYAxis.func_22386_a(var5, 0.05f * var3);
            }
            this.mc.thePlayer.func_346_d(var4, var5 * (float)var6);
        }
        if (!this.mc.skipRenderWorld) {
            field_28135_a = this.mc.gameSettings.anaglyph;
            ScaledResolution var13 = new ScaledResolution(this.mc.gameSettings, this.mc.displayWidth, this.mc.displayHeight);
            int var14 = var13.getScaledWidth();
            int var15 = var13.getScaledHeight();
            int var16 = Mouse.getX() * var14 / this.mc.displayWidth;
            int var17 = var15 - Mouse.getY() * var15 / this.mc.displayHeight - 1;
            int var7 = 200;
            if (this.mc.gameSettings.limitFramerate == 1) {
                var7 = 120;
            }
            if (this.mc.gameSettings.limitFramerate == 2) {
                var7 = 40;
            }
            if (this.mc.theWorld != null) {
                long var8;
                if (this.mc.gameSettings.limitFramerate == 0) {
                    this.renderWorld(var1, 0L);
                } else {
                    this.renderWorld(var1, this.field_28133_I + (long)(1000000000 / var7));
                }
                if (this.mc.gameSettings.limitFramerate == 2 && (var8 = (this.field_28133_I + (long)(1000000000 / var7) - System.nanoTime()) / 1000000L) > 0L && var8 < 500L) {
                    try {
                        Thread.sleep(var8);
                    }
                    catch (InterruptedException var12) {
                        var12.printStackTrace();
                    }
                }
                this.field_28133_I = System.nanoTime();
                if (!this.mc.gameSettings.hideGUI || this.mc.currentScreen != null) {
                    this.mc.ingameGUI.renderGameOverlay(var1, this.mc.currentScreen != null, var16, var17);
                }
            } else {
                GL11.glViewport((int)0, (int)0, (int)this.mc.displayWidth, (int)this.mc.displayHeight);
                GL11.glMatrixMode((int)5889);
                GL11.glLoadIdentity();
                GL11.glMatrixMode((int)5888);
                GL11.glLoadIdentity();
                this.func_905_b();
                if (this.mc.gameSettings.limitFramerate == 2) {
                    long var8 = (this.field_28133_I + (long)(1000000000 / var7) - System.nanoTime()) / 1000000L;
                    if (var8 < 0L) {
                        var8 += 10L;
                    }
                    if (var8 > 0L && var8 < 500L) {
                        try {
                            Thread.sleep(var8);
                        }
                        catch (InterruptedException var11) {
                            var11.printStackTrace();
                        }
                    }
                }
                this.field_28133_I = System.nanoTime();
            }
            if (this.mc.currentScreen != null) {
                GL11.glClear((int)256);
                this.mc.currentScreen.drawScreen(var16, var17, var1);
                if (this.mc.currentScreen != null && this.mc.currentScreen.field_25091_h != null) {
                    this.mc.currentScreen.field_25091_h.func_25087_a(var1);
                }
            }
        }
    }

    public void renderWorld(float var1, long var2) {
        int var16;
        if (this.lightmapUpdateNeeded) {
            this.updateLightmap();
        }
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2929);
        if (this.mc.renderViewEntity == null) {
            this.mc.renderViewEntity = this.mc.thePlayer;
        }
        this.getMouseOver(var1);
        EntityLiving var4 = this.mc.renderViewEntity;
        RenderGlobal var5 = this.mc.renderGlobal;
        EffectRenderer var6 = this.mc.effectRenderer;
        double var7 = var4.lastTickPosX + (var4.posX - var4.lastTickPosX) * (double)var1;
        double var9 = var4.lastTickPosY + (var4.posY - var4.lastTickPosY) * (double)var1;
        double var11 = var4.lastTickPosZ + (var4.posZ - var4.lastTickPosZ) * (double)var1;
        IChunkProvider var13 = this.mc.theWorld.getIChunkProvider();
        if (var13 instanceof ChunkProviderLoadOrGenerate) {
            ChunkProviderLoadOrGenerate var14 = (ChunkProviderLoadOrGenerate)var13;
            int var15 = MathHelper.floor_float((int)var7) >> 4;
            var16 = MathHelper.floor_float((int)var11) >> 4;
            var14.setCurrentChunkOver(var15, var16);
        }
        int var18 = 0;
        while (var18 < 2) {
            if (this.mc.gameSettings.anaglyph) {
                anaglyphField = var18;
                if (anaglyphField == 0) {
                    GL11.glColorMask((boolean)false, (boolean)true, (boolean)true, (boolean)false);
                } else {
                    GL11.glColorMask((boolean)true, (boolean)false, (boolean)false, (boolean)false);
                }
            }
            GL11.glViewport((int)0, (int)0, (int)this.mc.displayWidth, (int)this.mc.displayHeight);
            this.updateFogColor(var1);
            GL11.glClear((int)16640);
            GL11.glEnable((int)2884);
            this.setupCameraTransform(var1, var18);
            ClippingHelperImpl.getInstance();
            if (this.mc.gameSettings.renderDistance < 2) {
                this.setupFog(-1, var1);
                var5.renderSky(var1);
            }
            GL11.glEnable((int)2912);
            this.setupFog(1, var1);
            if (this.mc.gameSettings.ambientOcclusion) {
                GL11.glShadeModel((int)7425);
            }
            Frustrum var19 = new Frustrum();
            var19.setPosition(var7, var9, var11);
            this.mc.renderGlobal.clipRenderersByFrustrum(var19, var1);
            if (var18 == 0) {
                while (!this.mc.renderGlobal.updateRenderers(var4, false) && var2 != 0L) {
                    long var20 = var2 - System.nanoTime();
                    if (var20 < 0L || var20 > 1000000000L) break;
                }
            }
            this.setupFog(0, var1);
            GL11.glEnable((int)2912);
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/terrain.png"));
            RenderHelper.disableStandardItemLighting();
            var5.sortAndRender(var4, 0, var1);
            GL11.glShadeModel((int)7424);
            RenderHelper.enableStandardItemLighting();
            var5.renderEntities(var4.getPosition(var1), var19, var1);
            var6.func_1187_b(var4, var1);
            RenderHelper.disableStandardItemLighting();
            this.setupFog(0, var1);
            var6.renderParticles(var4, var1);
            if (this.mc.objectMouseOver != null && var4.isInsideOfMaterial(Material.water) && var4 instanceof EntityPlayer && !this.mc.gameSettings.hideGUI) {
                EntityPlayer var21 = (EntityPlayer)var4;
                GL11.glDisable((int)3008);
                var5.drawBlockBreaking(var21, this.mc.objectMouseOver, 0, var21.inventory.getCurrentItem(), var1);
                var5.drawSelectionBox(var21, this.mc.objectMouseOver, 0, var21.inventory.getCurrentItem(), var1);
                GL11.glEnable((int)3008);
            }
            GL11.glBlendFunc((int)770, (int)771);
            this.setupFog(0, var1);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2884);
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/terrain.png"));
            if (this.mc.gameSettings.fancyGraphics) {
                if (this.mc.gameSettings.ambientOcclusion) {
                    GL11.glShadeModel((int)7425);
                }
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                var16 = var5.sortAndRender(var4, 1, var1);
                if (this.mc.gameSettings.anaglyph) {
                    if (anaglyphField == 0) {
                        GL11.glColorMask((boolean)false, (boolean)true, (boolean)true, (boolean)true);
                    } else {
                        GL11.glColorMask((boolean)true, (boolean)false, (boolean)false, (boolean)true);
                    }
                } else {
                    GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                }
                if (var16 > 0) {
                    var5.renderAllRenderLists(1, var1);
                }
                GL11.glShadeModel((int)7424);
            } else {
                var5.sortAndRender(var4, 1, var1);
            }
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
            if (this.cameraZoom == 1.0 && var4 instanceof EntityPlayer && this.mc.objectMouseOver != null && !var4.isInsideOfMaterial(Material.water)) {
                EntityPlayer var21 = (EntityPlayer)var4;
                GL11.glDisable((int)3008);
                var5.drawBlockBreaking(var21, this.mc.objectMouseOver, 0, var21.inventory.getCurrentItem(), var1);
                var5.drawSelectionBox(var21, this.mc.objectMouseOver, 0, var21.inventory.getCurrentItem(), var1);
                GL11.glEnable((int)3008);
            }
            this.renderRainSnow(var1);
            GL11.glDisable((int)2912);
            this.setupFog(0, var1);
            GL11.glEnable((int)2912);
            var5.renderClouds(var1);
            GL11.glDisable((int)2912);
            this.setupFog(1, var1);
            if (this.cameraZoom == 1.0) {
                GL11.glClear((int)256);
                this.func_4135_b(var1, var18);
            }
            if (!this.mc.gameSettings.anaglyph) {
                return;
            }
            ++var18;
        }
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
    }

    private void addRainParticles() {
        float var1 = this.mc.theWorld.func_27162_g(1.0f);
        if (!this.mc.gameSettings.fancyGraphics) {
            var1 /= 2.0f;
        }
        if (var1 != 0.0f) {
            this.random.setSeed((long)this.rendererUpdateCount * 312987231L);
            EntityLiving var2 = this.mc.renderViewEntity;
            World var3 = this.mc.theWorld;
            int var4 = MathHelper.floor_double(var2.posX);
            int var5 = MathHelper.floor_double(var2.posY);
            int var6 = MathHelper.floor_double(var2.posZ);
            int var7 = 10;
            double var8 = 0.0;
            double var10 = 0.0;
            double var12 = 0.0;
            int var14 = 0;
            int var15 = 0;
            while (var15 < (int)(100.0f * var1 * var1)) {
                int var16 = var4 + this.random.nextInt(var7) - this.random.nextInt(var7);
                int var17 = var6 + this.random.nextInt(var7) - this.random.nextInt(var7);
                int var18 = var3.findTopSolidBlock(var16, var17);
                int var19 = var3.getBlockId(var16, var18 - 1, var17);
                if (var18 <= var5 + var7 && var18 >= var5 - var7 && var3.getWorldChunkManager().getBiomeGenAt(var16, var17).canSpawnLightningBolt()) {
                    float var20 = this.random.nextFloat();
                    float var21 = this.random.nextFloat();
                    if (var19 > 0) {
                        if (Block.blocksList[var19].blockMaterial == Material.lava) {
                            this.mc.effectRenderer.addEffect(new EntitySmokeFX(var3, (float)var16 + var20, (double)((float)var18 + 0.1f) - Block.blocksList[var19].minY, (float)var17 + var21, 0.0, 0.0, 0.0, false));
                        } else {
                            if (this.random.nextInt(++var14) == 0) {
                                var8 = (float)var16 + var20;
                                var10 = (double)((float)var18 + 0.1f) - Block.blocksList[var19].minY;
                                var12 = (float)var17 + var21;
                            }
                            this.mc.effectRenderer.addEffect(new EntityRainFX(var3, (float)var16 + var20, (double)((float)var18 + 0.1f) - Block.blocksList[var19].minY, (float)var17 + var21));
                        }
                    }
                }
                ++var15;
            }
            if (var14 > 0 && this.random.nextInt(3) < this.rainSoundCounter++) {
                this.rainSoundCounter = 0;
                if (var10 > var2.posY + 1.0 && var3.findTopSolidBlock(MathHelper.floor_double(var2.posX), MathHelper.floor_double(var2.posZ)) > MathHelper.floor_double(var2.posY)) {
                    this.mc.theWorld.playSoundEffect(var8, var10, var12, "ambient.weather.rain", 0.1f, 0.5f);
                } else {
                    this.mc.theWorld.playSoundEffect(var8, var10, var12, "ambient.weather.rain", 0.2f, 1.0f);
                }
            }
        }
    }

    protected void renderRainSnow(float var1) {
        float var2 = this.mc.theWorld.func_27162_g(var1);
        if (var2 > 0.0f) {
            float var26;
            int var24;
            int var23;
            int var22;
            BiomeGenBase var21;
            int var20;
            EntityLiving var3 = this.mc.renderViewEntity;
            World var4 = this.mc.theWorld;
            int var5 = MathHelper.floor_double(var3.posX);
            int var6 = MathHelper.floor_double(var3.posY);
            int var7 = MathHelper.floor_double(var3.posZ);
            Tessellator var8 = Tessellator.instance;
            GL11.glDisable((int)2884);
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glAlphaFunc((int)516, (float)0.01f);
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/environment/snow.png"));
            double var9 = var3.lastTickPosX + (var3.posX - var3.lastTickPosX) * (double)var1;
            double var11 = var3.lastTickPosY + (var3.posY - var3.lastTickPosY) * (double)var1;
            double var13 = var3.lastTickPosZ + (var3.posZ - var3.lastTickPosZ) * (double)var1;
            int var15 = MathHelper.floor_double(var11);
            int var16 = 5;
            if (this.mc.gameSettings.fancyGraphics) {
                var16 = 10;
            }
            BiomeGenBase[] var17 = var4.getWorldChunkManager().func_4069_a(var5 - var16, var7 - var16, var16 * 2 + 1, var16 * 2 + 1);
            int var18 = 0;
            int var19 = var5 - var16;
            while (var19 <= var5 + var16) {
                var20 = var7 - var16;
                while (var20 <= var7 + var16) {
                    if ((var21 = var17[var18++]).getEnableSnow()) {
                        var22 = var4.findTopSolidBlock(var19, var20);
                        if (var22 < 0) {
                            var22 = 0;
                        }
                        var23 = var22;
                        if (var22 < var15) {
                            var23 = var15;
                        }
                        var24 = var6 - var16;
                        int var25 = var6 + var16;
                        if (var24 < var22) {
                            var24 = var22;
                        }
                        if (var25 < var22) {
                            var25 = var22;
                        }
                        var26 = 1.0f;
                        if (var24 != var25) {
                            this.random.setSeed(var19 * var19 * 3121 + var19 * 45238971 + var20 * var20 * 418711 + var20 * 13761);
                            float var27 = (float)this.rendererUpdateCount + var1;
                            float var28 = ((float)(this.rendererUpdateCount & 0x1FF) + var1) / 512.0f;
                            float var29 = this.random.nextFloat() + var27 * 0.01f * (float)this.random.nextGaussian();
                            float var30 = this.random.nextFloat() + var27 * (float)this.random.nextGaussian() * 0.001f;
                            double var31 = (double)((float)var19 + 0.5f) - var3.posX;
                            double var33 = (double)((float)var20 + 0.5f) - var3.posZ;
                            float var35 = MathHelper.sqrt_double(var31 * var31 + var33 * var33) / (float)var16;
                            var8.startDrawingQuads();
                            float var36 = var4.getLightBrightness(var19, var23, var20);
                            GL11.glColor4f((float)var36, (float)var36, (float)var36, (float)(((1.0f - var35 * var35) * 0.3f + 0.5f) * var2));
                            var8.setTranslationD(-var9 * 1.0, -var11 * 1.0, -var13 * 1.0);
                            var8.addVertexWithUV(var19 + 0, var24, (double)var20 + 0.5, 0.0f * var26 + var29, (float)var24 * var26 / 4.0f + var28 * var26 + var30);
                            var8.addVertexWithUV(var19 + 1, var24, (double)var20 + 0.5, 1.0f * var26 + var29, (float)var24 * var26 / 4.0f + var28 * var26 + var30);
                            var8.addVertexWithUV(var19 + 1, var25, (double)var20 + 0.5, 1.0f * var26 + var29, (float)var25 * var26 / 4.0f + var28 * var26 + var30);
                            var8.addVertexWithUV(var19 + 0, var25, (double)var20 + 0.5, 0.0f * var26 + var29, (float)var25 * var26 / 4.0f + var28 * var26 + var30);
                            var8.addVertexWithUV((double)var19 + 0.5, var24, var20 + 0, 0.0f * var26 + var29, (float)var24 * var26 / 4.0f + var28 * var26 + var30);
                            var8.addVertexWithUV((double)var19 + 0.5, var24, var20 + 1, 1.0f * var26 + var29, (float)var24 * var26 / 4.0f + var28 * var26 + var30);
                            var8.addVertexWithUV((double)var19 + 0.5, var25, var20 + 1, 1.0f * var26 + var29, (float)var25 * var26 / 4.0f + var28 * var26 + var30);
                            var8.addVertexWithUV((double)var19 + 0.5, var25, var20 + 0, 0.0f * var26 + var29, (float)var25 * var26 / 4.0f + var28 * var26 + var30);
                            var8.setTranslationD(0.0, 0.0, 0.0);
                            var8.draw();
                        }
                    }
                    ++var20;
                }
                ++var19;
            }
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/environment/rain.png"));
            if (this.mc.gameSettings.fancyGraphics) {
                var16 = 10;
            }
            var18 = 0;
            var19 = var5 - var16;
            while (var19 <= var5 + var16) {
                var20 = var7 - var16;
                while (var20 <= var7 + var16) {
                    if ((var21 = var17[var18++]).canSpawnLightningBolt()) {
                        var22 = var4.findTopSolidBlock(var19, var20);
                        var23 = var6 - var16;
                        var24 = var6 + var16;
                        if (var23 < var22) {
                            var23 = var22;
                        }
                        if (var24 < var22) {
                            var24 = var22;
                        }
                        float var37 = 1.0f;
                        if (var23 != var24) {
                            this.random.setSeed(var19 * var19 * 3121 + var19 * 45238971 + var20 * var20 * 418711 + var20 * 13761);
                            var26 = ((float)(this.rendererUpdateCount + var19 * var19 * 3121 + var19 * 45238971 + var20 * var20 * 418711 + var20 * 13761 & 0x1F) + var1) / 32.0f * (3.0f + this.random.nextFloat());
                            double var38 = (double)((float)var19 + 0.5f) - var3.posX;
                            double var39 = (double)((float)var20 + 0.5f) - var3.posZ;
                            float var40 = MathHelper.sqrt_double(var38 * var38 + var39 * var39) / (float)var16;
                            var8.startDrawingQuads();
                            float var32 = var4.getLightBrightness(var19, 128, var20) * 0.85f + 0.15f;
                            GL11.glColor4f((float)var32, (float)var32, (float)var32, (float)(((1.0f - var40 * var40) * 0.5f + 0.5f) * var2));
                            var8.setTranslationD(-var9 * 1.0, -var11 * 1.0, -var13 * 1.0);
                            var8.addVertexWithUV(var19 + 0, var23, (double)var20 + 0.5, 0.0f * var37, (float)var23 * var37 / 4.0f + var26 * var37);
                            var8.addVertexWithUV(var19 + 1, var23, (double)var20 + 0.5, 1.0f * var37, (float)var23 * var37 / 4.0f + var26 * var37);
                            var8.addVertexWithUV(var19 + 1, var24, (double)var20 + 0.5, 1.0f * var37, (float)var24 * var37 / 4.0f + var26 * var37);
                            var8.addVertexWithUV(var19 + 0, var24, (double)var20 + 0.5, 0.0f * var37, (float)var24 * var37 / 4.0f + var26 * var37);
                            var8.addVertexWithUV((double)var19 + 0.5, var23, var20 + 0, 0.0f * var37, (float)var23 * var37 / 4.0f + var26 * var37);
                            var8.addVertexWithUV((double)var19 + 0.5, var23, var20 + 1, 1.0f * var37, (float)var23 * var37 / 4.0f + var26 * var37);
                            var8.addVertexWithUV((double)var19 + 0.5, var24, var20 + 1, 1.0f * var37, (float)var24 * var37 / 4.0f + var26 * var37);
                            var8.addVertexWithUV((double)var19 + 0.5, var24, var20 + 0, 0.0f * var37, (float)var24 * var37 / 4.0f + var26 * var37);
                            var8.setTranslationD(0.0, 0.0, 0.0);
                            var8.draw();
                        }
                    }
                    ++var20;
                }
                ++var19;
            }
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
            GL11.glAlphaFunc((int)516, (float)0.1f);
        }
    }

    public void func_905_b() {
        ScaledResolution var1 = new ScaledResolution(this.mc.gameSettings, this.mc.displayWidth, this.mc.displayHeight);
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)var1.field_25121_a, (double)var1.field_25120_b, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    private void updateFogColor(float var1) {
        float var12;
        float var11;
        World var2 = this.mc.theWorld;
        EntityLiving var3 = this.mc.renderViewEntity;
        float var4 = 1.0f / (float)(4 - this.mc.gameSettings.renderDistance);
        var4 = 1.0f - (float)Math.pow(var4, 0.25);
        Vec3D var5 = var2.func_4079_a(this.mc.renderViewEntity, var1);
        float var6 = (float)var5.xCoord;
        float var7 = (float)var5.yCoord;
        float var8 = (float)var5.zCoord;
        Vec3D var9 = var2.getFogColor(var1);
        this.fogColorRed = (float)var9.xCoord;
        this.fogColorGreen = (float)var9.yCoord;
        this.fogColorBlue = (float)var9.zCoord;
        this.fogColorRed += (var6 - this.fogColorRed) * var4;
        this.fogColorGreen += (var7 - this.fogColorGreen) * var4;
        this.fogColorBlue += (var8 - this.fogColorBlue) * var4;
        float var10 = var2.func_27162_g(var1);
        if (var10 > 0.0f) {
            var11 = 1.0f - var10 * 0.5f;
            var12 = 1.0f - var10 * 0.4f;
            this.fogColorRed *= var11;
            this.fogColorGreen *= var11;
            this.fogColorBlue *= var12;
        }
        if ((var11 = var2.func_27166_f(var1)) > 0.0f) {
            var12 = 1.0f - var11 * 0.5f;
            this.fogColorRed *= var12;
            this.fogColorGreen *= var12;
            this.fogColorBlue *= var12;
        }
        if (this.cloudFog) {
            Vec3D var16 = var2.func_628_d(var1);
            this.fogColorRed = (float)var16.xCoord;
            this.fogColorGreen = (float)var16.yCoord;
            this.fogColorBlue = (float)var16.zCoord;
        } else if (var3.isInsideOfMaterial(Material.water)) {
            this.fogColorRed = 0.02f;
            this.fogColorGreen = 0.02f;
            this.fogColorBlue = 0.2f;
        } else if (var3.isInsideOfMaterial(Material.lava)) {
            this.fogColorRed = 0.6f;
            this.fogColorGreen = 0.1f;
            this.fogColorBlue = 0.0f;
        }
        var12 = this.fogColor2 + (this.fogColor1 - this.fogColor2) * var1;
        this.fogColorRed *= var12;
        this.fogColorGreen *= var12;
        this.fogColorBlue *= var12;
        if (this.mc.gameSettings.anaglyph) {
            float var13 = (this.fogColorRed * 30.0f + this.fogColorGreen * 59.0f + this.fogColorBlue * 11.0f) / 100.0f;
            float var14 = (this.fogColorRed * 30.0f + this.fogColorGreen * 70.0f) / 100.0f;
            float var15 = (this.fogColorRed * 30.0f + this.fogColorBlue * 70.0f) / 100.0f;
            this.fogColorRed = var13;
            this.fogColorGreen = var14;
            this.fogColorBlue = var15;
        }
        GL11.glClearColor((float)this.fogColorRed, (float)this.fogColorGreen, (float)this.fogColorBlue, (float)0.0f);
    }

    private void setupFog(int var1, float var2) {
        EntityLiving var3 = this.mc.renderViewEntity;
        GL11.glFog((int)2918, (FloatBuffer)this.func_908_a(this.fogColorRed, this.fogColorGreen, this.fogColorBlue, 1.0f));
        GL11.glNormal3f((float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.cloudFog) {
            GL11.glFogi((int)2917, (int)2048);
            GL11.glFogf((int)2914, (float)0.1f);
            float var4 = 1.0f;
            float var5 = 1.0f;
            float var6 = 1.0f;
            if (this.mc.gameSettings.anaglyph) {
                float var7 = (var4 * 30.0f + var5 * 59.0f + var6 * 11.0f) / 100.0f;
                float var8 = (var4 * 30.0f + var5 * 70.0f) / 100.0f;
                float f = (var4 * 30.0f + var6 * 70.0f) / 100.0f;
            }
        } else if (var3.isInsideOfMaterial(Material.water)) {
            GL11.glFogi((int)2917, (int)2048);
            GL11.glFogf((int)2914, (float)0.1f);
            float var4 = 0.4f;
            float var5 = 0.4f;
            float var6 = 0.9f;
            if (this.mc.gameSettings.anaglyph) {
                float var7 = (var4 * 30.0f + var5 * 59.0f + var6 * 11.0f) / 100.0f;
                float var8 = (var4 * 30.0f + var5 * 70.0f) / 100.0f;
                float f = (var4 * 30.0f + var6 * 70.0f) / 100.0f;
            }
        } else if (var3.isInsideOfMaterial(Material.lava)) {
            GL11.glFogi((int)2917, (int)2048);
            GL11.glFogf((int)2914, (float)2.0f);
            float var4 = 0.4f;
            float var5 = 0.3f;
            float var6 = 0.3f;
            if (this.mc.gameSettings.anaglyph) {
                float var7 = (var4 * 30.0f + var5 * 59.0f + var6 * 11.0f) / 100.0f;
                float var8 = (var4 * 30.0f + var5 * 70.0f) / 100.0f;
                float f = (var4 * 30.0f + var6 * 70.0f) / 100.0f;
            }
        } else {
            GL11.glFogi((int)2917, (int)9729);
            GL11.glFogf((int)2915, (float)(this.farPlaneDistance * 0.25f));
            GL11.glFogf((int)2916, (float)this.farPlaneDistance);
            if (var1 < 0) {
                GL11.glFogf((int)2915, (float)0.0f);
                GL11.glFogf((int)2916, (float)(this.farPlaneDistance * 0.8f));
            }
            if (GLContext.getCapabilities().GL_NV_fog_distance) {
                GL11.glFogi((int)34138, (int)34139);
            }
            if (this.mc.theWorld.worldProvider.isNether) {
                GL11.glFogf((int)2915, (float)0.0f);
            }
        }
        GL11.glEnable((int)2903);
        GL11.glColorMaterial((int)1028, (int)4608);
    }

    private FloatBuffer func_908_a(float var1, float var2, float var3, float var4) {
        this.fogColorBuffer.clear();
        this.fogColorBuffer.put(var1).put(var2).put(var3).put(var4);
        this.fogColorBuffer.flip();
        return this.fogColorBuffer;
    }
}

